/*
 * Decompiled with CFR 0.152.
 */
package JACE.SOCK_SAP;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SOCKStream {
    private Socket socket_;
    private DataInputStream iStream_;
    private DataOutputStream oStream_;

    public SOCKStream() {
    }

    public SOCKStream(Socket socket) throws IOException {
        this.socket(socket);
    }

    public void socket(Socket socket) throws IOException {
        this.socket_ = socket;
        this.iStream_ = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.oStream_ = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public Socket socket() {
        return this.socket_;
    }

    public void close() throws IOException {
        if (this.socket_ != null) {
            this.socket_.close();
        }
        this.socket_ = null;
    }

    public int send(StringBuffer stringBuffer) throws IOException {
        String string = stringBuffer.toString();
        this.oStream_.writeChars(string.toString());
        this.oStream_.writeChar(10);
        this.oStream_.flush();
        return string.length();
    }

    public int send(String string) throws IOException {
        this.oStream_.writeChars(string);
        this.oStream_.writeChar(10);
        this.oStream_.flush();
        return string.length();
    }

    public int sendN(byte[] byArray, int n, int n2) throws IOException {
        this.oStream_.write(byArray, n, n2);
        this.oStream_.flush();
        return n2;
    }

    public int recv(StringBuffer stringBuffer) throws IOException {
        int n = 0;
        char c = (char)this.iStream_.readByte();
        while (c != '\n') {
            stringBuffer.append(c);
            c = (char)this.iStream_.readByte();
            ++n;
        }
        return n;
    }

    public int recvN(byte[] byArray, int n, int n2) throws IOException {
        this.iStream_.readFully(byArray, n, n2);
        return n2;
    }

    public int recvInt() throws IOException {
        int n = this.iStream_.readInt();
        return n;
    }

    public short recvShortInt() throws IOException {
        short s = this.iStream_.readShort();
        return s;
    }

    public void inputStream(InputStream inputStream) {
        this.iStream_ = new DataInputStream(new BufferedInputStream(inputStream));
    }

    public InputStream inputStream() {
        return this.iStream_;
    }

    public void outputStream(OutputStream outputStream) {
        this.oStream_ = new DataOutputStream(new BufferedOutputStream(outputStream));
    }

    public OutputStream outputStream() {
        return this.oStream_;
    }

    public DataOutputStream dataOutputStream() {
        return this.oStream_;
    }

    public DataInputStream dataInputStream() {
        return this.iStream_;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

