/*
 * Decompiled with CFR 0.152.
 */
package JACE.Reactor;

import JACE.ASX.TimeValue;
import JACE.ASX.TimedWait;
import JACE.ASX.TimeoutException;
import JACE.OS.ACE;
import JACE.Reactor.EventHandler;

public class TimerQueue
implements Runnable {
    private WaitObject obj_ = new WaitObject();
    private TimerNode head_;
    private int timerId_;
    private boolean reset_;
    private boolean eventLoopRunning_ = false;

    public TimerQueue() {
        this(false);
    }

    public TimerQueue(boolean bl) {
        if (bl) {
            Thread thread = new Thread((Runnable)this, "Timer Queue");
            thread.setDaemon(true);
            thread.start();
        }
    }

    @Override
    public void run() {
        this.handleEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents() {
        if (!this.eventLoopRunning_) {
            this.eventLoopRunning_ = true;
            while (true) {
                WaitObject waitObject = this.obj_;
                synchronized (waitObject) {
                    try {
                        this.obj_.timedWait(this.earliestTime());
                        if (this.reset_) {
                            this.reset_ = false;
                            this.obj_.condition(false);
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        this.dispatchHandlers();
                    }
                    catch (InterruptedException interruptedException) {
                        ACE.ERROR("TimerQueue was interrupted");
                        return;
                    }
                }
            }
        }
    }

    boolean isEmpty() {
        return this.head_ == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimeValue earliestTime() {
        WaitObject waitObject = this.obj_;
        synchronized (waitObject) {
            if (!this.isEmpty()) {
                return this.head_.timerValue_;
            }
            return null;
        }
    }

    public int scheduleTimer(EventHandler eventHandler, Object object, TimeValue timeValue) {
        return this.scheduleTimer(eventHandler, object, timeValue, TimeValue.zero);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scheduleTimer(EventHandler eventHandler, Object object, TimeValue timeValue, TimeValue timeValue2) {
        ++this.timerId_;
        ACE.DEBUG("scheduleTimer (" + this.timerId_ + "): " + timeValue + ", " + timeValue2);
        TimeValue timeValue3 = TimeValue.plus(timeValue, TimeValue.getTimeOfDay());
        TimerNode timerNode = new TimerNode(eventHandler, object, timeValue3, timeValue2, null, this.timerId_);
        WaitObject waitObject = this.obj_;
        synchronized (waitObject) {
            if (this.eventLoopRunning_ && (this.isEmpty() || timeValue3.lessThan(this.earliestTime()))) {
                this.reschedule(timerNode);
                this.obj_.notify();
            } else {
                this.reschedule(timerNode);
            }
        }
        return this.timerId_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cancelTimer(int n) {
        TimerNode timerNode = null;
        TimerNode timerNode2 = null;
        WaitObject waitObject = this.obj_;
        synchronized (waitObject) {
            timerNode2 = this.head_;
            while (timerNode2 != null && timerNode2.timerId_ != n) {
                timerNode = timerNode2;
                timerNode2 = timerNode2.next_;
            }
            if (timerNode2 != null) {
                if (timerNode == null) {
                    this.head_ = timerNode2.next_;
                } else {
                    timerNode.next_ = timerNode2.next_;
                }
                return timerNode2.arg_;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimer(EventHandler eventHandler) {
        TimerNode timerNode = null;
        TimerNode timerNode2 = this.head_;
        WaitObject waitObject = this.obj_;
        synchronized (waitObject) {
            while (timerNode2 != null) {
                if (timerNode2.handler_ == eventHandler) {
                    if (timerNode == null) {
                        timerNode2 = this.head_ = timerNode2.next_;
                        continue;
                    }
                    timerNode2 = timerNode.next_ = timerNode2.next_;
                    continue;
                }
                timerNode = timerNode2;
                timerNode2 = timerNode2.next_;
            }
        }
    }

    private void dispatchHandlers() {
        TimeValue timeValue = TimeValue.getTimeOfDay();
        while (!this.isEmpty() && !this.earliestTime().greaterThan(timeValue)) {
            TimerNode timerNode = this.head_;
            EventHandler eventHandler = timerNode.handler_;
            Object object = timerNode.arg_;
            this.head_ = this.head_.next_;
            if (timerNode.interval_.greaterThan(TimeValue.zero)) {
                do {
                    timerNode.timerValue_.plusEquals(timerNode.interval_);
                } while (timerNode.timerValue_.lessThanEqual(timeValue));
                this.reschedule(timerNode);
            }
            ACE.DEBUG("Calling handleTimeout for ID " + timerNode.timerId_);
            int n = eventHandler.handleTimeout(timeValue, object);
            if (n != -1) continue;
            this.cancelTimer(eventHandler);
        }
    }

    private void reschedule(TimerNode timerNode) {
        if (this.isEmpty() || timerNode.timerValue_.lessThan(this.earliestTime())) {
            timerNode.next_ = this.head_;
            this.head_ = timerNode;
            this.obj_.condition(true);
            this.reset_ = true;
        } else {
            TimerNode timerNode2 = this.head_;
            TimerNode timerNode3 = this.head_.next_;
            while (timerNode3 != null && timerNode.timerValue_.greaterThan(timerNode3.timerValue_)) {
                timerNode2 = timerNode3;
                timerNode3 = timerNode3.next_;
            }
            timerNode.next_ = timerNode3;
            timerNode2.next_ = timerNode;
        }
    }

    public boolean eventLoopRunning() {
        return this.eventLoopRunning_;
    }

    static class WaitObject
    extends TimedWait {
        private boolean condition_ = false;

        WaitObject() {
        }

        @Override
        public boolean condition() {
            return this.condition_;
        }

        public void condition(boolean bl) {
            this.condition_ = bl;
        }
    }

    static class TimerNode {
        public EventHandler handler_;
        public Object arg_;
        public TimeValue timerValue_;
        public TimeValue interval_;
        public TimerNode next_;
        public int timerId_;

        public TimerNode(EventHandler eventHandler, Object object, TimeValue timeValue, TimeValue timeValue2, TimerNode timerNode, int n) {
            this.handler_ = eventHandler;
            this.arg_ = object;
            this.timerValue_ = timeValue;
            this.interval_ = timeValue2;
            this.next_ = timerNode;
            this.timerId_ = n;
        }
    }
}

