/*
 * Decompiled with CFR 0.152.
 */
package JACE.Connection;

import JACE.ASX.MessageBlock;
import JACE.Connection.BlobHandler;
import JACE.Connection.HTTPHelper;
import JACE.OS.ACE;
import java.io.IOException;

public class BlobWriter
extends BlobHandler {
    protected String authentication_ = null;
    protected String protocol_ = "http://";
    protected int bytesWritten_ = 0;
    protected MessageBlock mb_ = null;
    protected String requestPrefix_ = "PUT";
    protected String requestSuffix_ = "HTTP/1.0\n";
    protected String replyPrefix_ = "HTTP/1.0";
    protected int returnCode_;

    public BlobWriter(MessageBlock messageBlock, int n, int n2, String string) {
        super(n, n2, string);
        this.mb_ = messageBlock;
        this.returnCode_ = -1;
    }

    public BlobWriter(MessageBlock messageBlock, int n, int n2, String string, String string2) {
        super(n, n2, string);
        this.mb_ = messageBlock;
        this.returnCode_ = -1;
        this.authentication_ = string2;
    }

    @Override
    public int open(Object object) {
        if (this.sendRequest() != 0) {
            ACE.ERROR("BlobWriter::open():sendRequest failed");
            return -1;
        }
        if (this.receiveReply() != 0) {
            ACE.ERROR("BlobWriter::open():receiveReply failed");
            return -1;
        }
        return 0;
    }

    @Override
    public int close(long l) {
        return 0;
    }

    public int bytesWritten() {
        return this.bytesWritten_;
    }

    protected int sendRequest() {
        if (this.offset_ + this.length_ > this.mb_.length()) {
            ACE.ERROR("BlobWriter::sendRequest():Invalid offset/length");
            return -1;
        }
        if (this.sendHeader() == -1) {
            ACE.ERROR("BlobWriter::sendHeader failed.");
            return -1;
        }
        if (this.sendData() == -1) {
            ACE.ERROR("BlobWriter::sendData failed.");
            return -1;
        }
        return 0;
    }

    protected int sendHeader() {
        String string = this.filename_;
        if (!this.filename_.startsWith("/")) {
            string = "/" + this.filename_;
        }
        String string2 = this.requestPrefix_ + " " + string + " " + this.requestSuffix_;
        if (this.authentication_ != null) {
            string2 = string2 + "Authorization: Basic " + HTTPHelper.EncodeBase64(this.authentication_) + '\n';
        }
        string2 = string2 + "Content-length: " + this.length_ + "\n";
        try {
            if (this.peer().send(string2) < 0) {
                ACE.ERROR("Error sending request");
                return -1;
            }
        }
        catch (IOException iOException) {
            ACE.ERROR(iOException);
            return -1;
        }
        return 0;
    }

    protected int sendData() {
        String string = this.mb_.base().substring(this.offset_, this.offset_ + this.length_);
        try {
            if (this.peer().send(string) != this.length_) {
                ACE.ERROR("Error sending file");
                return -1;
            }
        }
        catch (IOException iOException) {
            ACE.ERROR(iOException);
            return -1;
        }
        this.bytesWritten_ = this.length_;
        return 0;
    }

    protected int receiveReply() {
        System.out.println("Waiting for reply");
        StringBuffer stringBuffer = new StringBuffer(1024);
        try {
            if (this.peer().recv(stringBuffer) < 0) {
                ACE.ERROR("Error receiving reply from server");
                return -1;
            }
        }
        catch (IOException iOException) {
            ACE.ERROR(iOException);
        }
        String string = stringBuffer.toString();
        int n = -1;
        n = string.indexOf(this.replyPrefix_);
        if (n == -1) {
            ACE.ERROR("Error receiving reply from server");
            return -1;
        }
        int n2 = n + this.replyPrefix_.length() + 1;
        String string2 = string.substring(n2, n2 + 3);
        this.returnCode_ = new Integer(string2);
        if (this.returnCode_ >= 200 && this.returnCode_ < 300) {
            System.out.println("We got the goodies!");
            return 0;
        }
        return -1;
    }

    public int returnCode() {
        return this.returnCode_;
    }
}

