/*
 * Decompiled with CFR 0.152.
 */
package JACE.Concurrency;

import JACE.ASX.TimeValue;
import JACE.ASX.TimedWait;
import JACE.ASX.TimeoutException;
import JACE.Concurrency.LockAdapter;
import JACE.Concurrency.RenewObject;
import java.util.Hashtable;
import java.util.Vector;

public class Semaphore
extends LockAdapter {
    private TimedWaitSAdapter monitor_ = new TimedWaitSAdapter(this);
    private Hashtable owners_;
    private Vector renewers_ = new Vector();
    private int numberOfWaiters_ = 0;

    public Semaphore(int n) {
        this.monitor_.count(n);
        this.owners_ = new Hashtable(n);
    }

    public Semaphore() {
        this.monitor_.count(1);
        this.owners_ = new Hashtable(1);
    }

    @Override
    public synchronized int tryAcquire() {
        if (this.monitor_.condition()) {
            this.monitor_.decrement();
            this.setOwner();
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int acquire(TimeValue timeValue) throws TimeoutException, InterruptedException {
        if (this.monitor_.condition()) {
            this.monitor_.decrement();
            this.setOwner();
            return 0;
        }
        ++this.numberOfWaiters_;
        try {
            this.sleepHook();
            this.monitor_.timedWait(timeValue);
        }
        finally {
            --this.numberOfWaiters_;
        }
        this.monitor_.decrement();
        this.setOwner();
        return 1;
    }

    @Override
    public synchronized int release() {
        if (!this.isOwner()) {
            return -1;
        }
        if (!this.signalNextRenewer()) {
            this.monitor_.increment();
            this.monitor_.signal();
            this.clearOwner();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean signalNextRenewer() {
        if (this.renewers_.size() > 0) {
            RenewObject renewObject = (RenewObject)this.renewers_.elementAt(this.renewers_.size() - 1);
            renewObject.decrementYieldTo();
            for (int i = this.renewers_.size() - 2; i >= 0; --i) {
                RenewObject renewObject2 = (RenewObject)this.renewers_.elementAt(i);
                renewObject2.decrementYieldTo();
                renewObject = renewObject.min(renewObject2);
            }
            if (renewObject.condition() || this.numberOfWaiters_ == 0) {
                this.renewers_.removeElement(renewObject);
                RenewObject renewObject3 = renewObject;
                synchronized (renewObject3) {
                    renewObject.signal();
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int renew(int n, TimeValue timeValue) throws InterruptedException, TimeoutException {
        Object object;
        RenewObject renewObject;
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (!this.isOwner()) {
                return -1;
            }
            if (this.numberOfWaiters_ == 0 || n == 0 || this.monitor_.condition()) {
                return 0;
            }
            if (n < 0 || n > this.numberOfWaiters_) {
                n = this.numberOfWaiters_;
            }
            renewObject = new RenewObject(n);
            this.release();
            this.renewers_.addElement(renewObject);
        }
        boolean bl = true;
        try {
            object = renewObject;
            synchronized (object) {
                renewObject.timedWait(timeValue);
                bl = false;
            }
        }
        finally {
            object = this;
            synchronized (object) {
                if (bl) {
                    if (!this.renewers_.removeElement(renewObject)) {
                        this.setOwner();
                        this.release();
                    }
                } else {
                    this.setOwner();
                }
            }
        }
        return 0;
    }

    @Override
    protected boolean isOwner() {
        return this.owners_.containsKey(this.accessorID());
    }

    @Override
    protected void setOwner() {
        this.owners_.put(this.accessorID(), this);
    }

    @Override
    protected void clearOwner() {
        this.owners_.remove(this.accessorID());
    }

    static class TimedWaitSAdapter
    extends TimedWait {
        private int count_ = 0;

        TimedWaitSAdapter(Object object) {
            super(object);
        }

        @Override
        public boolean condition() {
            return this.count_ > 0;
        }

        public void increment() {
            ++this.count_;
        }

        public void decrement() {
            --this.count_;
        }

        public void count(int n) {
            this.count_ = n;
        }

        public int count() {
            return this.count_;
        }
    }
}

