/*
 * Decompiled with CFR 0.152.
 */
package JACE.Concurrency;

import JACE.ASX.TimeValue;
import JACE.ASX.TimeoutException;
import JACE.Concurrency.LockAdapter;
import JACE.Concurrency.RenewObject;
import JACE.Concurrency.WaitObject;
import java.util.Vector;

public class Mutex
extends LockAdapter {
    protected WaitObject monitor_ = new WaitObject(true, this);
    protected Vector renewers_ = new Vector();
    protected int numberOfWaiters_ = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int acquire() throws InterruptedException {
        if (this.monitor_.condition()) {
            this.monitor_.condition(false);
            this.setOwner();
            return 0;
        }
        ++this.numberOfWaiters_;
        try {
            this.sleepHook();
            this.monitor_.timedWait();
        }
        finally {
            --this.numberOfWaiters_;
        }
        this.monitor_.condition(false);
        this.setOwner();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int renew(int n, TimeValue timeValue) throws InterruptedException, TimeoutException {
        Object object;
        RenewObject renewObject;
        Mutex mutex = this;
        synchronized (mutex) {
            if (!this.isOwner()) {
                return -1;
            }
            if (this.numberOfWaiters_ == 0 || n == 0) {
                return 0;
            }
            if (n < 0 || n > this.numberOfWaiters_) {
                n = this.numberOfWaiters_;
            }
            renewObject = new RenewObject(n);
            this.release();
            this.renewers_.addElement(renewObject);
        }
        boolean bl = true;
        try {
            object = renewObject;
            synchronized (object) {
                renewObject.timedWait(timeValue);
                bl = false;
            }
        }
        finally {
            if (bl) {
                object = this;
                synchronized (object) {
                    if (!this.renewers_.removeElement(renewObject)) {
                        this.setOwner();
                        this.release();
                    }
                }
            }
        }
        object = this;
        synchronized (object) {
            this.setOwner();
        }
        return 0;
    }

    @Override
    public synchronized int tryAcquire() {
        if (this.monitor_.condition()) {
            this.monitor_.condition(false);
            this.setOwner();
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int acquire(TimeValue timeValue) throws TimeoutException, InterruptedException {
        if (this.monitor_.condition()) {
            this.monitor_.condition(false);
            this.setOwner();
            return 0;
        }
        ++this.numberOfWaiters_;
        try {
            this.sleepHook();
            this.monitor_.timedWait(timeValue);
        }
        finally {
            --this.numberOfWaiters_;
        }
        this.monitor_.condition(false);
        this.setOwner();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean signalNextRenewer() {
        if (this.renewers_.size() > 0) {
            RenewObject renewObject = (RenewObject)this.renewers_.elementAt(this.renewers_.size() - 1);
            renewObject.decrementYieldTo();
            for (int i = this.renewers_.size() - 2; i >= 0; --i) {
                RenewObject renewObject2 = (RenewObject)this.renewers_.elementAt(i);
                renewObject2.decrementYieldTo();
                renewObject = renewObject.min(renewObject2);
            }
            if (renewObject.condition() || this.numberOfWaiters_ == 0) {
                this.renewers_.removeElement(renewObject);
                RenewObject renewObject3 = renewObject;
                synchronized (renewObject3) {
                    renewObject.signal();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int release() {
        if (!this.isOwner()) {
            return -1;
        }
        if (!this.signalNextRenewer()) {
            this.monitor_.condition(true);
            this.monitor_.signal();
        }
        return 0;
    }
}

