/*
 * Decompiled with CFR 0.152.
 */
package JACE.Concurrency;

import JACE.ASX.TimeValue;
import JACE.ASX.TimeoutException;
import JACE.Concurrency.AbstractLock;

public abstract class LockAdapter
implements AbstractLock {
    private Object owner_;

    @Override
    public int acquire() throws InterruptedException {
        try {
            return this.acquire(null);
        }
        catch (TimeoutException timeoutException) {
            return -1;
        }
    }

    @Override
    public abstract int acquire(TimeValue var1) throws TimeoutException, InterruptedException;

    @Override
    public int acquireRead() throws InterruptedException {
        try {
            return this.acquireRead(null);
        }
        catch (TimeoutException timeoutException) {
            return -1;
        }
    }

    @Override
    public int acquireRead(TimeValue timeValue) throws TimeoutException, InterruptedException {
        return this.acquire(timeValue);
    }

    @Override
    public int acquireWrite() throws InterruptedException {
        try {
            return this.acquire(null);
        }
        catch (TimeoutException timeoutException) {
            return -1;
        }
    }

    @Override
    public int acquireWrite(TimeValue timeValue) throws TimeoutException, InterruptedException {
        return this.acquire(timeValue);
    }

    @Override
    public int renew(int n) throws InterruptedException {
        try {
            return this.renew(n, null);
        }
        catch (TimeoutException timeoutException) {
            return -1;
        }
    }

    @Override
    public abstract int renew(int var1, TimeValue var2) throws TimeoutException, InterruptedException;

    @Override
    public int tryAcquireRead() {
        return this.tryAcquire();
    }

    @Override
    public int tryAcquireWrite() {
        return this.tryAcquire();
    }

    @Override
    public abstract int tryAcquire();

    @Override
    public void sleepHook() {
    }

    @Override
    public abstract int release();

    protected Object accessorID() {
        return Thread.currentThread();
    }

    protected boolean isOwner() {
        return this.accessorID().equals(this.owner_);
    }

    protected void setOwner() {
        this.owner_ = this.accessorID();
    }

    protected void clearOwner() {
        this.owner_ = null;
    }
}

