/*
 * Decompiled with CFR 0.152.
 */
package JACE.ASX;

public class TimeValue {
    public static final TimeValue zero = new TimeValue(0L, 0);
    private long millisec_;
    private int nanos_;
    private static final int ONE_MILLISECOND = 1000000;

    public TimeValue() {
        this(0L, 0);
    }

    public TimeValue(long l) {
        this(l, 0);
    }

    public TimeValue(long l, int n) {
        this.set(l, n);
    }

    public void set(long l, int n) {
        this.millisec_ = l * 1000L;
        this.nanos_ = n;
        this.normalize();
    }

    public long sec() {
        return this.millisec_ / 1000L;
    }

    public int nanos() {
        return this.nanos_;
    }

    public long getMilliTime() {
        return this.millisec_;
    }

    public String toString() {
        return new Long(this.millisec_ / 1000L).toString() + ":" + new Integer(this.nanos_).toString();
    }

    public static TimeValue getTimeOfDay() {
        return new TimeValue(System.currentTimeMillis() / 1000L);
    }

    public static TimeValue relativeTimeOfDay(long l, int n) {
        return new TimeValue(System.currentTimeMillis() / 1000L + l, n);
    }

    public static TimeValue relativeTimeOfDay(TimeValue timeValue) {
        return new TimeValue(System.currentTimeMillis() / 1000L + timeValue.sec(), timeValue.nanos());
    }

    public boolean equals(TimeValue timeValue) {
        return this.millisec_ == timeValue.sec() * 1000L && this.nanos_ == timeValue.nanos();
    }

    public boolean notEquals(TimeValue timeValue) {
        return !this.equals(timeValue);
    }

    public static TimeValue plus(TimeValue timeValue, TimeValue timeValue2) {
        TimeValue timeValue3 = new TimeValue(timeValue.sec() + timeValue2.sec(), timeValue.nanos() + timeValue2.nanos());
        timeValue3.normalize();
        return timeValue3;
    }

    public static TimeValue minus(TimeValue timeValue, TimeValue timeValue2) {
        TimeValue timeValue3 = new TimeValue(timeValue.sec() - timeValue2.sec(), timeValue.nanos() - timeValue2.nanos());
        timeValue3.normalize();
        return timeValue3;
    }

    public void plusEquals(TimeValue timeValue) {
        this.set(this.sec() + timeValue.sec(), this.nanos() + timeValue.nanos());
        this.normalize();
    }

    public void minusEquals(TimeValue timeValue) {
        this.set(this.sec() - timeValue.sec(), this.nanos() - timeValue.nanos());
        this.normalize();
    }

    public boolean lessThan(TimeValue timeValue) {
        return timeValue.greaterThan(this);
    }

    public boolean greaterThan(TimeValue timeValue) {
        if (this.sec() > timeValue.sec()) {
            return true;
        }
        return this.sec() == timeValue.sec() && this.nanos() > timeValue.nanos();
    }

    public boolean lessThanEqual(TimeValue timeValue) {
        return timeValue.greaterThanEqual(this);
    }

    public boolean greaterThanEqual(TimeValue timeValue) {
        return this.sec() >= timeValue.sec() && this.nanos() >= timeValue.nanos();
    }

    private void normalize() {
        if (this.nanos_ >= 1000000) {
            do {
                ++this.millisec_;
                this.nanos_ -= 1000000;
            } while (this.nanos_ >= 1000000);
        } else if (this.nanos_ <= -1000000) {
            do {
                --this.millisec_;
                this.nanos_ += 1000000;
            } while (this.nanos_ <= -1000000);
        }
        if (this.millisec_ >= 1L && this.nanos_ < 0) {
            --this.millisec_;
            this.nanos_ += 1000000;
        } else if (this.millisec_ < 0L && this.nanos_ > 0) {
            ++this.millisec_;
            this.nanos_ -= 1000000;
        }
    }
}

