/*
 * Decompiled with CFR 0.152.
 */
package JACE.ASX;

import JACE.ASX.MessageBlock;
import JACE.ASX.MessageQueue;
import JACE.ASX.Module;
import JACE.ASX.TimeValue;
import JACE.Concurrency.ThreadManager;
import JACE.OS.ACE;
import JACE.Reactor.EventHandler;

public abstract class Task
implements Runnable,
EventHandler {
    private ThreadManager thrMgr_ = null;
    private long flags_;
    private MessageQueue msgQueue_;
    private Task next_;
    private Module mod_;

    public Task() {
        this.msgQueue_ = new MessageQueue();
        this.thrMgr_ = null;
    }

    public Task(MessageQueue messageQueue, ThreadManager threadManager) {
        this.msgQueue_ = messageQueue;
        this.thrMgr_ = threadManager;
    }

    @Override
    public void run() {
        this.svc();
    }

    public abstract int open(Object var1);

    public abstract int close(long var1);

    public abstract int put(MessageBlock var1, TimeValue var2);

    public int svc() {
        return 0;
    }

    public synchronized void thrMgr(ThreadManager threadManager) {
        this.thrMgr_ = threadManager;
    }

    public synchronized ThreadManager thrMgr() {
        return this.thrMgr_;
    }

    public synchronized int activate(long l, int n, boolean bl) {
        if (this.thrMgr_ == null) {
            this.thrMgr_ = new ThreadManager();
        }
        if (this.thrCount() > 0 && !bl) {
            return 1;
        }
        this.flags_ = l;
        if (ACE.BIT_ENABLED(l, 256L)) {
            this.thrMgr_.spawnN(n, this, true);
        } else {
            this.thrMgr_.spawnN(n, this, false);
        }
        return 0;
    }

    public synchronized void suspend() {
    }

    public synchronized void resume() {
    }

    public synchronized String grpName() {
        if (this.thrMgr_ != null) {
            return this.thrMgr_.thrGrp().getName();
        }
        return null;
    }

    public MessageQueue msgQueue() {
        return this.msgQueue_;
    }

    public void msgQueue(MessageQueue messageQueue) {
        this.msgQueue_ = messageQueue;
    }

    public synchronized int thrCount() {
        if (this.thrMgr_ != null) {
            return this.thrMgr_.thrGrp().activeCount();
        }
        return 0;
    }

    public synchronized void flags(long l) {
        this.flags_ = l;
    }

    public synchronized long flags() {
        return this.flags_;
    }

    public void dump() {
    }

    protected int putq(MessageBlock messageBlock) throws InterruptedException {
        return this.putq(messageBlock, null);
    }

    protected int putq(MessageBlock messageBlock, TimeValue timeValue) throws InterruptedException {
        return this.msgQueue_.enqueueTail(messageBlock, timeValue);
    }

    protected MessageBlock getq() throws InterruptedException {
        return this.getq(null);
    }

    protected MessageBlock getq(TimeValue timeValue) throws InterruptedException {
        return this.msgQueue_.dequeueHead(timeValue);
    }

    protected int ungetq(MessageBlock messageBlock, TimeValue timeValue) throws InterruptedException {
        return this.msgQueue_.enqueueHead(messageBlock, timeValue);
    }

    protected int putNext(MessageBlock messageBlock, TimeValue timeValue) {
        return this.next_ == null ? -1 : this.next_.put(messageBlock, timeValue);
    }

    protected int reply(MessageBlock messageBlock, TimeValue timeValue) {
        return this.sibling().putNext(messageBlock, timeValue);
    }

    protected String name() {
        if (this.mod_ == null) {
            return null;
        }
        return this.mod_.name();
    }

    protected Task sibling() {
        if (this.mod_ == null) {
            return null;
        }
        return this.mod_.sibling(this);
    }

    protected void module(Module module) {
        this.mod_ = module;
    }

    protected Module module() {
        return this.mod_;
    }

    protected boolean isReader() {
        return ACE.BIT_ENABLED(this.flags_, 1L);
    }

    protected boolean isWriter() {
        return ACE.BIT_DISABLED(this.flags_, 1L);
    }

    protected Task next() {
        return this.next_;
    }

    protected void next(Task task) {
        this.next_ = task;
    }

    protected int flush(long l) {
        if (ACE.BIT_ENABLED(l, 4L)) {
            return this.msgQueue_ == null ? 0 : 1;
        }
        return -1;
    }

    protected void waterMarks(int n, int n2) {
        if (n == 1) {
            this.msgQueue_.lowWaterMark(n2);
        } else {
            this.msgQueue_.highWaterMark(n2);
        }
    }
}

