/*
 * Decompiled with CFR 0.152.
 */
package JACE.ASX;

import JACE.ASX.IOCntlMsg;
import JACE.ASX.MessageBlock;
import JACE.ASX.Module;
import JACE.ASX.StreamHead;
import JACE.ASX.StreamTail;
import JACE.ASX.Task;
import JACE.ASX.TimeValue;
import JACE.OS.ACE;

public class Stream {
    Module streamHead_ = null;
    Module streamTail_ = null;
    Stream linkedUs_ = null;

    public Stream() {
        this(null, null, null);
    }

    public Stream(Object object, Module module, Module module2) {
        if (this.open(object, module, module2) == -1) {
            ACE.ERROR("open" + module.name() + " " + module2.name());
        }
    }

    public int push(Module module) {
        if (this.pushModule(module, this.streamHead_.next(), this.streamHead_) == -1) {
            return -1;
        }
        return 0;
    }

    public int put(MessageBlock messageBlock, TimeValue timeValue) {
        return this.streamHead_.writer().put(messageBlock, timeValue);
    }

    public MessageBlock get(TimeValue timeValue) throws InterruptedException {
        return this.streamHead_.reader().getq(timeValue);
    }

    public Module top() {
        if (this.streamHead_.next() == this.streamTail_) {
            return null;
        }
        return this.streamHead_.next();
    }

    public int pop(long l) {
        if (this.streamHead_.next() == this.streamTail_) {
            return -1;
        }
        Module module = this.streamHead_.next();
        Module module2 = module.next();
        this.streamHead_.next(module2);
        module.close(l);
        this.streamHead_.writer().next(module2.writer());
        module2.reader().next(this.streamHead_.reader());
        return 0;
    }

    public int remove(String string, long l) {
        Module module = null;
        for (Module module2 = this.streamHead_; module2 != null; module2 = module2.next()) {
            if (string.compareTo(module2.name()) == 0) {
                if (module == null) {
                    this.streamHead_.link(module2.next());
                } else {
                    module.link(module2.next());
                }
                module2.close(l);
                return 0;
            }
            module = module2;
        }
        return -1;
    }

    public Module find(String string) {
        for (Module module = this.streamHead_; module != null; module = module.next()) {
            if (string.compareTo(module.name()) != 0) continue;
            return module;
        }
        return null;
    }

    private int pushModule(Module module, Module module2, Module module3) {
        Task task = module.reader();
        Task task2 = module.writer();
        Task task3 = null;
        Task task4 = null;
        if (module2 != null) {
            task3 = module2.reader();
            task4 = module2.writer();
            task3.next(task);
        }
        task2.next(task4);
        if (module3 != null) {
            if (module3 != module) {
                module3.link(module);
            }
        } else {
            task.next(null);
        }
        module.next(module2);
        if (task.open(module.arg()) == -1) {
            return -1;
        }
        if (task2.open(module.arg()) == -1) {
            return -1;
        }
        return 0;
    }

    public synchronized int open(Object object, Module module, Module module2) {
        StreamHead streamHead = null;
        StreamHead streamHead2 = null;
        StreamTail streamTail = null;
        StreamTail streamTail2 = null;
        if (module == null) {
            streamHead = new StreamHead();
            streamHead2 = new StreamHead();
            module = new Module("ACEStreamHead", streamHead, streamHead2, object);
        }
        if (module2 == null) {
            streamTail = new StreamTail();
            streamTail2 = new StreamTail();
            module2 = new Module("ACEStreamTail", streamTail, streamTail2, object);
        }
        if (streamHead == null || streamHead2 == null || module == null || streamTail == null || streamTail2 == null || module2 == null) {
            module.close(0L);
            module2.close(0L);
            return -1;
        }
        this.streamHead_ = module;
        this.streamTail_ = module2;
        if (this.pushModule(this.streamTail_, null, null) == -1) {
            return -1;
        }
        if (this.pushModule(this.streamHead_, this.streamTail_, this.streamHead_) == -1) {
            return -1;
        }
        return 0;
    }

    public synchronized int close(long l) {
        if (this.streamHead_ != null && this.streamTail_ != null) {
            this.unlinkInternal();
            int n = 0;
            while (this.streamHead_.next() != this.streamTail_) {
                if (this.pop(l) != -1) continue;
                n = -1;
            }
            if (this.streamHead_.close(l) == -1) {
                n = -1;
            }
            if (this.streamTail_.close(l) == -1) {
                n = -1;
            }
            this.streamHead_ = null;
            this.streamTail_ = null;
            return n;
        }
        return 0;
    }

    public int control(int n, Object object) throws InterruptedException {
        IOCntlMsg iOCntlMsg = new IOCntlMsg(n);
        MessageBlock messageBlock = new MessageBlock(7, null, object);
        MessageBlock messageBlock2 = new MessageBlock(7, messageBlock, iOCntlMsg);
        int n2 = 0;
        n2 = this.streamHead_.writer().put(messageBlock2, null) == -1 ? -1 : ((messageBlock2 = this.streamHead_.reader().getq(null)) == null ? -1 : ((IOCntlMsg)messageBlock2.obj()).rval());
        return n2;
    }

    private int linkInternal(Stream stream) {
        this.linkedUs_ = stream;
        stream.linkedUs_ = this;
        Module module = this.streamHead_;
        if (module == null) {
            return -1;
        }
        while (module.next() != this.streamTail_) {
            module = module.next();
        }
        Module module2 = stream.streamHead_;
        if (module2 == null) {
            return -1;
        }
        while (module2.next() != stream.streamTail_) {
            module2 = module2.next();
        }
        module.writer().next(module2.reader());
        module2.writer().next(module.reader());
        return 0;
    }

    public synchronized int link(Stream stream) {
        return this.linkInternal(stream);
    }

    private int unlinkInternal() {
        if (this.linkedUs_ != null) {
            Module module;
            Module module2 = this.streamHead_;
            if (module2 != null) {
                while (module2.next() != this.streamTail_) {
                    module2 = module2.next();
                }
                module2.writer().next(this.streamTail_.writer());
            }
            if ((module = this.linkedUs_.streamHead_) != null) {
                while (module.next() != this.linkedUs_.streamTail_) {
                    module = module.next();
                }
                module.writer().next(this.linkedUs_.streamTail_.writer());
            }
            this.linkedUs_.linkedUs_ = null;
            this.linkedUs_ = null;
            return 0;
        }
        return -1;
    }

    public synchronized int unlink() {
        return this.unlinkInternal();
    }

    public void dump() {
        ACE.DEBUG("-------- module links --------");
        Object object = this.streamHead_;
        while (true) {
            ACE.DEBUG("module name = " + ((Module)object).name());
            if (object == this.streamTail_) break;
            object = ((Module)object).next();
        }
        ACE.DEBUG("-------- writer links --------");
        object = this.streamHead_.writer();
        while (true) {
            ACE.DEBUG("writer queue name = " + ((Task)object).name());
            ((Task)object).dump();
            ACE.DEBUG("-------\n");
            if (object == this.streamTail_.writer() || this.linkedUs_ != null && object == this.linkedUs_.streamHead_.reader()) break;
            object = ((Task)object).next();
        }
        ACE.DEBUG("-------- reader links --------\n");
        object = this.streamTail_.reader();
        while (true) {
            ACE.DEBUG("reader queue name = " + ((Task)object).name());
            ((Task)object).dump();
            ACE.DEBUG("-------\n");
            if (object == this.streamHead_.reader() || this.linkedUs_ != null && object == this.linkedUs_.streamHead_.writer()) break;
            object = ((Task)object).next();
        }
    }
}

