/*
 * Decompiled with CFR 0.152.
 */
package JACE.ASX;

import JACE.ASX.MessageBlock;
import JACE.ASX.NotEmptyCondition;
import JACE.ASX.NotFullCondition;
import JACE.ASX.TimeValue;
import JACE.ASX.TimeoutException;
import JACE.OS.ACE;

public class MessageQueue {
    public static final int DEFAULT_HWM = 16384;
    public static final int DEFAULT_LWM = 0;
    public static final int WAS_ACTIVE = 1;
    public static final int WAS_INACTIVE = 2;
    private int highWaterMark_;
    private int lowWaterMark_;
    private boolean deactivated_;
    private int currentBytes_;
    private int currentCount_;
    private MessageBlock head_;
    private MessageBlock tail_;
    private NotFullCondition notFullCondition_ = new NotFullCondition(this);
    private NotEmptyCondition notEmptyCondition_ = new NotEmptyCondition(this);

    public MessageQueue() {
        this(16384, 0);
    }

    public MessageQueue(int n, int n2) {
        if (this.open(n, n2) == -1) {
            ACE.ERROR("open");
        }
    }

    public synchronized int open(int n, int n2) {
        this.highWaterMark_ = n;
        this.lowWaterMark_ = n2;
        this.deactivated_ = false;
        this.currentBytes_ = 0;
        this.currentCount_ = 0;
        this.tail_ = null;
        this.head_ = null;
        return 0;
    }

    public synchronized int enqueue(MessageBlock messageBlock) throws InterruptedException {
        return this.enqueue(messageBlock, null);
    }

    public synchronized int enqueue(MessageBlock messageBlock, TimeValue timeValue) throws InterruptedException {
        int n = -1;
        if (this.deactivated_) {
            return -1;
        }
        try {
            if (timeValue == null) {
                this.notFullCondition_.timedWait();
            } else {
                this.notFullCondition_.timedWait(timeValue);
            }
        }
        catch (TimeoutException timeoutException) {
            return -1;
        }
        if (this.deactivated_) {
            return -1;
        }
        n = this.enqueueInternal(messageBlock);
        this.notEmptyCondition_.broadcast();
        return n;
    }

    public synchronized int enqueueTail(MessageBlock messageBlock) throws InterruptedException {
        return this.enqueueTail(messageBlock, null);
    }

    public synchronized int enqueueTail(MessageBlock messageBlock, TimeValue timeValue) throws InterruptedException {
        int n = -1;
        if (this.deactivated_) {
            return -1;
        }
        try {
            if (timeValue == null) {
                this.notFullCondition_.timedWait();
            } else {
                this.notFullCondition_.timedWait(timeValue);
            }
        }
        catch (TimeoutException timeoutException) {
            return -1;
        }
        if (this.deactivated_) {
            return -1;
        }
        n = this.enqueueTailInternal(messageBlock);
        this.notEmptyCondition_.broadcast();
        return n;
    }

    public synchronized int enqueueHead(MessageBlock messageBlock) throws InterruptedException {
        return this.enqueueHead(messageBlock, null);
    }

    public synchronized int enqueueHead(MessageBlock messageBlock, TimeValue timeValue) throws InterruptedException {
        int n = -1;
        if (this.deactivated_) {
            return -1;
        }
        try {
            if (timeValue == null) {
                this.notFullCondition_.timedWait();
            } else {
                this.notFullCondition_.timedWait(timeValue);
            }
        }
        catch (TimeoutException timeoutException) {
            return -1;
        }
        if (this.deactivated_) {
            return -1;
        }
        n = this.enqueueHeadInternal(messageBlock);
        this.notEmptyCondition_.broadcast();
        return n;
    }

    public synchronized MessageBlock dequeueHead() throws InterruptedException {
        return this.dequeueHead(null);
    }

    public synchronized MessageBlock dequeueHead(TimeValue timeValue) throws InterruptedException {
        MessageBlock messageBlock = null;
        if (this.deactivated_) {
            return null;
        }
        try {
            if (timeValue == null) {
                this.notEmptyCondition_.timedWait();
            } else {
                this.notEmptyCondition_.timedWait(timeValue);
            }
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
        if (this.deactivated_) {
            return null;
        }
        messageBlock = this.dequeueHeadInternal();
        this.notFullCondition_.broadcast();
        return messageBlock;
    }

    public synchronized boolean isFull() {
        return this.isFullInternal();
    }

    public synchronized boolean isEmpty() {
        return this.isEmptyInternal();
    }

    public int messageBytes() {
        return this.currentBytes_;
    }

    public int messageCount() {
        return this.currentCount_;
    }

    public int highWaterMark() {
        return this.highWaterMark_;
    }

    public void highWaterMark(int n) {
        this.highWaterMark_ = n;
    }

    public int lowWaterMark() {
        return this.lowWaterMark_;
    }

    public void lowWaterMark(int n) {
        this.lowWaterMark_ = n;
    }

    public synchronized int deactivate() {
        return this.deactivateInternal();
    }

    public synchronized int activate() {
        return this.activateInternal();
    }

    protected boolean isEmptyInternal() {
        return this.currentBytes_ <= this.lowWaterMark_ && this.currentCount_ <= 0;
    }

    protected boolean isFullInternal() {
        return this.currentBytes_ > this.highWaterMark_;
    }

    protected int deactivateInternal() {
        int n = this.deactivated_ ? 2 : 1;
        this.notFullCondition_.broadcast();
        this.notEmptyCondition_.broadcast();
        this.deactivated_ = true;
        return n;
    }

    protected int activateInternal() {
        int n = this.deactivated_ ? 2 : 1;
        this.deactivated_ = false;
        return n;
    }

    protected int enqueueTailInternal(MessageBlock messageBlock) {
        if (messageBlock == null) {
            return -1;
        }
        if (this.tail_ == null) {
            this.head_ = messageBlock;
            this.tail_ = messageBlock;
            messageBlock.next(null);
            messageBlock.prev(null);
        } else {
            messageBlock.next(null);
            this.tail_.next(messageBlock);
            messageBlock.prev(this.tail_);
            this.tail_ = messageBlock;
        }
        if (messageBlock.msgType() != 9) {
            for (MessageBlock messageBlock2 = messageBlock; messageBlock2 != null; messageBlock2 = messageBlock2.cont()) {
                this.currentBytes_ += messageBlock2.size();
            }
        }
        ++this.currentCount_;
        return this.currentCount_;
    }

    protected int enqueueHeadInternal(MessageBlock messageBlock) {
        if (messageBlock == null) {
            return -1;
        }
        messageBlock.prev(null);
        messageBlock.next(this.head_);
        if (this.head_ != null) {
            this.head_.prev(messageBlock);
        } else {
            this.tail_ = messageBlock;
        }
        this.head_ = messageBlock;
        if (messageBlock.msgType() != 9) {
            for (MessageBlock messageBlock2 = messageBlock; messageBlock2 != null; messageBlock2 = messageBlock2.cont()) {
                this.currentBytes_ += messageBlock2.size();
            }
        }
        ++this.currentCount_;
        return this.currentCount_;
    }

    protected int enqueueInternal(MessageBlock messageBlock) {
        MessageBlock messageBlock2;
        if (messageBlock == null) {
            return -1;
        }
        if (this.head_ == null) {
            return this.enqueueHeadInternal(messageBlock);
        }
        for (messageBlock2 = this.head_; messageBlock2 != null && messageBlock2.msgPriority() > messageBlock.msgPriority(); messageBlock2 = messageBlock2.next()) {
        }
        if (messageBlock2 == null) {
            return this.enqueueTailInternal(messageBlock);
        }
        if (messageBlock2.prev() == null) {
            return this.enqueueHeadInternal(messageBlock);
        }
        messageBlock.next(messageBlock2);
        messageBlock.prev(messageBlock2.prev());
        messageBlock2.prev().next(messageBlock);
        messageBlock2.prev(messageBlock);
        if (messageBlock.msgType() != 9) {
            for (messageBlock2 = messageBlock; messageBlock2 != null; messageBlock2 = messageBlock2.cont()) {
                this.currentBytes_ += messageBlock2.size();
            }
        }
        ++this.currentCount_;
        return this.currentCount_;
    }

    protected MessageBlock dequeueHeadInternal() {
        MessageBlock messageBlock = this.head_;
        this.head_ = this.head_.next();
        if (this.head_ == null) {
            this.tail_ = null;
        }
        if (messageBlock.msgType() != 9) {
            for (MessageBlock messageBlock2 = messageBlock; messageBlock2 != null; messageBlock2 = messageBlock2.cont()) {
                this.currentBytes_ -= messageBlock2.size();
            }
        }
        --this.currentCount_;
        return messageBlock;
    }
}

