/*
 * Decompiled with CFR 0.152.
 */
package JACE.ASX;

import JACE.OS.ACE;

public class MessageBlock {
    private int type_;
    private long flags_;
    private long priority_;
    private StringBuffer base_;
    private Object obj_;
    private MessageBlock cont_;
    private MessageBlock next_;
    private MessageBlock prev_;

    public MessageBlock() {
        this(0);
    }

    public MessageBlock(int n) {
        this(new StringBuffer(n).toString());
    }

    public MessageBlock(String string) {
        this(1, null, string);
    }

    public MessageBlock(int n, MessageBlock messageBlock, String string) {
        this.flags_ = 0L;
        this.priority_ = 0L;
        this.next_ = null;
        this.prev_ = null;
        this.init(n, messageBlock, string);
    }

    public MessageBlock(Object object) {
        this(9, null, object);
    }

    public MessageBlock(int n, MessageBlock messageBlock, Object object) {
        this.init(n, messageBlock, object);
    }

    public void init(String string) {
        this.base_ = new StringBuffer(string);
    }

    public void init(int n, MessageBlock messageBlock, String string) {
        this.base_ = string.length() == 0 ? new StringBuffer(0) : new StringBuffer(string);
        this.type_ = n;
        this.cont_ = messageBlock;
    }

    public void init(Object object) {
        this.init(9, null, object);
    }

    public void init(int n, MessageBlock messageBlock, Object object) {
        this.obj_ = object;
        this.type_ = n;
        this.cont_ = messageBlock;
        this.flags_ = 0L;
        this.priority_ = 0L;
        this.next_ = null;
        this.prev_ = null;
    }

    public long setFlags(long l) {
        this.flags_ = ACE.SET_BITS(this.flags_, l);
        return this.flags_;
    }

    public long clrFlags(long l) {
        this.flags_ = ACE.CLR_BITS(this.flags_, l);
        return this.flags_;
    }

    public long flags() {
        return this.flags_;
    }

    public int msgType() {
        return this.type_;
    }

    public void msgType(int n) {
        this.type_ = n;
    }

    public int msgClass() {
        return this.msgType() >= 128 ? 128 : 0;
    }

    public boolean isDataMsg() {
        int n = this.msgType();
        return n == 1 || n == 2 || n == 131;
    }

    public boolean isObjMsg() {
        int n = this.msgType();
        return n == 9 || n == 2 || n == 131;
    }

    public long msgPriority() {
        return this.priority_;
    }

    public void msgPriority(long l) {
        this.priority_ = l;
    }

    public String base() {
        char[] cArray = new char[this.base_.length()];
        this.base_.getChars(0, this.base_.length(), cArray, 0);
        return new String(cArray);
    }

    public void base(String string, long l) {
        this.base_ = new StringBuffer(string);
        this.flags_ = l;
    }

    public Object obj() {
        return this.obj_;
    }

    public void obj(Object object, long l) {
        this.obj_ = object;
        this.flags_ = l;
    }

    public int length() {
        return this.base_.length();
    }

    public void length(int n) {
        this.base_.setLength(n);
    }

    public int size() {
        return this.base_.capacity();
    }

    public void size(int n) {
        this.base_.ensureCapacity(n);
    }

    public MessageBlock cont() {
        return this.cont_;
    }

    void cont(MessageBlock messageBlock) {
        this.cont_ = messageBlock;
    }

    MessageBlock next() {
        return this.next_;
    }

    void next(MessageBlock messageBlock) {
        this.next_ = messageBlock;
    }

    MessageBlock prev() {
        return this.prev_;
    }

    void prev(MessageBlock messageBlock) {
        this.prev_ = messageBlock;
    }
}

