/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.TagInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.JspServletWrapper;

public class JspCompilationContext {
    private boolean isPackagedTagFile;
    private String className;
    private String jspUri;
    private boolean isErrPage;
    private String basePackageName;
    private String derivedPackageName;
    private String servletJavaFileName;
    private String javaPath;
    private String classFileName;
    private String contentType;
    private ServletWriter writer;
    private Options options;
    private JspServletWrapper jsw;
    private Compiler jspCompiler;
    private String classPath;
    private String baseURI;
    private String outputDir;
    private ServletContext context;
    private URLClassLoader loader;
    private JspRuntimeContext rctxt;
    private int removed = 0;
    private URL baseUrl;
    private Class servletClass;
    private boolean isTagFile;
    private boolean protoTypeMode;
    private TagInfo tagInfo;
    private URL tagFileJarUrl;
    private ConcurrentHashMap<String, TagLibraryInfoImpl> taglibs;
    private ConcurrentHashMap<String, URL> tagFileJarUrls;
    static Object outputDirLock = new Object();

    public JspCompilationContext(String jspUri, boolean isErrPage, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt) throws JasperException {
        this.jspUri = JspCompilationContext.canonicalURI(jspUri);
        this.isErrPage = isErrPage;
        this.options = options;
        this.jsw = jsw;
        this.context = context;
        this.baseURI = jspUri.substring(0, jspUri.lastIndexOf(47) + 1);
        if (this.baseURI == null) {
            this.baseURI = "/";
        } else if (this.baseURI.charAt(0) != '/') {
            this.baseURI = "/" + this.baseURI;
        }
        if (this.baseURI.charAt(this.baseURI.length() - 1) != '/') {
            this.baseURI = this.baseURI + '/';
        }
        this.rctxt = rctxt;
        this.basePackageName = "org.apache.jsp";
        this.taglibs = (ConcurrentHashMap)context.getAttribute("com.sun.jsp.taglibraryCache");
        this.tagFileJarUrls = (ConcurrentHashMap)context.getAttribute("com.sun.jsp.tagFileJarUrlsCache");
    }

    public JspCompilationContext(String tagfile, TagInfo tagInfo, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt, URL tagFileJarUrl) throws JasperException {
        this(tagfile, false, options, context, jsw, rctxt);
        this.isTagFile = true;
        this.tagInfo = tagInfo;
        this.tagFileJarUrl = tagFileJarUrl;
        if (tagFileJarUrl != null) {
            this.isPackagedTagFile = true;
        }
    }

    public void addTaglib(String uri, TagLibraryInfoImpl taglib) {
        this.taglibs.put(uri, taglib);
    }

    public ConcurrentHashMap<String, TagLibraryInfoImpl> getTaglibs() {
        return this.taglibs;
    }

    public void clearTaglibs() {
        this.taglibs.clear();
    }

    public void clearTagFileJarUrls() {
        this.tagFileJarUrls.clear();
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return this.rctxt.getClassPath();
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.rctxt.getParentClassLoader();
    }

    public void setClassLoader(URLClassLoader loader) {
        this.loader = loader;
    }

    public String getOutputDir() {
        if (this.outputDir == null) {
            this.createOutputDir();
        }
        return this.outputDir;
    }

    public Compiler createParser() throws JasperException {
        this.jspCompiler = new Compiler(this, this.jsw);
        return this.jspCompiler;
    }

    public Compiler createCompiler(boolean jspcMode) throws JasperException {
        if (this.jspCompiler != null) {
            return this.jspCompiler;
        }
        this.jspCompiler = new Compiler(this, this.jsw, jspcMode);
        return this.jspCompiler;
    }

    public Compiler getCompiler() {
        return this.jspCompiler;
    }

    public String resolveRelativeUri(String uri) {
        if (uri.startsWith("/") || uri.startsWith(File.separator)) {
            return uri;
        }
        return this.baseURI + uri;
    }

    public InputStream getResourceAsStream(String res) throws JasperException {
        return this.context.getResourceAsStream(JspCompilationContext.canonicalURI(res));
    }

    public URL getResource(String res) throws MalformedURLException {
        try {
            return this.context.getResource(JspCompilationContext.canonicalURI(res));
        }
        catch (JasperException ex) {
            throw new MalformedURLException(ex.getMessage());
        }
    }

    public Set getResourcePaths(String path) throws JasperException {
        return this.context.getResourcePaths(JspCompilationContext.canonicalURI(path));
    }

    public String getRealPath(String path) {
        if (this.context != null) {
            return this.context.getRealPath(path);
        }
        return path;
    }

    public ConcurrentHashMap<String, URL> getTagFileJarUrls() {
        return this.tagFileJarUrls;
    }

    public URL getTagFileJarUrl() {
        return this.tagFileJarUrl;
    }

    public String getServletClassName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.isTagFile) {
            this.className = this.tagInfo.getTagClassName();
            int lastIndex = this.className.lastIndexOf(46);
            if (lastIndex != -1) {
                this.className = this.className.substring(lastIndex + 1);
            }
        } else {
            int iSep = this.jspUri.lastIndexOf(47) + 1;
            this.className = JspUtil.makeJavaIdentifier(this.jspUri.substring(iSep));
        }
        return this.className;
    }

    public void setServletClassName(String className) {
        this.className = className;
    }

    public String getJspFile() {
        return this.jspUri;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public void setTagInfo(TagInfo tagi) {
        this.tagInfo = tagi;
    }

    public boolean isPrototypeMode() {
        return this.protoTypeMode;
    }

    public void setPrototypeMode(boolean pm) {
        this.protoTypeMode = pm;
    }

    public String getServletPackageName() {
        if (this.isTagFile()) {
            String className = this.tagInfo.getTagClassName();
            int lastIndex = className.lastIndexOf(46);
            String pkgName = "";
            if (lastIndex != -1) {
                pkgName = className.substring(0, lastIndex);
            }
            return pkgName;
        }
        String dPackageName = this.getDerivedPackageName();
        if (dPackageName.length() == 0) {
            return this.basePackageName;
        }
        return this.basePackageName + '.' + this.getDerivedPackageName();
    }

    private String getDerivedPackageName() {
        if (this.derivedPackageName == null) {
            String jspUri;
            try {
                jspUri = new URI(this.jspUri).getPath();
                if (jspUri == null) {
                    jspUri = "";
                }
            }
            catch (URISyntaxException e) {
                jspUri = this.jspUri;
            }
            int iSep = jspUri.lastIndexOf(47);
            this.derivedPackageName = iSep > 0 ? JspUtil.makeJavaPackage(jspUri.substring(1, iSep)) : "";
        }
        return this.derivedPackageName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.basePackageName = servletPackageName;
    }

    public String getServletJavaFileName() {
        if (this.servletJavaFileName == null) {
            this.servletJavaFileName = this.getOutputDir() + this.getServletClassName() + ".java";
        }
        return this.servletJavaFileName;
    }

    public Options getOptions() {
        return this.options;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public JspRuntimeContext getRuntimeContext() {
        return this.rctxt;
    }

    public String getFullClassName() {
        if (this.isTagFile()) {
            return this.tagInfo.getTagClassName();
        }
        return this.getServletPackageName() + '.' + this.getServletClassName();
    }

    public String getJavaPath() {
        if (this.javaPath != null) {
            return this.javaPath;
        }
        this.javaPath = this.getFullClassName().replace('.', '/') + ".java";
        return this.javaPath;
    }

    public String getClassFileName() {
        if (this.classFileName == null) {
            this.classFileName = this.getOutputDir() + this.getServletClassName() + ".class";
        }
        return this.classFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public String[] getTldLocation(String uri) throws JasperException {
        String[] location = this.getOptions().getTldLocationsCache().getLocation(uri);
        return location;
    }

    public boolean keepGenerated() {
        return this.getOptions().getKeepGenerated();
    }

    public void incrementRemoved() {
        if (this.removed > 1) {
            this.jspCompiler.removeGeneratedFiles();
            if (this.rctxt != null) {
                this.rctxt.removeWrapper(this.jspUri);
            }
        }
        ++this.removed;
    }

    public boolean isRemoved() {
        return this.removed > 1;
    }

    public void compile() throws JasperException, FileNotFoundException {
        this.createCompiler(false);
        if (this.isPackagedTagFile || this.jspCompiler.isOutDated()) {
            try {
                this.jspCompiler.compile(true);
                this.jsw.setReload(true);
                this.jsw.setCompilationException(null);
            }
            catch (JasperException ex) {
                this.jsw.setCompilationException(ex);
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JasperException je = new JasperException(Localizer.getMessage("jsp.error.unable.compile"), ex);
                this.jsw.setCompilationException(je);
                throw je;
            }
        }
    }

    public Class load() throws JasperException {
        try {
            String name = this.getFullClassName();
            this.servletClass = this.options.getUsePrecompiled() ? this.getClassLoader().loadClass(name) : this.getJspLoader().loadClass(name);
        }
        catch (ClassNotFoundException cex) {
            throw new JasperException(Localizer.getMessage("jsp.error.unable.load"), cex);
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.unable.compile"), ex);
        }
        this.removed = 0;
        return this.servletClass;
    }

    public ClassLoader getJspLoader() {
        return new JasperLoader(new URL[]{this.baseUrl}, this.getClassLoader(), this.rctxt.getPermissionCollection(), this.rctxt.getCodeSource(), this.rctxt.getBytecodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeOutputDir() {
        Object object = outputDirLock;
        synchronized (object) {
            File outDirFile = new File(this.outputDir);
            outDirFile.mkdirs();
        }
    }

    private void createOutputDir() {
        String path = null;
        if (this.isTagFile()) {
            String tagName = this.tagInfo.getTagClassName();
            path = tagName.replace('.', '/');
            path = path.substring(0, path.lastIndexOf(47));
        } else {
            path = this.getServletPackageName().replace('.', '/');
        }
        try {
            this.baseUrl = this.options.getScratchDir().toURL();
            File f = new File(this.options.getScratchDir(), path);
            this.outputDir = f.getPath() + File.separator;
            this.makeOutputDir();
        }
        catch (Exception e) {
            throw new IllegalStateException("No output directory: " + e.getMessage());
        }
    }

    private static final boolean isPathSeparator(char c) {
        return c == '/' || c == '\\';
    }

    private static final String canonicalURI(String s) throws JasperException {
        if (s == null) {
            return null;
        }
        try {
            return new URI(s).normalize().toString();
        }
        catch (URISyntaxException e) {
            StringBuffer result = new StringBuffer();
            int len = s.length();
            int pos = 0;
            block6: while (pos < len) {
                char c = s.charAt(pos);
                if (JspCompilationContext.isPathSeparator(c)) {
                    while (pos + 1 < len && JspCompilationContext.isPathSeparator(s.charAt(pos + 1))) {
                        ++pos;
                    }
                    if (pos + 1 < len && s.charAt(pos + 1) == '.') {
                        if (pos + 2 >= len) break;
                        switch (s.charAt(pos + 2)) {
                            case '/': 
                            case '\\': {
                                pos += 2;
                                continue block6;
                            }
                            case '.': {
                                if (pos + 3 >= len || !JspCompilationContext.isPathSeparator(s.charAt(pos + 3))) break;
                                pos += 3;
                                int separatorPos = result.length() - 1;
                                if (separatorPos < 0) {
                                    throw new JasperException(Localizer.getMessage("jsp.error.badpath", s));
                                }
                                while (separatorPos >= 0 && !JspCompilationContext.isPathSeparator(result.charAt(separatorPos))) {
                                    --separatorPos;
                                }
                                if (separatorPos < 0) continue block6;
                                result.setLength(separatorPos);
                                continue block6;
                            }
                        }
                    }
                }
                result.append(c);
                ++pos;
            }
            return result.toString();
        }
    }
}

