/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.ClientCertAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceContext;
import org.ops4j.pax.web.service.jetty.internal.JettyServerHandlerCollection;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyServerWrapper
extends Server {
    private static final String DEPLOYMENT_MODE = "deploymentMode";
    private static final String RUN_INTEGRATE = "integrated";
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerWrapper.class);
    private static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private final ServerModel m_serverModel;
    private final Map<HttpContext, ServletContextInfo> m_contexts;
    private Map<String, Object> m_contextAttributes;
    private Integer m_sessionTimeout;
    private String m_sessionCookie;
    private String m_sessionUrl;
    private String m_sessionWorkerName;
    private File serverConfigDir;
    private URL serverConfigURL;
    private ServiceRegistration servletContextService;

    JettyServerWrapper(ServerModel serverModel) {
        this.m_serverModel = serverModel;
        this.m_contexts = new IdentityHashMap<HttpContext, ServletContextInfo>();
        this.setHandler((Handler)new JettyServerHandlerCollection(this.m_serverModel));
    }

    public void configureContext(Map<String, Object> attributes, Integer sessionTimeout, String sessionCookie, String sessionUrl, String sessionWorkerName) {
        this.m_contextAttributes = attributes;
        this.m_sessionTimeout = sessionTimeout;
        this.m_sessionCookie = sessionCookie;
        this.m_sessionUrl = sessionUrl;
        this.m_sessionWorkerName = sessionWorkerName;
    }

    ServletContextHandler getContext(HttpContext httpContext) {
        if (this.m_contexts != null && this.m_contexts.get(httpContext) != null) {
            return this.m_contexts.get(httpContext).getHandler();
        }
        return null;
    }

    ServletContextHandler getOrCreateContext(Model model) {
        return this.getOrCreateContext(model.getContextModel());
    }

    ServletContextHandler getOrCreateContext(ContextModel model) {
        HttpContext httpContext = model.getHttpContext();
        ServletContextInfo context = this.m_contexts.get(httpContext);
        if (context == null) {
            LOG.debug("Creating new ServletContextHandler for HTTP context [{}] and model [{}]", (Object)httpContext, (Object)model);
            context = new ServletContextInfo(this.addContext(model));
            this.m_contexts.put(httpContext, context);
        } else {
            int nref = context.incrementRefCount();
            if (LOG.isDebugEnabled()) {
                LOG.debug("ServletContextHandler for HTTP context [{}] and model [{}] referenced [{}] times.", new Object[]{httpContext, model, nref});
            }
        }
        return context.getHandler();
    }

    void removeContext(HttpContext httpContext) {
        ServletContextInfo context = this.m_contexts.get(httpContext);
        if (context == null) {
            return;
        }
        int nref = context.decrementRefCount();
        if (nref <= 0) {
            LOG.debug("Removing ServletContextHandler for HTTP context [{}].", (Object)httpContext);
            this.m_contexts.remove(httpContext);
            try {
                if (this.servletContextService != null) {
                    this.servletContextService.unregister();
                }
            }
            catch (IllegalStateException e) {
                LOG.info("ServletContext service already removed");
            }
            ((HandlerCollection)this.getHandler()).removeHandler((Handler)this.getContext(httpContext));
        } else {
            LOG.debug("ServletContextHandler for HTTP context [{}] referenced [{}] times.", (Object)httpContext, (Object)nref);
        }
    }

    private ServletContextHandler addContext(ContextModel model) {
        String workerName;
        String sessionUrl;
        String sessionCookie;
        Bundle bundle = model.getBundle();
        BundleContext bundleContext = BundleUtils.getBundleContext((Bundle)bundle);
        HttpServiceContext context = new HttpServiceContext((HandlerContainer)this.getHandler(), model.getContextParams(), this.getContextAttributes(bundleContext), model.getContextName(), model.getHttpContext(), model.getAccessControllerContext(), model.getContainerInitializers(), model.getJettyWebXmlURL(), model.getVirtualHosts(), model.getConnectors());
        context.setClassLoader(model.getClassLoader());
        Integer sessionTimeout = model.getSessionTimeout();
        if (sessionTimeout == null) {
            sessionTimeout = this.m_sessionTimeout;
        }
        if ((sessionCookie = model.getSessionCookie()) == null) {
            sessionCookie = this.m_sessionCookie;
        }
        if ((sessionUrl = model.getSessionUrl()) == null) {
            sessionUrl = this.m_sessionUrl;
        }
        if ((workerName = model.getSessionWorkerName()) == null) {
            workerName = this.m_sessionWorkerName;
        }
        this.configureSessionManager(context, sessionTimeout, sessionCookie, sessionUrl, workerName);
        if (model.getRealmName() != null && model.getAuthMethod() != null) {
            this.configureSecurity(context, model.getRealmName(), model.getAuthMethod(), model.getFormLoginPage(), model.getFormErrorPage());
        }
        LOG.debug("Added servlet context: " + (Object)((Object)context));
        if (this.isStarted()) {
            try {
                LOG.debug("(Re)starting servlet contexts...");
                Handler serverHandler = this.getHandler();
                if (!serverHandler.isStarted() && !serverHandler.isStarting()) {
                    serverHandler.start();
                }
                if (!context.isStarted() && !context.isStarting()) {
                    context.start();
                    LOG.debug("Registering ServletContext as service. ");
                    Hashtable<String, String> properties = new Hashtable<String, String>();
                    ((Dictionary)properties).put("osgi.web.symbolicname", bundle.getSymbolicName());
                    Dictionary headers = bundle.getHeaders();
                    String version = (String)headers.get("Bundle-Version");
                    if (version != null && version.length() > 0) {
                        ((Dictionary)properties).put("osgi.web.version", version);
                    }
                    String webContextPath = (String)headers.get(WEB_CONTEXT_PATH);
                    String webappContext = (String)headers.get("Webapp-Context");
                    ContextHandler.Context servletContext = context.getServletContext();
                    if ("/".equalsIgnoreCase(context.getContextPath()) && (webContextPath == null || webappContext == null)) {
                        webContextPath = context.getContextPath();
                    }
                    String string = webContextPath = webContextPath != null ? webContextPath : webappContext;
                    if (webContextPath != null && !webContextPath.startsWith("/")) {
                        webContextPath = "/" + webContextPath;
                    }
                    if (webContextPath == null) {
                        LOG.warn("osgi.web.contextpath couldn't be set, it's not configured");
                    }
                    ((Dictionary)properties).put("osgi.web.contextpath", webContextPath);
                    this.servletContextService = bundleContext.registerService(ServletContext.class.getName(), (Object)servletContext, properties);
                    LOG.debug("ServletContext registered as service. ");
                }
            }
            catch (Exception ignore) {
                LOG.error("Could not start the servlet context for http context [" + model.getHttpContext() + "]", (Throwable)ignore);
            }
        }
        return context;
    }

    private void configureSecurity(ServletContextHandler context, String realmName, String authMethod, String formLoginPage, String formErrorPage) {
        SecurityHandler securityHandler = context.getSecurityHandler();
        FormAuthenticator authenticator = null;
        if ("FORM".equals(authMethod)) {
            authenticator = new FormAuthenticator();
            securityHandler.setInitParameter("org.eclipse.jetty.security.form_login_page", formLoginPage);
            securityHandler.setInitParameter("org.eclipse.jetty.security.form_error_page", formErrorPage);
        } else if ("BASIC".equals(authMethod)) {
            authenticator = new BasicAuthenticator();
        } else if ("DIGEST".equals(authMethod)) {
            authenticator = new DigestAuthenticator();
        } else if ("CLIENT_CERT".equals(authMethod)) {
            authenticator = new ClientCertAuthenticator();
        } else if ("CLIENT-CERT".equals(authMethod)) {
            authenticator = new ClientCertAuthenticator();
        } else if ("SPNEGO".equals(authMethod)) {
            authenticator = new SpnegoAuthenticator();
        } else {
            LOG.warn("UNKNOWN AUTH METHOD: " + authMethod);
        }
        securityHandler.setAuthenticator((Authenticator)authenticator);
        securityHandler.setRealmName(realmName);
    }

    private Map<String, Object> getContextAttributes(BundleContext bundleContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.m_contextAttributes != null) {
            attributes.putAll(this.m_contextAttributes);
        }
        attributes.put("osgi-bundlecontext", bundleContext);
        attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", bundleContext);
        return attributes;
    }

    private void configureSessionManager(ServletContextHandler context, Integer minutes, String cookie, String url, String workerName) {
        SessionManager sessionManager;
        LOG.debug("configureSessionManager for context [" + context + "] using - timeout:" + minutes + ", cookie:" + cookie + ", url:" + url + ", workerName:" + workerName);
        SessionHandler sessionHandler = context.getSessionHandler();
        if (sessionHandler != null && (sessionManager = sessionHandler.getSessionManager()) != null) {
            if (sessionManager instanceof AbstractSessionManager && !JettyServerWrapper.isIntegratedMode()) {
                AbstractSessionManager sm = (AbstractSessionManager)sessionManager;
                sm.setHttpOnly(true);
            }
            if (minutes != null) {
                sessionManager.setMaxInactiveInterval(minutes * 60);
                LOG.debug("Session timeout set to " + minutes + " minutes for context [" + context + "]");
            }
            if (cookie == null || "none".equals(cookie)) {
                if (sessionManager instanceof HashSessionManager) {
                    ((HashSessionManager)sessionManager).setUsingCookies(false);
                    LOG.debug("Session cookies disabled for context [" + context + "]");
                } else {
                    LOG.debug("SessionManager isn't of type HashSessionManager therefore using cookies unchanged!");
                }
            } else if (sessionManager instanceof HashSessionManager) {
                ((HashSessionManager)sessionManager).setSessionCookie(cookie);
                LOG.debug("Session cookie set to " + cookie + " for context [" + context + "]");
            } else {
                LOG.debug("SessionManager isn't of type HashSessionManager therefore cookie not set!");
            }
            if (url != null) {
                sessionManager.setSessionIdPathParameterName(url);
                LOG.debug("Session URL set to " + url + " for context [" + context + "]");
            }
            if (workerName != null) {
                SessionIdManager sessionIdManager = sessionManager.getSessionIdManager();
                if (sessionIdManager == null) {
                    sessionIdManager = new HashSessionIdManager();
                    sessionManager.setSessionIdManager(sessionIdManager);
                }
                if (sessionIdManager instanceof HashSessionIdManager) {
                    HashSessionIdManager s = (HashSessionIdManager)sessionIdManager;
                    s.setWorkerName(workerName);
                    LOG.debug("Worker name set to " + workerName + " for context [" + context + "]");
                }
            }
        }
    }

    public void setServerConfigDir(File serverConfigDir) {
        this.serverConfigDir = serverConfigDir;
    }

    public File getServerConfigDir() {
        return this.serverConfigDir;
    }

    public URL getServerConfigURL() {
        return this.serverConfigURL;
    }

    public void setServerConfigURL(URL serverConfigURL) {
        this.serverConfigURL = serverConfigURL;
    }

    public static boolean isIntegratedMode() {
        String deployModeProp = System.getProperty(DEPLOYMENT_MODE);
        return null == deployModeProp ? false : RUN_INTEGRATE.equalsIgnoreCase(deployModeProp.trim());
    }

    public void handle(AbstractHttpConnection connection) throws IOException, ServletException {
        Request request = connection.getRequest();
        Response response = connection.getResponse();
        String target = request.getPathInfo();
        String remoteIP = request.getRemoteHost();
        if (JettyServerWrapper.isIntegratedMode() && null == request.getHeader("X-Forwarded-For")) {
            LOG.warn("request from " + remoteIP + " is refused,because it isn't forwarded. remote port = " + request.getRemotePort() + ", url = " + target);
            response.sendError(404);
            request.setHandled(true);
        } else {
            super.handle(connection);
        }
    }

    private static final class ServletContextInfo {
        private final ServletContextHandler handler;
        private int refCount;

        public ServletContextInfo(ServletContextHandler handler) {
            this.handler = handler;
            this.refCount = 1;
        }

        public int incrementRefCount() {
            return ++this.refCount;
        }

        public int decrementRefCount() {
            return --this.refCount;
        }

        public ServletContextHandler getHandler() {
            return this.handler;
        }
    }
}

