/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.view.filter;

import com.huawei.commextend.frameutil.TokenUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityTokenFilter
implements Filter {
    private static final String TOKEN = "token";
    private static Logger logger = LoggerFactory.getLogger((String)SecurityTokenFilter.class.getName());

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest sreq = (HttpServletRequest)request;
        HttpServletResponse sresp = (HttpServletResponse)response;
        if (!this.isAuthenticateRequired(sreq.getRequestURI())) {
            chain.doFilter(request, response);
        } else if (TokenUtil.isValid((Object)sreq.getHeader(TOKEN), (String)this.getAddr(sreq))) {
            chain.doFilter(request, response);
        } else {
            logger.warn("invalid security token, request url is blocked: " + sreq.getRequestURI());
            sresp.sendError(404);
        }
    }

    public String getAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private boolean isAuthenticateRequired(String url) {
        String s = url.toLowerCase();
        return s.contains(".jsp") || s.contains(".html") || s.contains(".htm");
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

