/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.view.filter;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFilter
implements Filter {
    private static final int DEFAULT_MAX_AGE = 86400;
    private static final String MAX_AGE_PARAM = "max-age";
    private static Logger log = LoggerFactory.getLogger((String)CacheFilter.class.getName());
    protected Date filterStartTime;
    protected int maxAge = 86400;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterStartTime = this.getCurrentDate();
        String tmp = filterConfig.getInitParameter(MAX_AGE_PARAM);
        if (null != tmp) {
            try {
                this.maxAge = Integer.parseInt(tmp);
            }
            catch (Exception e) {
                log.error("Config max-age attribute fail,, use default value:0.", (Throwable)e);
            }
        }
        log.info("Not config max-age attribute, use default value:0");
    }

    private Date getCurrentDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        return cal.getTime();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        if (Boolean.valueOf(System.getProperty("debug")).booleanValue()) {
            this.setNoCache(servletResponse);
            chain.doFilter(request, response);
            return;
        }
        String requestURI = servletRequest.getRequestURI();
        if (this.isSupportCache(requestURI)) {
            this.setCache(servletRequest, servletResponse);
            if (this.checkCacheValidate(servletRequest, servletResponse)) {
                return;
            }
        } else {
            this.setNoCache(servletResponse);
        }
        chain.doFilter(request, response);
    }

    protected void setCache(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        servletResponse.setHeader("Cache-Control", "max-age=" + this.maxAge);
        servletResponse.setHeader("ETag", this.getEtag(servletRequest));
        servletResponse.setDateHeader("Last-Modified", this.getCurrentDate().getTime());
    }

    protected boolean checkCacheValidate(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        String modify_Since;
        Date modifyData;
        String previousToken = servletRequest.getHeader("If-None-Match");
        if (null != previousToken && previousToken.equals(this.getEtag(servletRequest)) && (modifyData = new Date(modify_Since = servletRequest.getHeader("If-Modified-Since"))).getTime() >= this.filterStartTime.getTime()) {
            servletResponse.setDateHeader("Last-Modified", modifyData.getTime());
            servletResponse.setStatus(304);
            return true;
        }
        return false;
    }

    protected void setNoCache(HttpServletResponse servletResponse) {
        servletResponse.setHeader("Cache-Control", "no-cache");
    }

    protected String getEtag(HttpServletRequest servletRequest) {
        return '\"' + servletRequest.getRequestURI() + '\"';
    }

    protected boolean isSupportCache(String requestURI) {
        return this.isStaticReq(requestURI);
    }

    private boolean isStaticReq(String requestURI) {
        return requestURI.matches(".*\\.(xml|js|htm(l)?|css|xui|rule|gif|png|bmp|jp(e|g|eg))$");
    }
}

