/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.view.api;

import com.huawei.uflight.view.InstanceObject;
import com.huawei.uflight.view.api.BeanObject;
import com.huawei.uflight.view.api.ILazyRegistry;
import com.metaparadigm.jsonrpc.JSONRPCBridge;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationContext;

public class LazyRegistry
implements ILazyRegistry {
    private Map<Object, BeanObject> lazyLoadMap = new HashMap<Object, BeanObject>();
    private Map<Object, InstanceObject> instancedCache = new HashMap<Object, InstanceObject>();
    private static final Logger log = Logger.getLogger(LazyRegistry.class.getName());
    private static LazyRegistry register = null;

    public static synchronized LazyRegistry getInstance() {
        if (null == register) {
            register = new LazyRegistry();
            JSONRPCBridge.setRegistry(register);
        }
        return register;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceObject getLazyLoadInstance(Object key) {
        if (this.instancedCache.containsKey(key)) {
            Map<Object, InstanceObject> map = this.instancedCache;
            synchronized (map) {
                return this.instancedCache.get(key);
            }
        }
        Class clazz = null;
        BeanObject bean = null;
        Map<Object, BeanObject> map = this.lazyLoadMap;
        synchronized (map) {
            bean = this.lazyLoadMap.get(key);
            if (null != bean) {
                clazz = bean.getClazz();
            }
        }
        if (null == bean || null == clazz) {
            return null;
        }
        Object obj = this.getContext(bean.getBeanID(), clazz);
        Class iface = bean.getInterface();
        InstanceObject instance = null;
        instance = null == iface ? new InstanceObject(obj, new Class[0]) : new InstanceObject(obj, iface);
        Map<Object, Object> map2 = this.instancedCache;
        synchronized (map2) {
            this.instancedCache.put(key, instance);
        }
        map2 = this.lazyLoadMap;
        synchronized (map2) {
            this.lazyLoadMap.remove(key);
        }
        return instance;
    }

    private Object getContext(String beanID, Class clazz) {
        BundleContext bundleContext = FrameworkUtil.getBundle(LazyRegistry.class).getBundleContext();
        if (null == bundleContext) {
            log.warning("Null bundle context when getting " + clazz);
            return null;
        }
        Bundle bundle = FrameworkUtil.getBundle((Class)clazz);
        if (null == bundle) {
            log.warning("Bundle is null when getting " + clazz);
            return null;
        }
        String bundleName = bundle.getSymbolicName();
        ServiceReference[] references = null;
        try {
            references = bundleContext.getAllServiceReferences(ApplicationContext.class.getName(), "(org.springframework.context.service.name=" + bundleName + ")");
        }
        catch (InvalidSyntaxException e) {
            log.info(e.getMessage());
        }
        if (null != references && references.length > 0) {
            ApplicationContext context = (ApplicationContext)bundleContext.getService(references[0]);
            if (null == context) {
                log.warning("ApplicationContext is null when getting " + clazz);
                return null;
            }
            return context.getBean(beanID, clazz);
        }
        return null;
    }

    public Map<Object, BeanObject> getRegistedMap() {
        return this.lazyLoadMap;
    }

    public Map<Object, InstanceObject> getInstancedMap() {
        return this.instancedCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, InstanceObject> getAllInstance() {
        if (null != this.lazyLoadMap) {
            Map<Object, BeanObject> map = this.lazyLoadMap;
            synchronized (map) {
                for (Map.Entry<Object, BeanObject> entry : this.lazyLoadMap.entrySet()) {
                    Object key = entry.getKey();
                    this.getLazyLoadInstance(key);
                }
            }
        }
        return this.getInstancedMap();
    }
}

