/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry.impl;

import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.http.registry.RegistryActivator;
import com.huawei.uflight.http.registry.impl.WebContext;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IContributor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebUitl {
    private static final Logger LOG = LoggerFactory.getLogger(WebUitl.class);

    private WebUitl() {
    }

    public static String getRootPath(IContributor contributor) {
        AppEntity appEntity = RegistryActivator.getAppMgr().getAppByBundle(WebUitl.getBundle(contributor));
        String rootPath = null;
        rootPath = null == appEntity.getAppParam("UrlProcID", new String[0]) || null == appEntity.getAppParam("UrlProcHandle", new String[0]) ? '/' + appEntity.getAppParam("rootPath", new String[0]) + '/' : '/' + appEntity.getAppParam("rootPath", new String[0]) + '/' + appEntity.getAppParam("UrlProcID", new String[0]) + '/' + appEntity.getAppParam("UrlProcHandle", new String[0]) + '/';
        return rootPath;
    }

    public static String normalizeResourcePath(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = WebUitl.replaceSlashes(path.trim());
        if (normalizedPath.startsWith("/") && normalizedPath.length() > 1) {
            normalizedPath = normalizedPath.substring(1);
        }
        return normalizedPath;
    }

    static String replaceSlashes(String target) {
        String replaced = target;
        if (replaced != null) {
            replaced = replaced.replaceAll("/+", "/");
        }
        return replaced;
    }

    public static String[] normalizePatterns(String[] urlPatterns) {
        String[] normalized = null;
        if (urlPatterns != null) {
            normalized = new String[urlPatterns.length];
            for (int i = 0; i < urlPatterns.length; ++i) {
                normalized[i] = WebUitl.normalizePattern(urlPatterns[i]);
            }
        }
        return normalized;
    }

    public static String normalizePattern(String pattern) {
        if (pattern != null && pattern.length() > 0 && !pattern.startsWith("/") && !pattern.startsWith("*")) {
            return "/" + pattern;
        }
        return pattern;
    }

    static Bundle getBundle(IContributor contributor) {
        return WebUitl.getBundle(contributor.getName());
    }

    private static Bundle getBundle(String symbolicName) {
        Bundle[] bundles = RegistryActivator.getPackageAdmin().getBundles(symbolicName, null);
        if (bundles == null) {
            LOG.error("Don't found the Bundle, symbolicName=" + symbolicName);
            return null;
        }
        for (int i = 0; i < bundles.length; ++i) {
            if ((bundles[i].getState() & 3) != 0) continue;
            return bundles[i];
        }
        LOG.error("The Bundle state is installed or uninstalled, symbolicName=" + symbolicName);
        return null;
    }

    public static Set<String> getResourcePaths(String name, WebContext webcontext) {
        String normalizedname = WebUitl.normalizeResourcePath(name);
        HashSet<String> foundPaths = new HashSet<String>();
        Enumeration entryPaths = null;
        for (Bundle bundle : webcontext.getBundleList()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Searching bundle [" + bundle + "] for resource paths of [" + normalizedname + "]");
            }
            if ((entryPaths = bundle.getEntryPaths(normalizedname)) == null || !entryPaths.hasMoreElements()) continue;
            while (entryPaths.hasMoreElements()) {
                foundPaths.add((String)entryPaths.nextElement());
            }
        }
        if (null != webcontext.getParent()) {
            foundPaths.addAll(WebUitl.getResourcePaths(normalizedname, webcontext.getParent()));
        }
        return foundPaths;
    }

    public static URL getResource(String name, WebContext webcontext) {
        String normalizedname = WebUitl.normalizeResourcePath(name);
        for (Bundle bundle : webcontext.getBundleList()) {
            URL url;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Searching bundle [" + bundle + "] for resource [" + normalizedname + "]");
            }
            if (null == (url = bundle.getResource(normalizedname))) continue;
            return url;
        }
        if (null != webcontext.getParent()) {
            return WebUitl.getResource(name, webcontext.getParent());
        }
        return null;
    }
}

