/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry.impl;

import com.huawei.uflight.http.registry.WebExtensionListener;
import com.huawei.uflight.http.registry.impl.WebRegistryChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebExtensionPointTracker {
    private final IExtensionRegistry registry;
    private final String extensionPointId;
    protected final WebExtensionListener listener;
    private final IRegistryChangeListener registryChangeListener;
    private final String namespace;
    private boolean extensionCacheIdentifier = true;
    private final Set<IExtension> extensionCache = new HashSet<IExtension>();
    private static final Logger logger = LoggerFactory.getLogger(WebExtensionPointTracker.class);

    public WebExtensionPointTracker(IExtensionRegistry registry, String extensionPointId, WebExtensionListener listener) {
        this.registry = registry;
        this.extensionPointId = extensionPointId;
        this.listener = listener;
        if (extensionPointId == null || -1 == extensionPointId.indexOf(".")) {
            throw new IllegalArgumentException("Unexpected Extension Point Identifier: " + extensionPointId);
        }
        int lastDotIndex = extensionPointId.lastIndexOf(".");
        this.namespace = extensionPointId.substring(0, lastDotIndex);
        String simpleIdentifier = extensionPointId.substring(lastDotIndex + 1);
        this.registryChangeListener = new WebRegistryChangeListener(this, listener, this.namespace, simpleIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        IExtension[] extensions = null;
        WebExtensionPointTracker webExtensionPointTracker = this;
        synchronized (webExtensionPointTracker) {
            if (!this.extensionCacheIdentifier) {
                return;
            }
            this.registry.addRegistryChangeListener(this.registryChangeListener, this.namespace);
            try {
                IExtensionPoint point = this.registry.getExtensionPoint(this.extensionPointId);
                if (point != null) {
                    extensions = point.getExtensions();
                    this.extensionCache.addAll(Arrays.asList(extensions));
                }
                this.extensionCacheIdentifier = false;
            }
            catch (InvalidRegistryObjectException e) {
                this.registry.removeRegistryChangeListener(this.registryChangeListener);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (extensions != null) {
            for (IExtension iextensionElement : extensions) {
                this.listener.added(iextensionElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        IExtension[] extensions = null;
        WebExtensionPointTracker webExtensionPointTracker = this;
        synchronized (webExtensionPointTracker) {
            if (this.extensionCacheIdentifier) {
                return;
            }
            this.registry.removeRegistryChangeListener(this.registryChangeListener);
            extensions = this.getExtensions();
            this.extensionCache.clear();
            this.extensionCacheIdentifier = true;
        }
        for (IExtension iextensionElement : extensions) {
            this.listener.removed(iextensionElement);
        }
    }

    synchronized boolean removeExtension(IExtension extension) {
        if (this.extensionCacheIdentifier) {
            return false;
        }
        return this.extensionCache.remove(extension);
    }

    synchronized boolean addExtension(IExtension extension) {
        if (this.extensionCacheIdentifier) {
            return false;
        }
        return this.extensionCache.add(extension);
    }

    public synchronized IExtension[] getExtensions() {
        return this.extensionCache.toArray(new IExtension[this.extensionCache.size()]);
    }
}

