/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry.impl;

import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.http.registry.RegistryActivator;
import com.huawei.uflight.http.registry.impl.WebContext;
import com.huawei.uflight.http.registry.impl.WebUitl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IContributor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebContextMgr {
    private static Map<String, WebContext> contextMap = new HashMap<String, WebContext>();
    private static WebContext defaultContext = new WebContext("WEB_APP");
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Logger LOG = LoggerFactory.getLogger(WebContextMgr.class);

    private WebContextMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAppContext(String appName) {
        WebContext context = null;
        lock.writeLock().lock();
        try {
            context = contextMap.get(appName);
            if (null == context) {
                context = new WebContext(defaultContext, appName);
                contextMap.put(appName, context);
            } else {
                LOG.warn("The appContext had been creaded, appName=" + appName);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAppContext(String appName) {
        WebContext context = WebContextMgr.getAppContext(appName);
        lock.writeLock().lock();
        try {
            context.getBundleList().clear();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static WebContext getWebContext(IContributor contributor) {
        Bundle bundle = WebUitl.getBundle(contributor);
        if (null == bundle) {
            LOG.error("Get Bundle is fail!");
            return null;
        }
        String appName = WebContextMgr.getAppName(bundle);
        WebContext context = WebContextMgr.getAppContext(appName);
        context.addResourcePath(bundle);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebContext getAppContext(String appName) {
        WebContext context = null;
        lock.readLock().lock();
        try {
            context = contextMap.get(appName);
        }
        finally {
            lock.readLock().unlock();
        }
        if (null == context) {
            context = defaultContext;
            LOG.warn("The WebContext not creat, use the default webcontext, the appName is :" + appName);
        }
        LOG.debug("getWebContext(): appName=" + appName + ",contextName=" + context.getContextName());
        return context;
    }

    private static String getAppName(Bundle bundle) {
        AppEntity appEntiry = RegistryActivator.getAppMgr().getAppByBundle(bundle);
        if (null == appEntiry) {
            return "";
        }
        return appEntiry.getAppName();
    }

    static {
        contextMap.put("WEB_APP", defaultContext);
    }
}

