/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry.impl;

import com.huawei.uflight.http.registry.RegistryActivator;
import com.huawei.uflight.http.registry.WebExtensionListener;
import com.huawei.uflight.http.registry.WebExtensionManager;
import com.huawei.uflight.http.registry.impl.WebContext;
import com.huawei.uflight.http.registry.impl.WebContextMgr;
import com.huawei.uflight.http.registry.impl.WebExtensionPointTracker;
import com.huawei.uflight.http.registry.impl.WebUitl;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletServiceManager
implements WebExtensionListener,
WebExtensionManager {
    private WebExtensionPointTracker webExtensionPointTracker;
    private Map<IContributor, List<Servlet>> servletMap = new HashMap<IContributor, List<Servlet>>();
    private static final Logger logger = LoggerFactory.getLogger(ServletServiceManager.class);
    private static final String INIT_PARAM = "init-param";

    public ServletServiceManager(IExtensionRegistry registry) {
        this.webExtensionPointTracker = new WebExtensionPointTracker(registry, "com.huawei.uflight.http.registry.servlets", this);
    }

    @Override
    public void start() {
        this.webExtensionPointTracker.open();
    }

    @Override
    public void stop() {
        this.webExtensionPointTracker.close();
    }

    @Override
    public void added(IExtension extension) {
        IContributor contributor = extension.getContributor();
        List<Servlet> servletList = this.servletMap.get(contributor);
        if (null == servletList) {
            servletList = new ArrayList<Servlet>();
            this.servletMap.put(contributor, servletList);
        }
        WebContext context = WebContextMgr.getWebContext(extension.getContributor());
        IConfigurationElement[] elements = extension.getConfigurationElements();
        Hashtable<String, String> initParamsServlet = new Hashtable<String, String>();
        String rootPath = WebUitl.getRootPath(extension.getContributor());
        for (IConfigurationElement configurationElement : elements) {
            String alias = configurationElement.getAttribute("alias");
            String servletName = configurationElement.getAttribute("class");
            if (!alias.startsWith("/")) {
                alias = "".equals(alias) ? rootPath.substring(0, rootPath.lastIndexOf("/")) : rootPath + alias;
            }
            try {
                IConfigurationElement[] param;
                for (IConfigurationElement configurationElementChildren : param = configurationElement.getChildren(INIT_PARAM)) {
                    String paramName = configurationElementChildren.getAttribute("name");
                    String paramValue = configurationElementChildren.getAttribute("value");
                    ((Dictionary)initParamsServlet).put(paramName, paramValue);
                }
                Class<?> cls = Class.forName(servletName);
                Servlet registryServlet = (Servlet)cls.newInstance();
                RegistryActivator.getWebContainer().registerServlet(registryServlet, new String[]{alias}, initParamsServlet, (HttpContext)context);
                logger.info("register servlet success: alias=" + alias + "+, servletClass=" + servletName + ",webcontext=" + context.getContextName() + ",Bundle symbolicName=" + extension.getContributor().getName());
                servletList.add(registryServlet);
            }
            catch (Exception e) {
                logger.error("register objectAction failed,classname=" + servletName, (Throwable)e);
            }
        }
    }

    @Override
    public void removed(IExtension extension) {
        IContributor contributor = extension.getContributor();
        List<Servlet> ServletList = this.servletMap.remove(contributor);
        if (null != ServletList) {
            for (Servlet servlet : ServletList) {
                RegistryActivator.getWebContainer().unregisterServlet(servlet);
                logger.info("unregisterServlet, servletClass=" + servlet.getClass().getName());
            }
        }
    }
}

