/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry.impl;

import com.huawei.uflight.http.registry.RegistryActivator;
import com.huawei.uflight.http.registry.WebExtensionListener;
import com.huawei.uflight.http.registry.WebExtensionManager;
import com.huawei.uflight.http.registry.impl.WebContext;
import com.huawei.uflight.http.registry.impl.WebContextMgr;
import com.huawei.uflight.http.registry.impl.WebExtensionPointTracker;
import com.huawei.uflight.http.registry.impl.WebUitl;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManager
implements WebExtensionListener,
WebExtensionManager {
    private WebExtensionPointTracker webExtensionPointTracker;
    private static final Logger logger = LoggerFactory.getLogger(ResourceManager.class);

    public ResourceManager(IExtensionRegistry registry) {
        this.webExtensionPointTracker = new WebExtensionPointTracker(registry, "com.huawei.uflight.http.registry.resources", this);
    }

    @Override
    public void start() {
        this.webExtensionPointTracker.open();
    }

    @Override
    public void stop() {
        this.webExtensionPointTracker.close();
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        WebContext context = WebContextMgr.getWebContext(extension.getContributor());
        String rootPath = WebUitl.getRootPath(extension.getContributor());
        for (IConfigurationElement configurationElement : elements) {
            String alias = configurationElement.getAttribute("alias");
            if (!alias.startsWith("/")) {
                alias = rootPath + alias;
            }
            String baseName = configurationElement.getAttribute("base-name");
            try {
                RegistryActivator.getWebContainer().registerResources(alias, baseName, (HttpContext)context);
                logger.info("register resource success,alias=" + alias + ",baseName=" + baseName + ",webcontext=" + context.getContextName() + ",Bundle symbolicName=" + extension.getContributor().getName());
            }
            catch (Exception e) {
                logger.error("register resource failed,alias=" + alias + ",baseName=" + baseName, (Throwable)e);
            }
        }
    }

    @Override
    public void removed(IExtension extension) {
        IConfigurationElement[] elements;
        for (IConfigurationElement configurationElement : elements = extension.getConfigurationElements()) {
            String alias = configurationElement.getAttribute("alias");
            try {
                RegistryActivator.getWebContainer().unregister(alias);
                logger.info("unregisterResource, alias=" + alias);
            }
            catch (Exception e) {
                logger.error("unregister register resource failed,alias=" + alias, (Throwable)e);
            }
        }
    }
}

