/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry.impl;

import com.huawei.uflight.http.registry.RegistryActivator;
import com.huawei.uflight.http.registry.WebExtensionListener;
import com.huawei.uflight.http.registry.WebExtensionManager;
import com.huawei.uflight.http.registry.impl.WebContext;
import com.huawei.uflight.http.registry.impl.WebContextMgr;
import com.huawei.uflight.http.registry.impl.WebExtensionPointTracker;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerServiceManager
implements WebExtensionListener,
WebExtensionManager {
    private WebExtensionPointTracker webExtensionPointTracker;
    private Map<IContributor, List<EventListener>> listernerMap = new HashMap<IContributor, List<EventListener>>();
    private static final Logger logger = LoggerFactory.getLogger(ListenerServiceManager.class);

    public ListenerServiceManager(IExtensionRegistry registry) {
        this.webExtensionPointTracker = new WebExtensionPointTracker(registry, "com.huawei.uflight.http.registry.listeners", this);
    }

    @Override
    public void start() {
        this.webExtensionPointTracker.open();
    }

    @Override
    public void stop() {
        this.webExtensionPointTracker.close();
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        IContributor contributor = extension.getContributor();
        List<EventListener> listernerLst = this.listernerMap.get(contributor);
        if (null == listernerLst) {
            listernerLst = new ArrayList<EventListener>();
            this.listernerMap.put(contributor, listernerLst);
        }
        WebContext context = WebContextMgr.getWebContext(extension.getContributor());
        for (IConfigurationElement configurationElement : elements) {
            String listenerClass = configurationElement.getAttribute("listener-class");
            try {
                Class<?> cls = Class.forName(listenerClass);
                EventListener eventlistener = (EventListener)cls.newInstance();
                RegistryActivator.getWebContainer().registerEventListener(eventlistener, (HttpContext)context);
                listernerLst.add(eventlistener);
                logger.info("register objectAction success,listenerClass=" + listenerClass + ",webcontext=" + context.getContextName() + ",Bundle symbolicName=" + extension.getContributor().getName());
            }
            catch (Exception e) {
                logger.error("register objectAction failed,listenerClass=" + listenerClass, (Throwable)e);
            }
        }
    }

    @Override
    public void removed(IExtension extension) {
        IContributor contributor = extension.getContributor();
        List<EventListener> listernerLst = this.listernerMap.remove(contributor);
        if (null != listernerLst) {
            for (EventListener listerner : listernerLst) {
                RegistryActivator.getWebContainer().unregisterEventListener(listerner);
                logger.info("unregisterListerner, listenerClass=" + listerner.getClass().getName());
            }
        }
    }
}

