/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry.impl;

import com.huawei.uflight.http.registry.RegistryActivator;
import com.huawei.uflight.http.registry.WebExtensionListener;
import com.huawei.uflight.http.registry.WebExtensionManager;
import com.huawei.uflight.http.registry.impl.WebContext;
import com.huawei.uflight.http.registry.impl.WebContextMgr;
import com.huawei.uflight.http.registry.impl.WebExtensionPointTracker;
import com.huawei.uflight.http.registry.impl.WebUitl;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspServiceManager
implements WebExtensionListener,
WebExtensionManager {
    private WebExtensionPointTracker webExtensionPointTracker;
    private static final Logger logger = LoggerFactory.getLogger(JspServiceManager.class);

    public JspServiceManager(IExtensionRegistry registry) {
        this.webExtensionPointTracker = new WebExtensionPointTracker(registry, "com.huawei.uflight.http.registry.jsps", this);
    }

    @Override
    public void start() {
        this.webExtensionPointTracker.open();
    }

    @Override
    public void stop() {
        this.webExtensionPointTracker.close();
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        WebContext context = WebContextMgr.getWebContext(extension.getContributor());
        String rootPath = WebUitl.getRootPath(extension.getContributor());
        for (IConfigurationElement configurationElement : elements) {
            Object[] jspurls = new String[]{configurationElement.getAttribute("jsp-name")};
            String jspFile = configurationElement.getAttribute("base-name");
            try {
                if (jspFile == null) {
                    RegistryActivator.getWebContainer().registerJsps((String[])jspurls, (HttpContext)context);
                } else {
                    if (!jspurls[0].startsWith("/")) {
                        jspurls[0] = rootPath + (String)jspurls[0];
                    }
                    RegistryActivator.getWebContainer().registerJspServlet((String[])jspurls, (HttpContext)context, jspFile);
                }
                logger.info("register jsp resource success, jspurl = [" + (String)jspurls[0] + "],webcontext=" + context.getContextName() + ",Bundle symbolicName=" + extension.getContributor().getName());
            }
            catch (Exception e) {
                logger.error("register objectAction failed,jspurl=" + Arrays.toString(jspurls), (Throwable)e);
            }
        }
    }

    @Override
    public void removed(IExtension extension) {
        IConfigurationElement[] elements;
        for (IConfigurationElement configurationElement : elements = extension.getConfigurationElements()) {
            String jspurl = configurationElement.getAttribute("jsp-name");
            RegistryActivator.getWebContainer().unregister(jspurl);
            logger.info("unregisterJsp, jspurl=" + jspurl);
        }
    }
}

