/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry.impl;

import com.huawei.uflight.http.registry.WebExtensionManager;
import com.huawei.uflight.http.registry.impl.FilterServiceManager;
import com.huawei.uflight.http.registry.impl.JspServiceManager;
import com.huawei.uflight.http.registry.impl.ListenerServiceManager;
import com.huawei.uflight.http.registry.impl.ResourceManager;
import com.huawei.uflight.http.registry.impl.ServletServiceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class HttpServiceTracker
extends ServiceTracker {
    private IExtensionRegistry registry;
    public Map<ServiceReference, List<WebExtensionManager>> extensionManagerMap = new HashMap<ServiceReference, List<WebExtensionManager>>();

    public HttpServiceTracker(BundleContext context, IExtensionRegistry registry) {
        super(context, HttpService.class.getName(), null);
        this.registry = registry;
    }

    public synchronized Object addingService(ServiceReference reference) {
        HttpService httpService = (HttpService)super.addingService(reference);
        if (httpService == null) {
            return null;
        }
        List<WebExtensionManager> extensionManagerList = this.extensionManagerMap.get(reference);
        if (null == extensionManagerList) {
            extensionManagerList = new ArrayList<WebExtensionManager>();
            this.extensionManagerMap.put(reference, extensionManagerList);
        }
        ServletServiceManager servletServiceManager = new ServletServiceManager(this.registry);
        servletServiceManager.start();
        extensionManagerList.add(servletServiceManager);
        FilterServiceManager filterServiceManager = new FilterServiceManager(this.registry);
        filterServiceManager.start();
        extensionManagerList.add(filterServiceManager);
        JspServiceManager jspServiceManager = new JspServiceManager(this.registry);
        jspServiceManager.start();
        extensionManagerList.add(jspServiceManager);
        ListenerServiceManager listenersm = new ListenerServiceManager(this.registry);
        listenersm.start();
        extensionManagerList.add(listenersm);
        ResourceManager resourceManager = new ResourceManager(this.registry);
        resourceManager.start();
        extensionManagerList.add(resourceManager);
        return httpService;
    }

    public synchronized void removedService(ServiceReference reference, Object service) {
        List<WebExtensionManager> extensionManagerList = this.extensionManagerMap.get(reference);
        if (null != extensionManagerList) {
            for (WebExtensionManager webExtensionManager : extensionManagerList) {
                webExtensionManager.stop();
            }
        }
        super.removedService(reference, service);
    }
}

