/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry.impl;

import com.huawei.uflight.http.registry.RegistryActivator;
import com.huawei.uflight.http.registry.WebExtensionListener;
import com.huawei.uflight.http.registry.WebExtensionManager;
import com.huawei.uflight.http.registry.impl.WebContext;
import com.huawei.uflight.http.registry.impl.WebContextMgr;
import com.huawei.uflight.http.registry.impl.WebExtensionPointTracker;
import com.huawei.uflight.http.registry.impl.WebUitl;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterServiceManager
implements WebExtensionListener,
WebExtensionManager {
    private WebExtensionPointTracker webExtensionPointTracker;
    private Map<IContributor, List<Filter>> filterMap = new HashMap<IContributor, List<Filter>>();
    private static final Logger logger = LoggerFactory.getLogger(FilterServiceManager.class);

    public FilterServiceManager(IExtensionRegistry registry) {
        this.webExtensionPointTracker = new WebExtensionPointTracker(registry, "com.huawei.uflight.http.registry.filter", this);
    }

    @Override
    public void start() {
        this.webExtensionPointTracker.open();
    }

    @Override
    public void stop() {
        this.webExtensionPointTracker.close();
    }

    @Override
    public void added(IExtension extension) {
        IContributor contributor = extension.getContributor();
        List<Filter> filterList = this.filterMap.get(contributor);
        if (null == filterList) {
            filterList = new ArrayList<Filter>();
            this.filterMap.put(contributor, filterList);
        }
        IConfigurationElement[] elements = extension.getConfigurationElements();
        Hashtable<String, String> initParamsFilter = new Hashtable<String, String>();
        WebContext context = WebContextMgr.getWebContext(extension.getContributor());
        String rootPath = WebUitl.getRootPath(extension.getContributor());
        for (IConfigurationElement configurationElement : elements) {
            String url = configurationElement.getAttribute("alias");
            String className = configurationElement.getAttribute("class");
            if (!url.startsWith("/")) {
                url = rootPath + url;
            }
            try {
                IConfigurationElement[] param;
                for (IConfigurationElement configurationElementChildren : param = configurationElement.getChildren()) {
                    String paramName = configurationElementChildren.getAttribute("name");
                    String paramValue = configurationElementChildren.getAttribute("value");
                    ((Dictionary)initParamsFilter).put(paramName, paramValue);
                }
                Class<?> cls = Class.forName(className);
                Filter registryFilter = (Filter)cls.newInstance();
                RegistryActivator.getWebContainer().registerFilter(registryFilter, new String[]{url}, null, initParamsFilter, (HttpContext)context);
                logger.info("register filter success, url=" + url + "className=" + className + ",webcontext=" + context.getContextName() + ",Bundle symbolicName=" + extension.getContributor().getName());
                filterList.add(registryFilter);
                if (context.getContextName().equalsIgnoreCase("WEB_APP")) continue;
                Filter registryFilter2 = (Filter)cls.newInstance();
                RegistryActivator.getWebContainer().registerFilter(registryFilter2, new String[]{url}, null, initParamsFilter, (HttpContext)WebContextMgr.getAppContext("WEB_APP"));
                logger.info("register filter success, url=" + url + "className=" + className + ",webcontext=" + "WEB_APP" + ",Bundle symbolicName=" + extension.getContributor().getName());
                filterList.add(registryFilter2);
            }
            catch (Exception e) {
                logger.error("register objectAction failed,classname=" + className, (Throwable)e);
            }
        }
    }

    @Override
    public void removed(IExtension extension) {
        IContributor contributor = extension.getContributor();
        List<Filter> filterList = this.filterMap.remove(contributor);
        if (null != filterList) {
            for (Filter filter : filterList) {
                RegistryActivator.getWebContainer().unregisterFilter(filter);
                logger.info("unregisterFilter, FilterClassName=" + filter.getClass().getName());
            }
        }
    }
}

