/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.http.registry;

import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.api.IAppManager;
import com.huawei.uflight.appmanager.api.IAppStateChanageListener;
import com.huawei.uflight.http.registry.impl.HttpServiceTracker;
import com.huawei.uflight.http.registry.impl.WebContextMgr;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryActivator
implements BundleActivator,
ServiceTrackerCustomizer {
    private static WebContainer webContainer;
    private static HttpContext httpContext;
    private ServiceReference servicereference;
    private ServiceTracker httpServiceTracker;
    private ServiceTracker registryTracker;
    private static PackageAdmin packageAdmin;
    private IExtensionRegistry registry;
    private BundleContext startContext;
    private static IAppManager appMgr;
    private IAppStateChanageListener appListener = new AppStateChangeListerner();
    private static Logger log;
    private static final long SLEEP_MILLI = 3000L;

    public void start(BundleContext registryContext) {
        ServiceReference appMgrRef;
        this.startContext = registryContext;
        this.servicereference = registryContext.getServiceReference(WebContainer.class.getName());
        if (null == this.servicereference) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        this.servicereference = registryContext.getServiceReference(WebContainer.class.getName());
        if (this.servicereference != null) {
            RegistryActivator.setWebContainer((WebContainer)registryContext.getService(this.servicereference));
            if (RegistryActivator.getWebContainer() == null) {
                log.error("The Http Service not started!");
                throw new IllegalStateException("The Http Service not started!");
            }
        } else {
            log.error("The Http Service reference not exist!");
            throw new IllegalStateException("The Http Service reference not exist!");
        }
        RegistryActivator.setHttpContext(RegistryActivator.getWebContainer().createDefaultHttpContext());
        ServiceReference pakageAdminRef = registryContext.getServiceReference(PackageAdmin.class.getName());
        if (null != pakageAdminRef) {
            packageAdmin = (PackageAdmin)registryContext.getService(pakageAdminRef);
        }
        if (null == (appMgrRef = registryContext.getServiceReference(IAppManager.class.getName()))) {
            log.error("The IAppManager Service reference not exist!");
            throw new IllegalStateException("The IAppManager Service reference not exist!");
        }
        appMgr = (IAppManager)registryContext.getService(appMgrRef);
        appMgr.addAppStateChangeListener(this.appListener, new String[0]);
        this.registryTracker = new ServiceTracker(registryContext, IExtensionRegistry.class.getName(), (ServiceTrackerCustomizer)this);
        this.registryTracker.open();
    }

    public void stop(BundleContext registryContext) {
        this.registryTracker.close();
        this.registryTracker = null;
        this.startContext = null;
        appMgr.removeAppStateChangeListener(this.appListener, new String[0]);
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.startContext.getService(reference);
        if (service instanceof IExtensionRegistry && this.registry == null) {
            this.registry = (IExtensionRegistry)service;
        }
        if (this.registry != null) {
            this.httpServiceTracker = new HttpServiceTracker(this.startContext, this.registry);
            this.httpServiceTracker.open();
        }
        return service;
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service.equals(this.registry)) {
            this.registry = null;
        }
        if (null == this.registry && null != this.httpServiceTracker) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        this.startContext.ungetService(reference);
    }

    public void modifiedService(ServiceReference arg0, Object arg1) {
    }

    public static void setWebContainer(WebContainer webContainer) {
        RegistryActivator.webContainer = webContainer;
    }

    public static WebContainer getWebContainer() {
        return webContainer;
    }

    public static void setHttpContext(HttpContext httpContext) {
        RegistryActivator.httpContext = httpContext;
    }

    public static HttpContext getHttpContext() {
        return httpContext;
    }

    public static PackageAdmin getPackageAdmin() {
        return packageAdmin;
    }

    public static IAppManager getAppMgr() {
        if (null == appMgr) {
            throw new IllegalStateException("The AppMgr(" + IAppManager.class.getName() + ") service is not found!");
        }
        return appMgr;
    }

    static {
        appMgr = null;
        log = LoggerFactory.getLogger(RegistryActivator.class);
    }

    class AppStateChangeListerner
    implements IAppStateChanageListener {
        AppStateChangeListerner() {
        }

        public void preStateChanged(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
            if (newState == AppEntity.AppState.started) {
                WebContextMgr.addAppContext(app.getAppName());
            }
        }

        public void postStateChanged(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
            if (newState == AppEntity.AppState.stoped) {
                WebContextMgr.removeAppContext(app.getAppName());
            }
        }
    }
}

