/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.internal.ds.ConfigurationManager;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.SCRCommandProvider;
import org.eclipse.equinox.internal.ds.SCRManager;
import org.eclipse.equinox.internal.ds.WorkThread;
import org.eclipse.equinox.internal.util.ref.Log;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    public static BundleContext bc = null;
    private ServiceTracker cmTracker;
    private ServiceRegistration cmTrackerReg;
    private ServiceTracker debugTracker = null;
    private SCRManager scrManager = null;
    private ServiceRegistration scrCommandProviderReg;
    private SCRCommandProvider scrCommandProvider;
    private boolean inited = false;
    public static Log log;
    public static boolean DEBUG;
    public static boolean PERF;
    public static boolean DBSTORE;
    public static boolean INSTANTIATE_ALL;
    public static boolean startup;
    static long[] time;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        time = null;
    }

    public static void timeLog(String message) {
        Activator.time[1] = time[0];
        Activator.time[0] = System.currentTimeMillis();
        log.debug(String.valueOf(message) + String.valueOf(Activator.time[0] - time[1]), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSCR() {
        Class<?> clazz;
        Activator activator = this;
        synchronized (activator) {
            if (this.inited) {
                return;
            }
            this.inited = true;
        }
        boolean lazyIniting = false;
        if (startup && time == null) {
            long tmp = System.currentTimeMillis();
            long[] lArray = new long[3];
            lArray[0] = tmp;
            lArray[2] = tmp;
            time = lArray;
            lazyIniting = true;
            if (startup) {
                Activator.timeLog("[BEGIN - lazy SCR init]");
            }
        }
        WorkThread.IDLE_TIMEOUT = Activator.getInteger("equinox.ds.idle_timeout", 1000);
        WorkThread.BLOCK_TIMEOUT = Activator.getInteger("equinox.ds.block_timeout", 30000);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConfigurationManager.cmTracker = this.cmTracker = new ServiceTracker(bc, clazz2.getName(), null);
        this.cmTracker.open();
        if (startup) {
            Activator.timeLog("ServiceTracker starting took ");
        }
        this.scrManager = new SCRManager(bc, log);
        if (startup) {
            Activator.timeLog("SCRManager instantiation took ");
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.cm.ConfigurationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.cmTrackerReg = bc.registerService(clazz.getName(), (Object)this.scrManager, null);
        if (startup) {
            Activator.timeLog("ConfigurationListener service registered for ");
        }
        bc.addServiceListener((ServiceListener)this.scrManager);
        this.scrManager.startIt();
        if (startup) {
            Activator.timeLog("startIt() method took ");
        }
        if (this.scrCommandProvider == null) {
            this.scrCommandProvider = new SCRCommandProvider(this.scrManager);
            Hashtable reg_props = new Hashtable(3, 1.0f);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.scrCommandProviderReg = bc.registerService(clazz3.getName(), (Object)this.scrCommandProvider, reg_props);
        }
        if (startup && lazyIniting) {
            log.debug("[END - lazy SCR init] Activator.initSCR() method executed for " + String.valueOf(time[0] - time[2]), null);
            time = null;
        }
    }

    public void start(BundleContext bc) throws Exception {
        Class<?> clazz;
        Activator.bc = bc;
        startup = Activator.getBoolean("equinox.measurements.bundles", false);
        if (startup) {
            long tmp = System.currentTimeMillis();
            long[] lArray = new long[3];
            lArray[0] = tmp;
            lArray[2] = tmp;
            time = lArray;
        }
        if ((clazz = class$3) == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.debugTracker = new ServiceTracker(bc, clazz.getName(), null);
        this.debugTracker.open();
        log = new Log(bc, false);
        DEBUG = this.getBooleanDebugOption("org.eclipse.equinox.ds/debug", false) || Activator.getBoolean("equinox.ds.debug", false);
        PERF = this.getBooleanDebugOption("org.eclipse.equinox.ds/performance", false) || Activator.getBoolean("equinox.ds.perf", false);
        INSTANTIATE_ALL = this.getBooleanDebugOption("org.eclipse.equinox.ds/instantiate_all", false) || Activator.getBoolean("equinox.ds.instantiate_all", false);
        DBSTORE = this.getBooleanDebugOption("org.eclipse.equinox.ds/cache_descriptions", true) || Activator.getBoolean("equinox.ds.dbstore", true);
        log.setDebug(DEBUG);
        boolean print = this.getBooleanDebugOption("org.eclipse.equinox.ds/print_on_console", false) || Activator.getBoolean("equinox.ds.print", false);
        log.setPrintOnConsole(print);
        if (startup) {
            Activator.timeLog("[BEGIN - start method] Creating Log instance and initializing log system took ");
        }
        boolean hasHeaders = false;
        Bundle[] allBundles = bc.getBundles();
        int i = 0;
        while (i < allBundles.length) {
            Dictionary allHeaders = allBundles[i].getHeaders("");
            if (allHeaders.get("Service-Component") != null) {
                hasHeaders = true;
                break;
            }
            ++i;
        }
        if (hasHeaders) {
            this.initSCR();
        } else {
            bc.addBundleListener((BundleListener)this);
        }
        if (startup) {
            log.debug("[END - start method] Activator.start() method executed for " + String.valueOf(time[0] - time[2]), null);
            time = null;
        }
    }

    public void stop(BundleContext bc) throws Exception {
        if (this.scrManager != null) {
            this.scrManager.stopIt();
            bc.removeServiceListener((ServiceListener)this.scrManager);
        }
        if (this.cmTrackerReg != null) {
            this.cmTrackerReg.unregister();
        }
        if (this.scrCommandProviderReg != null) {
            this.scrCommandProviderReg.unregister();
        }
        this.scrCommandProvider = null;
        if (this.scrManager != null) {
            bc.removeBundleListener((BundleListener)this.scrManager);
        } else {
            bc.removeBundleListener((BundleListener)this);
        }
        if (this.cmTracker != null) {
            ConfigurationManager.cmTracker = null;
            this.cmTracker.close();
            this.cmTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        log.close();
        log = null;
        bc = null;
    }

    public static Filter createFilter(String filter) throws InvalidSyntaxException {
        return bc.createFilter(filter);
    }

    public void bundleChanged(BundleEvent event) {
        Dictionary allHeaders;
        if ((event.getType() == 2 || event.getType() == 512) && (allHeaders = event.getBundle().getHeaders("")).get("Service-Component") != null) {
            bc.removeBundleListener((BundleListener)this);
            this.initSCR();
        }
    }

    public static boolean getBoolean(String property, boolean defaultValue) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        if (prop != null) {
            return prop.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public static boolean getBoolean(String property) {
        return Activator.getBoolean(property, false);
    }

    public static int getInteger(String property, int defaultValue) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        if (prop != null) {
            try {
                return Integer.decode(prop);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        if (this.debugTracker == null) {
            return defaultValue;
        }
        DebugOptions options = (DebugOptions)this.debugTracker.getService();
        if (options != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public static void log(BundleContext bundleContext, int level, String message, Throwable t) {
        ServiceReference logRef;
        LogService logService;
        block18: {
            logService = null;
            logRef = null;
            try {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("org.osgi.service.log.LogService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logRef = bundleContext.getServiceReference(clazz.getName());
                logService = (LogService)bundleContext.getService(logRef);
            }
            catch (Exception e) {
                if (!DEBUG) break block18;
                log.debug(NLS.bind((String)Messages.CANNOT_GET_LOGSERVICE, (Object)bundleContext.getBundle().getSymbolicName()), (Throwable)e);
            }
        }
        if (logService != null) {
            logService.log(level, message, t);
            bundleContext.ungetService(logRef);
            if (log.getPrintOnConsole()) {
                String prefix = "";
                switch (level) {
                    case 1: {
                        prefix = "ERROR ";
                        break;
                    }
                    case 2: {
                        prefix = "WARNING ";
                        break;
                    }
                    case 3: {
                        prefix = "INFO ";
                    }
                }
                Activator.dumpOnConsole(prefix, bundleContext, message, t);
            }
        } else {
            switch (level) {
                case 1: {
                    log.error(message, t);
                    break;
                }
                case 2: {
                    log.warning(message, t);
                    break;
                }
                default: {
                    log.error(message, t);
                }
            }
        }
    }

    private static void dumpOnConsole(String prefix, BundleContext bundleContext, String msg, Throwable t) {
        System.out.println(String.valueOf(prefix) + bundleContext.getBundle().getBundleId() + " " + msg);
        if (t != null) {
            t.printStackTrace();
        }
    }
}

