/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.appmanager.api.IAppManager;
import com.huawei.uflight.log.osgi.LogBundleActivator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;

public final class LogConfiguratorMgr
extends PropertyConfigurator {
    private static final String IMAP_ROOT_ENV = "IMAP_ROOT";
    private static final String UFLIGHT_INSTANCE_NAME = "frame_uflight_server";
    private static LogConfiguratorMgr instance = new LogConfiguratorMgr();

    private LogConfiguratorMgr() {
    }

    public static LogConfiguratorMgr getInstance() {
        return instance;
    }

    public static void configure(String configFilename) {
        LogConfiguratorMgr.configure(null, configFilename);
    }

    public static void configure(URL configURL) {
        LogConfiguratorMgr.configure(null, configURL);
    }

    public static void configure(Properties properties) {
        LogConfiguratorMgr.configure(null, properties);
    }

    public static void configure(String appName, String configFilename) {
        Properties properties = LogConfiguratorMgr.getProperties(configFilename);
        LogConfiguratorMgr.configure(appName, properties);
    }

    public static void configure(String appName, URL configURL) {
        Properties properties = LogConfiguratorMgr.getProperties(configURL);
        LogConfiguratorMgr.configure(appName, properties);
    }

    public static void configure(String appName, Properties properties) {
        instance.doConfigure(appName, properties, LogManager.getLoggerRepository());
    }

    public void doConfigure(String appName, Properties properties, LoggerRepository hierarchy) {
        this.convertProperties(appName, properties);
        this.doConfigure(properties, hierarchy, false);
    }

    public void doConfigure(Properties properties, LoggerRepository hierarchy) {
        this.doConfigure(properties, hierarchy, false);
    }

    public static void addConfigure(String appName, String configFileName) {
        Properties props = LogConfiguratorMgr.getProperties(configFileName);
        LogConfiguratorMgr.addConfigure(appName, props);
    }

    public static void addConfigure(String appName, URL configURL) {
        Properties props = LogConfiguratorMgr.getProperties(configURL);
        LogConfiguratorMgr.addConfigure(appName, props);
    }

    public static void addConfigure(String appName, Properties properties) {
        instance.addConfigure(appName, properties, LogManager.getLoggerRepository());
    }

    public void addConfigure(String appName, Properties properties, LoggerRepository hierarchy) {
        this.convertProperties(appName, properties);
        this.doConfigure(properties, hierarchy, true);
    }

    void doConfigure(Properties properties, LoggerRepository hierarchy, boolean isAdd) {
        String thresholdStr;
        String reset;
        LogLog.debug((String)("the registry.size =" + this.registry.size()));
        String value = properties.getProperty("log4j.debug");
        if (value == null && (value = properties.getProperty("log4j.configDebug")) != null) {
            LogLog.warn((String)"[log4j.configDebug] is deprecated. Use [log4j.debug] instead.");
        }
        if (value != null) {
            LogLog.setInternalDebugging((boolean)OptionConverter.toBoolean((String)value, (boolean)true));
        }
        if ((reset = properties.getProperty("log4j.reset")) != null && OptionConverter.toBoolean((String)reset, (boolean)false)) {
            hierarchy.resetConfiguration();
        }
        if ((thresholdStr = OptionConverter.findAndSubst((String)"log4j.threshold", (Properties)properties)) != null) {
            hierarchy.setThreshold(OptionConverter.toLevel((String)thresholdStr, (Level)Level.ALL));
            LogLog.debug((String)("Hierarchy threshold set to [" + hierarchy.getThreshold() + "]."));
        }
        if (!isAdd) {
            this.configureRootCategory(properties, hierarchy);
            this.configureLoggerFactory(properties);
        }
        this.parseCatsAndRenderers(properties, hierarchy);
        LogLog.debug((String)"Finished configuring.");
    }

    public static void removeConfigure(String appName, String configFileName) {
        Properties props = LogConfiguratorMgr.getProperties(configFileName);
        LogConfiguratorMgr.removeConfigure(appName, props);
    }

    public static void removeConfigure(String appName, URL configURL) {
        Properties props = LogConfiguratorMgr.getProperties(configURL);
        LogConfiguratorMgr.removeConfigure(appName, props);
    }

    public static void removeConfigure(String appName, Properties properties) {
        instance.removeConfigure(appName, properties, LogManager.getLoggerRepository());
    }

    void removeConfigure(String appName, Properties properties, LoggerRepository hierarchy) {
        this.convertProperties(appName, properties);
        this.doRemoveConfigure(properties, hierarchy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveConfigure(Properties properties, LoggerRepository hierarchy) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Logger logger;
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("log4j.category.") && !key.startsWith("log4j.logger.")) continue;
            String loggerName = null;
            if (key.startsWith("log4j.category.")) {
                loggerName = key.substring("log4j.category.".length());
            } else if (key.startsWith("log4j.logger.")) {
                loggerName = key.substring("log4j.logger.".length());
            }
            String value = OptionConverter.findAndSubst((String)key, (Properties)properties);
            Logger logger2 = logger = hierarchy.getLogger(loggerName, this.loggerFactory);
            synchronized (logger2) {
                logger.setLevel(Level.OFF);
                StringTokenizer st = new StringTokenizer(value, ",");
                st.nextToken();
                while (st.hasMoreTokens()) {
                    String appenderName = st.nextToken().trim();
                    if (appenderName == null || appenderName.equals(",")) continue;
                    LogLog.debug((String)("Remove appender named \"" + appenderName + "\"."));
                    logger.removeAppender(appenderName);
                    this.registry.remove(appenderName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(String configFileName) {
        Properties props = new Properties();
        File configFile = new File(configFileName);
        if (!configFile.exists() || !configFile.isFile()) {
            LogLog.error((String)("Configuration file is not exist or is not a file [" + configFileName + "]."));
            return props;
        }
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(configFileName);
            props.load(istream);
            istream.close();
        }
        catch (Exception e) {
            LogLog.error((String)("Could not read configuration file [" + configFileName + "]."), (Throwable)e);
            LogLog.error((String)("Ignoring configuration file [" + configFileName + "]."), (Throwable)e);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Exception ignore) {
                    LogLog.error((String)"Close FileInputStream Fail.", (Throwable)ignore);
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(URL configURL) {
        Properties props = new Properties();
        LogLog.debug((String)("Reading configuration from URL " + configURL));
        InputStream istream = null;
        try {
            istream = configURL.openStream();
            props.load(istream);
        }
        catch (Exception e) {
            LogLog.error((String)("Could not read configuration file from URL [" + configURL + "]."), (Throwable)e);
            LogLog.error((String)("Ignoring configuration file [" + configURL + "]."));
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Exception ignore) {
                    LogLog.error((String)"Close FileInputStream Fail.", (Throwable)ignore);
                }
            }
        }
        return props;
    }

    private void convertProperties(String appName, Properties properties) {
        Set<Map.Entry<Object, Object>> propertiesSet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : propertiesSet) {
            String key = ((String)entry.getKey()).trim();
            String value = ((String)entry.getValue()).trim();
            if (!key.startsWith("log4j.appender") || !key.endsWith(".File")) continue;
            this.reSetLogFile(appName, entry, value);
        }
    }

    private void reSetLogFile(String appName, Map.Entry<Object, Object> entry, String value) {
        int suffixIndex = value.lastIndexOf(".");
        if (-1 == suffixIndex) {
            throw new IllegalArgumentException("fileName is not valid. fileName = " + value);
        }
        File file = new File(value);
        if (null == appName || appName.isEmpty()) {
            return;
        }
        String fileNameNoSuffix = file.getName();
        String parentDir = this.getParentDir(appName);
        String fileName = fileNameNoSuffix;
        if (null != parentDir && !parentDir.isEmpty()) {
            fileName = parentDir + File.separator + fileName;
        }
        entry.setValue(fileName);
    }

    private String getParentDir(String appName) {
        if (null == appName) {
            return ".";
        }
        IAppManager appMgr = LogBundleActivator.getAppMgr();
        if (appMgr.isDebugMode()) {
            return "./logs";
        }
        if (DeploymentMode.independent == appMgr.getDeploymentMode()) {
            if (this.isFrameApp(appName)) {
                appName = this.getUflightLogDir();
            }
            return "./logs/" + appName;
        }
        String logFilePath = System.getenv(IMAP_ROOT_ENV) + "/var/logs/Develop/";
        String instanceName = System.getProperty("instanceName");
        if (this.isFrameApp(appName)) {
            logFilePath = UFLIGHT_INSTANCE_NAME.equalsIgnoreCase(instanceName) ? logFilePath + this.getUflightLogDir() : logFilePath + "uflight_" + instanceName;
            return logFilePath;
        }
        if (UFLIGHT_INSTANCE_NAME.equalsIgnoreCase(instanceName)) {
            logFilePath = logFilePath + this.getUflightLogDir() + File.separator + appName;
            return logFilePath;
        }
        logFilePath = logFilePath + "uflight_" + instanceName + File.separator + appName;
        return logFilePath;
    }

    private String getUflightLogDir() {
        return "uflight";
    }

    private boolean isFrameApp(String appName) {
        return null == appName || appName.equalsIgnoreCase("CORE_APP") || appName.equalsIgnoreCase("FRAME_APP") || appName.equalsIgnoreCase("WEB_APP");
    }
}

