/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.helpers.LogLog;

final class FileArchiver {
    private FileArchiver() {
    }

    static synchronized void archiveFiles(String zipFile, File[] files) {
        if (null != files && 0 != files.length) {
            try {
                FileArchiver.archiveFiles(zipFile, files, 0, files.length - 1);
            }
            catch (IOException ex) {
                LogLog.error((String)("archiveFile failed, archiveFile = " + zipFile), (Throwable)ex);
            }
        }
    }

    private static List<File> collectFiles(File[] files, int begin, int end) {
        ArrayList<File> filesWillBeArchived = new ArrayList<File>();
        if (begin > end) {
            return null;
        }
        for (int i = begin; i <= end; ++i) {
            if (null == files[i] || !files[i].exists()) continue;
            if (files[i].length() > 0L) {
                filesWillBeArchived.add(files[i]);
                continue;
            }
            if (files[i].delete()) continue;
            LogLog.error((String)("delete empty file failed, file = " + files[i].getAbsolutePath()));
        }
        return filesWillBeArchived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void archiveFiles(String zipFile, File[] files, int begin, int end) throws IOException {
        List<File> filesWillBeArchived = FileArchiver.collectFiles(files, begin, end);
        if (filesWillBeArchived.isEmpty()) {
            return;
        }
        FileOutputStream fo = null;
        ZipOutputStream zo = null;
        try {
            fo = new FileOutputStream(zipFile);
            zo = new ZipOutputStream(fo);
            for (File file : filesWillBeArchived) {
                ZipEntry ze = new ZipEntry(file.getName());
                ze.setTime(file.lastModified());
                zo.putNextEntry(ze);
                FileArchiver.zipFile(zo, file);
                if (file.delete()) continue;
                LogLog.warn((String)("delete file fail, the file is : " + file.getAbsolutePath()));
            }
        }
        catch (Exception ex) {
            LogLog.error((String)"archiveFiles() fail!", (Throwable)ex);
        }
        finally {
            if (null != zo) {
                zo.close();
            }
            if (null != fo) {
                fo.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long zipFile(OutputStream zo, File file) throws IOException {
        byte[] buff = new byte[1024];
        long size = 0L;
        FileInputStream in = null;
        BufferedInputStream bin = null;
        try {
            in = new FileInputStream(file);
            bin = new BufferedInputStream(in);
            int len = 0;
            while (len >= 0) {
                len = bin.read(buff);
                if (-1 == len) continue;
                zo.write(buff, 0, len);
                size += (long)len;
            }
        }
        catch (Exception ex) {
            LogLog.error((String)("zipFile failed, file = " + file), (Throwable)ex);
        }
        finally {
            if (bin != null) {
                bin.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return size;
    }
}

