/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.log4j.FileAppender;
import org.apache.log4j.FileArchiver;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class CompressableRollingFileAppender
extends FileAppender {
    private static final String ZIP_FILE_SUFFIX = ".zip";
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupArchiveIndex = 20;
    private long nextRollover = 0L;
    protected int maxFileIndex = 10;
    private String originalFileName;
    private File directory;
    private String fileNameNoSuffix;
    private String suffix;

    public CompressableRollingFileAppender() {
    }

    public CompressableRollingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public CompressableRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public int getMaxFileIndex() {
        return this.maxFileIndex;
    }

    public void setMaxFileIndex(int maxFileIndex) {
        this.maxFileIndex = maxFileIndex;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    public int getMaxBackupArchiveIndex() {
        return this.maxBackupArchiveIndex;
    }

    public void setMaxBackupArchiveIndex(int maxBackupArchiveIndex) {
        this.maxBackupArchiveIndex = maxBackupArchiveIndex;
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(String fileName) {
        super.setFile(fileName);
        File file = new File(this.getFile());
        this.originalFileName = file.getName();
        try {
            this.directory = file.getParentFile().getCanonicalFile();
        }
        catch (IOException e) {
            LogLog.error((String)("file.getParentFile().getCanonicalFile() fail, fileName=" + fileName), (Throwable)e);
        }
        int suffixIndex = this.originalFileName.lastIndexOf(".");
        if (-1 == suffixIndex) {
            throw new IllegalArgumentException("fileName is not valid. fileName = " + this.originalFileName);
        }
        this.fileNameNoSuffix = this.originalFileName.substring(0, suffixIndex);
        CompressableRollingFileAppender compressableRollingFileAppender = this;
        synchronized (compressableRollingFileAppender) {
            this.suffix = this.originalFileName.substring(suffixIndex);
        }
    }

    private void rollOver() {
        if (null != this.qw) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug((String)("rolling over count=" + size));
            this.nextRollover = size + this.maxFileSize;
        }
        this.closeFile();
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
            this.nextRollover = 0L;
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (null != this.fileName && null != this.qw && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && size >= this.nextRollover) {
            this.rollOver();
        }
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        String generatedFileName = this.generateFileName();
        String newFileName = generatedFileName + this.suffix;
        LogLog.debug((String)("setFile " + newFileName + "begin"));
        super.setFile(newFileName, append, this.bufferedIO, this.bufferSize);
        LogLog.debug((String)("setFile " + newFileName + "end"));
        File[] files = this.listFiles(newFileName);
        if (null != files && files.length >= this.getMaxFileIndex()) {
            this.asychronizeArchiveFiles(generatedFileName + ZIP_FILE_SUFFIX, files);
        }
    }

    private void asychronizeArchiveFiles(final String zipFile, final File[] files) {
        Thread archiveThread = new Thread(){

            @Override
            public void run() {
                LogLog.debug((String)("asychronizeArchiveFiles:" + zipFile));
                CompressableRollingFileAppender.this.deleteTimeOutArchives();
                FileArchiver.archiveFiles(zipFile, files);
            }
        };
        archiveThread.setName("archiveThread: " + FileArchiver.class.getName());
        archiveThread.start();
    }

    private String generateFileName() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss");
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.directory.getAbsolutePath());
        sb.append('/');
        sb.append(this.fileNameNoSuffix);
        sb.append('-');
        sb.append(format.format(date));
        return sb.toString();
    }

    private File[] listFiles(final String currentFile) {
        return this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean isSameTypeFile = name.endsWith(CompressableRollingFileAppender.this.suffix);
                boolean isSameDirectory = dir.getAbsolutePath().equalsIgnoreCase(CompressableRollingFileAppender.this.directory.getAbsolutePath());
                boolean matchFileName = -1 != name.indexOf(CompressableRollingFileAppender.this.fileNameNoSuffix);
                boolean isCurrentFile = currentFile.endsWith(name);
                return isSameDirectory && isSameTypeFile && matchFileName && !isCurrentFile;
            }
        });
    }

    private void deleteTimeOutArchives() {
        File[] archives = this.listArchives();
        if (null != archives && archives.length >= this.getMaxBackupArchiveIndex()) {
            Arrays.sort(archives, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return (int)(file1.lastModified() - file2.lastModified());
                }
            });
            int timeOutFileLength = Math.max(1, archives.length - this.getMaxBackupArchiveIndex());
            for (int i = 0; i < timeOutFileLength; ++i) {
                if (archives[i].delete()) continue;
                LogLog.error((String)("deleteTimeOutArchives fail, the file is :" + archives[i]));
            }
        }
    }

    private File[] listArchives() {
        return this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean isZipFile = name.endsWith(CompressableRollingFileAppender.ZIP_FILE_SUFFIX);
                boolean isSameDirectory = dir.getAbsolutePath().equalsIgnoreCase(CompressableRollingFileAppender.this.directory.getAbsolutePath());
                boolean matchFileName = -1 != name.indexOf(CompressableRollingFileAppender.this.fileNameNoSuffix);
                return isZipFile && isSameDirectory && matchFileName;
            }
        });
    }
}

