/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.impl.Slf4jLogImpl;

public class LogFactory {
    public static final String PRIORITY_KEY = "priority";
    public static final String TCCL_KEY = "use_tccl";
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    public static final String DIAGNOSTICS_DEST_PROPERTY = "org.apache.commons.logging.diagnostics.dest";
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.apache.commons.logging.LogFactory.HashtableImpl";
    private static final LogFactory FACTORY = new LogFactory();
    private Map<String, Log> instances = Collections.synchronizedMap(new WeakHashMap());

    protected LogFactory() {
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String name) throws LogConfigurationException {
        if (this.instances.containsKey(name)) {
            return this.instances.get(name);
        }
        Slf4jLogImpl log = new Slf4jLogImpl(name);
        this.instances.put(name, log);
        return log;
    }

    public void release() {
        this.instances.clear();
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, Object value) {
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return FACTORY;
    }

    public static Log getLog(Class clazz) {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void release(ClassLoader classLoader) {
        LogFactory.getFactory().instances.clear();
    }

    public static void releaseAll() {
        LogFactory.getFactory().instances.clear();
    }

    public static String objectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }
}

