/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.log.osgi;

import com.huawei.uflight.appmanager.api.IAppManager;
import com.huawei.uflight.appmanager.api.IAppStateChanageListener;
import java.io.File;
import java.net.MalformedURLException;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogConfiguratorMgr;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class LogBundleActivator
implements BundleActivator {
    static final String LOG_CONFIG_FILE = "conf/log4j.properties";
    private static final String DEBUG_MODE = "debug";
    private static Object appMgr = null;
    private static Object listerner = null;

    public static IAppManager getAppMgr() {
        if (null == appMgr) {
            throw new IllegalStateException("The AppMgr(com.huawei.uflight.appmanager.api.IAppManager) service is not found!");
        }
        return (IAppManager)appMgr;
    }

    public void start(BundleContext context) throws MalformedURLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        File file = new File(LOG_CONFIG_FILE);
        ServiceReference reference = context.getServiceReference("com.huawei.uflight.appmanager.api.IAppManager");
        if (null == reference) {
            LogConfiguratorMgr.configure(file.toURI().toURL());
            return;
        }
        appMgr = context.getService(reference);
        if (null == appMgr) {
            LogConfiguratorMgr.configure(file.toURI().toURL());
            return;
        }
        boolean isDebugMode = Boolean.valueOf(System.getProperty(DEBUG_MODE));
        if (isDebugMode) {
            LogConfiguratorMgr.configure(file.toURI().toURL());
            return;
        }
        LogConfiguratorMgr.configure("CORE_APP", file.toURI().toURL());
        listerner = Class.forName("com.huawei.uflight.log.osgi.AppStateChangeListerner").newInstance();
        LogBundleActivator.getAppMgr().addAppStateChangeListener((IAppStateChanageListener)listerner, new String[0]);
    }

    public void stop(BundleContext arg0) {
        LogFactory.releaseAll();
        if (null != listerner) {
            LogBundleActivator.getAppMgr().removeAppStateChangeListener((IAppStateChanageListener)listerner, new String[0]);
        }
        appMgr = null;
        listerner = null;
    }
}

