/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.appmanager.impl.runtime;

import com.huawei.uflight.appmanager.Activator;
import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.impl.AbstractAppManager;
import com.huawei.uflight.appmanager.impl.runtime.AppEntityFactory;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.Bundle;

public class RuntimeAppManager
extends AbstractAppManager {
    private static final String INSTANCE_PROPERTIES = "instanceName";
    private Map<String, AppEntity> cachedApps = new HashMap<String, AppEntity>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private String instanceName = System.getProperty("instanceName");

    public RuntimeAppManager() {
        if (null == this.instanceName) {
            IllegalArgumentException ex = new IllegalArgumentException("instanceName must be configed as JVM options");
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "", 0, (Throwable)ex, null);
            Activator.getFrameworkLog().log(entry);
            throw ex;
        }
    }

    @Override
    public void init() {
        this.scanApps();
        this.startDefaultApps();
    }

    private String getInstanceConfigDir() {
        return this.getWorkingDir() + File.separator + "bin" + File.separator + this.instanceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startDefaultApps() {
        this.lock.readLock().lock();
        ArrayList<AppEntity> defaultStartApps = new ArrayList<AppEntity>();
        try {
            for (AppEntity app : this.cachedApps.values()) {
                if (!app.isAutoStart()) continue;
                defaultStartApps.add(app);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (defaultStartApps.isEmpty()) {
            return;
        }
        Collections.sort(defaultStartApps, new Comparator<AppEntity>(){

            @Override
            public int compare(AppEntity o1, AppEntity o2) {
                return o1.getStartLevel() - o2.getStartLevel();
            }
        });
        for (AppEntity app : defaultStartApps) {
            this.doStartApp(app);
        }
    }

    @Override
    public boolean startApp(String appName) {
        this.scanApps();
        AppEntity app = this.getAppByName(appName);
        if (AppEntity.AppState.stoped == app.getState() && this.isExistApp(app)) {
            return this.doStartApp(app);
        }
        return false;
    }

    private boolean doStartApp(AppEntity app) {
        AppEntity.AppState oldState = app.getState();
        this.notifyPreStateChgListeners(app, oldState, AppEntity.AppState.started);
        boolean result = app.start();
        if (result) {
            this.notifyPostStateChgListeners(app, oldState, app.getState());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppEntity getAppByName(String appName) {
        if (null == appName) {
            throw new IllegalArgumentException("appName can not be null");
        }
        this.lock.readLock().lock();
        try {
            AppEntity appEntity = this.cachedApps.containsKey(appName) ? this.cachedApps.get(appName) : AppEntityFactory.createUndeployedAppEntity(appName, this.getDeploymentMode());
            return appEntity;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean stopApp(String appName) {
        AppEntity app = this.getAppByName(appName);
        if (AppEntity.AppState.started != app.getState() || !app.canStop()) {
            return false;
        }
        boolean result = this.doStopApp(this.getAppByName(appName));
        if (result) {
            this.scanApps();
        }
        return result;
    }

    private boolean doStopApp(AppEntity app) {
        AppEntity.AppState oldState = app.getState();
        this.notifyPreStateChgListeners(app, oldState, AppEntity.AppState.stoped);
        boolean result = app.stop();
        if (result) {
            this.notifyPostStateChgListeners(app, oldState, app.getState());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scanApps() {
        String appPath = this.getInstanceConfigDir();
        File configDir = new File(appPath);
        if (!configDir.exists() || !configDir.isDirectory()) {
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "Any app configed", 0, null, null);
            Activator.getFrameworkLog().log(entry);
            return;
        }
        FrameworkLogEntry appPathEntry = new FrameworkLogEntry("org.eclipse.osgi", 1, 0, "Instance configDir is" + appPath, 0, null, null);
        Activator.getFrameworkLog().log(appPathEntry);
        File[] configFiles = configDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase(Locale.getDefault()).endsWith(".cfg");
            }
        });
        if (configFiles == null) {
            return;
        }
        HashMap<String, AppEntity> tmpCache = new HashMap<String, AppEntity>();
        for (File appConfig : configFiles) {
            try {
                AppEntity app = AppEntityFactory.createAppEntity(appConfig, this.getDeploymentMode(), this.getWorkingDir());
                this.cacheApp(app, tmpCache);
            }
            catch (Exception ex) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, ex.getMessage(), 0, (Throwable)ex, null);
                Activator.getFrameworkLog().log(entry);
            }
        }
        this.lock.writeLock().lock();
        try {
            this.cachedApps = tmpCache;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheApp(AppEntity app, Map<String, AppEntity> cache) {
        this.lock.writeLock().lock();
        try {
            if (this.cachedApps.containsKey(app.getAppName())) {
                AppEntity cachedApp = this.cachedApps.get(app.getAppName());
                if (AppEntity.AppState.started == cachedApp.getState()) {
                    cache.put(app.getAppName(), cachedApp);
                } else {
                    cache.put(app.getAppName(), app);
                }
            } else {
                cache.put(app.getAppName(), app);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppEntity getAppByBundle(Bundle bundle) {
        if (null == bundle) {
            throw new IllegalArgumentException("bundle can not be null");
        }
        this.lock.readLock().lock();
        try {
            for (AppEntity app : this.cachedApps.values()) {
                String[] locations = app.getBundleLocations();
                if (null == locations || 0 == locations.length) continue;
                for (String tmp : locations) {
                    if (!bundle.getLocation().equalsIgnoreCase(tmp)) continue;
                    AppEntity appEntity = app;
                    return appEntity;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    private boolean isExistApp(AppEntity app) {
        File file = new File(app.getAppPath());
        return file.exists();
    }

    @Override
    public List<AppEntity> getAllApps() {
        return new ArrayList<AppEntity>(this.cachedApps.values());
    }
}

