/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.appmanager.impl.runtime;

import com.huawei.uflight.appmanager.Activator;
import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.internal.IAppOperator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.Semaphore;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

class AppOperator
implements IAppOperator {
    private static Map<String, String[]> searchCandidates = new HashMap<String, String[]>(4);
    private static final int VERSION_FOUR = 4;
    private static final int VERSION_THREE = 3;
    private static final String PROP_FORCED_RESTART = "osgi.forcedRestart";
    private static final String FILE_SCHEME = "file:";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String REFERENCE_PROTOCOL = "reference";
    private static final String INITIAL_LOCATION = "initial@";
    protected static final String DEFAULT_ADAPTOR_CLASS = "org.eclipse.osgi.baseadaptor.BaseAdaptor";
    private static final String DEFAULT_BUNDLES_STARTLEVEL = "4";
    protected static final String DEFAULT_CONSOLE_CLASS = "org.eclipse.osgi.framework.internal.core.FrameworkConsole";
    private static final String CONFIG_URL = "com.huawei.uflight.appmanager.configUrl";
    private static final String DEFAULT_CONFIG_URL = "conf/bundles.info";
    private static final String PLUGINS_DIR = "plugins";

    AppOperator() {
    }

    @Override
    public boolean startApp(AppEntity app) {
        Bundle[] loadedBundles = null;
        try {
            loadedBundles = this.loadBundles(app, new String[0]);
        }
        catch (Exception ex) {
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "startApp failed", 0, (Throwable)ex, null);
            Activator.getFrameworkLog().log(entry);
        }
        return null != loadedBundles;
    }

    @Override
    public boolean stopApp(AppEntity app) {
        Bundle[] bundles = app.getBundles();
        if (null == bundles || 0 == bundles.length) {
            return false;
        }
        return this.uninstallBundle(app, bundles);
    }

    @Override
    public boolean undeployApp(AppEntity app) {
        return this.stopApp(app);
    }

    private Bundle[] loadBundles(AppEntity app, String ... addInstallEntries) throws IOException {
        String[] installEntries = addInstallEntries;
        if (installEntries.length == 0) {
            installEntries = AppOperator.getConfigedBundles(app.getAppPath());
        }
        if (null == installEntries || 0 == installEntries.length) {
            return null;
        }
        BundleDescription[] bundleDescriptions = AppOperator.getBundleDescriptions(installEntries, app.getAppPath());
        Bundle[] curInitBundles = AppOperator.getCurrentBundles(true);
        ArrayList<Bundle> toRefresh = new ArrayList<Bundle>(curInitBundles.length);
        ArrayList<Bundle> startBundles = new ArrayList<Bundle>(installEntries.length);
        ArrayList<Bundle> lazyActivationBundles = new ArrayList<Bundle>(installEntries.length);
        String[] bundleLocations = new String[bundleDescriptions.length];
        int len = bundleDescriptions.length;
        for (int i = 0; i < len; ++i) {
            bundleLocations[i] = bundleDescriptions[i].locationString;
        }
        String[] oldBundleLocations = app.getBundleLocations();
        if (0 != addInstallEntries.length && null != oldBundleLocations) {
            String[] newBundleLocations = new String[oldBundleLocations.length + bundleLocations.length];
            System.arraycopy(oldBundleLocations, 0, newBundleLocations, 0, oldBundleLocations.length);
            System.arraycopy(bundleLocations, 0, newBundleLocations, oldBundleLocations.length, bundleLocations.length);
            app.setBundleLocations(newBundleLocations);
        } else {
            app.setBundleLocations(bundleLocations);
        }
        AppOperator.installBundles(bundleDescriptions, curInitBundles, startBundles, lazyActivationBundles, toRefresh);
        if (!toRefresh.isEmpty() && AppOperator.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]))) {
            return null;
        }
        Bundle[] startInitBundles = startBundles.toArray(new Bundle[startBundles.size()]);
        Bundle[] lazyInitBundles = lazyActivationBundles.toArray(new Bundle[lazyActivationBundles.size()]);
        Bundle[] allBundles = new Bundle[startInitBundles.length + lazyInitBundles.length];
        System.arraycopy(startInitBundles, 0, allBundles, 0, startInitBundles.length);
        System.arraycopy(lazyInitBundles, 0, allBundles, startInitBundles.length, lazyInitBundles.length);
        Bundle[] oldBundles = app.getBundles();
        if (0 != addInstallEntries.length && null != oldBundles) {
            Bundle[] newBundles = new Bundle[oldBundles.length + allBundles.length];
            System.arraycopy(oldBundles, 0, newBundles, 0, oldBundles.length);
            System.arraycopy(allBundles, 0, newBundles, oldBundles.length, allBundles.length);
            app.setBundles(newBundles);
        } else {
            app.setBundles(allBundles);
        }
        AppOperator.startBundles(startInitBundles, lazyInitBundles);
        return startInitBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getConfigedBundles(String appPath) {
        FrameworkLogEntry entry;
        String configUrl = FrameworkProperties.getProperty((String)CONFIG_URL, (String)DEFAULT_CONFIG_URL);
        StringBuffer configFile = new StringBuffer();
        configFile.append(appPath);
        configFile.append(File.separator);
        configFile.append(configUrl);
        ArrayList<String> bundles = new ArrayList<String>();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(configFile.toString()));
            while (null != (str = in.readLine())) {
                bundles.add(str);
            }
        }
        catch (FileNotFoundException e) {
            entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "", 0, (Throwable)e, null);
            Activator.getFrameworkLog().log(entry);
        }
        catch (IOException e) {
            FrameworkLogEntry entry2 = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "", 0, (Throwable)e, null);
            Activator.getFrameworkLog().log(entry2);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "", 0, (Throwable)e, null);
                    Activator.getFrameworkLog().log(entry);
                }
            }
        }
        return bundles.toArray(new String[bundles.size()]);
    }

    private static BundleDescription[] getBundleDescriptions(String[] installEntries, String appPath) throws MalformedURLException {
        searchCandidates.clear();
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>(installEntries.length);
        int defaultStartLevel = Integer.parseInt(FrameworkProperties.getProperty((String)"osgi.bundles.defaultStartLevel", (String)DEFAULT_BUNDLES_STARTLEVEL));
        for (int i = 0; i < installEntries.length; ++i) {
            FrameworkLogEntry entry;
            String name = installEntries[i].trim();
            int level = defaultStartLevel;
            boolean start = true;
            int index = name.indexOf(44);
            if (index >= 0) {
                level = Integer.parseInt(name.substring(index + 1).trim());
                name = name.substring(0, index).trim();
            }
            try {
                URL location = AppOperator.searchForBundle(appPath, name);
                if (null == location) {
                    entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_STARTUP_BUNDLE_NOT_FOUND, (Object)installEntries[i]), 0, null, null);
                    Activator.getFrameworkLog().log(entry);
                    continue;
                }
                String locationString = INITIAL_LOCATION + AppOperator.makeRelative(appPath, location).toExternalForm();
                result.add(new BundleDescription(locationString, location, level, start));
                continue;
            }
            catch (Exception ex) {
                entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_STARTUP_BUNDLE_NOT_FOUND, (Object)installEntries[i]), 0, null, null);
                Activator.getFrameworkLog().log(entry);
            }
        }
        return result.toArray(new BundleDescription[result.size()]);
    }

    private static URL searchForBundle(String appPath, String name) throws MalformedURLException, IOException {
        Object result;
        String pluginDir = new File(appPath + File.separator + PLUGINS_DIR).getCanonicalPath();
        URL url = null;
        File fileLocation = null;
        boolean reference = false;
        try {
            new URL(name);
            url = new URL(new File(pluginDir).toURI().toURL(), name);
        }
        catch (MalformedURLException e) {
            File child = new File(name);
            fileLocation = child.isAbsolute() ? child : new File(pluginDir, name);
            url = new URL(REFERENCE_PROTOCOL, null, fileLocation.toURI().toURL().toExternalForm());
            reference = true;
        }
        if (!reference) {
            URL baseURL = url;
            if (url.getProtocol().equals(REFERENCE_PROTOCOL)) {
                File child;
                reference = true;
                String baseSpec = url.getFile();
                baseURL = baseSpec.startsWith(FILE_SCHEME) ? ((child = new File(baseSpec.substring(5))).isAbsolute() ? child.toURI().toURL() : new File(appPath, child.getPath()).toURI().toURL()) : new URL(baseSpec);
            }
            if (!(fileLocation = new File(baseURL.getFile())).isAbsolute()) {
                fileLocation = new File(appPath, fileLocation.toString());
            }
        }
        if (reference) {
            result = AppOperator.searchFor(fileLocation.getName(), new File(fileLocation.getParent()).getAbsolutePath());
            if (null != result) {
                url = new URL(REFERENCE_PROTOCOL, null, FILE_SCHEME + (String)result);
            } else {
                return null;
            }
        }
        result = url.openConnection();
        ((URLConnection)result).connect();
        return url;
    }

    private static Bundle[] getCurrentBundles(boolean includeInitial) {
        Bundle[] installed = Activator.getBundleContext().getBundles();
        ArrayList<Bundle> initial = new ArrayList<Bundle>();
        for (int i = 0; i < installed.length; ++i) {
            Bundle bundle = installed[i];
            if (bundle.getLocation().startsWith(INITIAL_LOCATION)) {
                if (!includeInitial) continue;
                initial.add(bundle);
                continue;
            }
            if (includeInitial || bundle.getBundleId() == 0L) continue;
            initial.add(bundle);
        }
        return initial.toArray(new Bundle[initial.size()]);
    }

    private static void installBundles(BundleDescription[] initialBundles, Bundle[] curInitBundles, List<Bundle> startBundles, List<Bundle> lazyActivationBundles, List<Bundle> toRefresh) {
        ServiceReference reference = Activator.getBundleContext().getServiceReference(StartLevel.class.getName());
        StartLevel startService = null;
        if (null != reference) {
            startService = (StartLevel)Activator.getBundleContext().getService(reference);
        }
        for (int i = 0; i < initialBundles.length; ++i) {
            Bundle osgiBundle = AppOperator.getBundleByLocation(initialBundles[i].locationString, curInitBundles);
            try {
                if (null == osgiBundle) {
                    InputStream in = initialBundles[i].location.openStream();
                    osgiBundle = Activator.getBundleContext().installBundle(initialBundles[i].locationString, in);
                    if (!initialBundles[i].start && AppOperator.hasLazyActivationPolicy(osgiBundle)) {
                        lazyActivationBundles.add(osgiBundle);
                    }
                }
                if ((osgiBundle.getState() & 1) == 0 && initialBundles[i].level >= 0 && null != startService) {
                    startService.setBundleStartLevel(osgiBundle, initialBundles[i].level);
                }
                if (initialBundles[i].start) {
                    startBundles.add(osgiBundle);
                }
                if ((osgiBundle.getState() & 2) == 0) continue;
                toRefresh.add(osgiBundle);
                continue;
            }
            catch (Exception e) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_INSTALL, (Object)initialBundles[i].location), 0, (Throwable)e, null);
                Activator.getFrameworkLog().log(entry);
            }
        }
        if (null != reference) {
            Activator.getBundleContext().ungetService(reference);
        }
    }

    private static boolean refreshPackages(Bundle[] bundles) {
        if (null == bundles) {
            return false;
        }
        ServiceReference packageAdminRef = Activator.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (null == packageAdminRef) {
            return false;
        }
        PackageAdmin packageAdmin = null;
        packageAdmin = (PackageAdmin)Activator.getBundleContext().getService(packageAdminRef);
        if (null == packageAdmin) {
            return false;
        }
        final Semaphore semaphore = new Semaphore(0);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (4 == event.getType()) {
                    semaphore.release();
                }
            }
        };
        Activator.getBundleContext().addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        Activator.getBundleContext().ungetService(packageAdminRef);
        AppOperator.updateSplash(semaphore, listener);
        if (AppOperator.isForcedRestart()) {
            Bundle systemBundle = Activator.getBundleContext().getBundle(0L);
            for (int i = 0; i < 5000 && (systemBundle.getState() & 0x30) != 0; i += 200) {
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private static void startBundles(Bundle[] startBundles, Bundle[] lazyBundles) {
        int i;
        for (i = 0; i < startBundles.length; ++i) {
            AppOperator.startBundle(startBundles[i], 0);
        }
        for (i = 0; i < lazyBundles.length; ++i) {
            AppOperator.startBundle(lazyBundles[i], 2);
        }
    }

    private static void startBundle(Bundle bundle, int options) {
        block2: {
            try {
                bundle.start(options);
            }
            catch (BundleException e) {
                if ((bundle.getState() & 4) == 0) break block2;
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_START, (Object)bundle.getLocation()), 0, (Throwable)e, null);
                Activator.getFrameworkLog().log(entry);
            }
        }
    }

    private static URL makeRelative(String appPath, URL location) throws MalformedURLException, IOException {
        String pluginDir = new File(appPath + File.separator + PLUGINS_DIR).getCanonicalPath();
        URL base = new File(pluginDir).toURI().toURL();
        if (!"file".equals(base.getProtocol())) {
            return location;
        }
        if (!location.getProtocol().equals(REFERENCE_PROTOCOL)) {
            return location;
        }
        URL nonReferenceLocation = new URL(location.getPath());
        if (!base.getProtocol().equals(nonReferenceLocation.getProtocol())) {
            return location;
        }
        File locationPath = new File(nonReferenceLocation.getPath());
        if (!locationPath.isAbsolute()) {
            return location;
        }
        File relativePath = AppOperator.makeRelative(new File(base.getPath()), locationPath);
        String urlPath = relativePath.getPath();
        if (File.separatorChar != '/') {
            urlPath = urlPath.replace(File.separatorChar, '/');
        }
        if (nonReferenceLocation.getPath().endsWith("/")) {
            StringBuffer str = new StringBuffer();
            str.append(urlPath);
            str.append('/');
            urlPath = str.toString();
        }
        URL relativeURL = new URL(base.getProtocol(), base.getHost(), base.getPort(), urlPath);
        relativeURL = new URL(REFERENCE_SCHEME + relativeURL.toExternalForm());
        return relativeURL;
    }

    private static Bundle getBundleByLocation(String location, Bundle[] bundles) {
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (!location.equalsIgnoreCase(bundle.getLocation())) continue;
            return bundle;
        }
        return null;
    }

    private static boolean hasLazyActivationPolicy(Bundle target) {
        Dictionary headers = target.getHeaders("");
        String fragmentHost = (String)headers.get("Fragment-Host");
        if (null != fragmentHost) {
            return false;
        }
        String activationPolicy = (String)headers.get("Bundle-ActivationPolicy");
        try {
            if (null != activationPolicy) {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ActivationPolicy", (String)activationPolicy);
                if (elements != null && elements.length > 0 && "lazy".equals(elements[0].getValue())) {
                    return true;
                }
            } else {
                ManifestElement[] elements;
                String eclipseLazyStart = (String)headers.get("Eclipse-LazyStart");
                if (null == eclipseLazyStart) {
                    eclipseLazyStart = (String)headers.get("Eclipse-AutoStart");
                }
                if ((elements = ManifestElement.parseHeader((String)"Eclipse-LazyStart", (String)eclipseLazyStart)) != null && elements.length > 0) {
                    if ("true".equals(elements[0].getValue())) {
                        return true;
                    }
                    if (null != elements[0].getDirective("exceptions")) {
                        return true;
                    }
                }
            }
        }
        catch (BundleException be) {
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "", 0, (Throwable)be, null);
            Activator.getFrameworkLog().log(entry);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSplash(Semaphore semaphore, FrameworkListener listener) {
        ServiceTracker monitorTracker = new ServiceTracker(Activator.getBundleContext(), StartupMonitor.class.getName(), null);
        monitorTracker.open();
        try {
            do {
                StartupMonitor monitor;
                if (null == (monitor = (StartupMonitor)monitorTracker.getService())) continue;
                monitor.update();
            } while (!semaphore.acquire(50L));
        }
        finally {
            if (null != listener) {
                Activator.getBundleContext().removeFrameworkListener(listener);
            }
            monitorTracker.close();
        }
    }

    private static boolean isForcedRestart() {
        return Boolean.valueOf(FrameworkProperties.getProperty((String)PROP_FORCED_RESTART));
    }

    private static String searchFor(String target, String start) {
        String[] candidates = searchCandidates.get(start);
        if (null == candidates && null != (candidates = new File(start).list())) {
            searchCandidates.put(start, candidates);
        }
        if (null == candidates) {
            return null;
        }
        String result = null;
        Object[] maxVersion = null;
        for (int i = 0; i < candidates.length; ++i) {
            String candidateName = candidates[i];
            if (!candidateName.startsWith(target)) continue;
            boolean simpleJar = AppOperator.isSimpleJar(target, candidateName);
            String version = candidateName.length() > target.length() + 1 && candidateName.charAt(target.length()) == '_' ? candidateName.substring(target.length() + 1) : "";
            Object[] currentVersion = AppOperator.getVersionElements(version);
            if (null == currentVersion || AppOperator.compareVersion(maxVersion, currentVersion) >= 0) continue;
            File candidate = new File(start, candidateName);
            if (!simpleJar && !candidate.isDirectory()) continue;
            result = candidate.getAbsolutePath();
            maxVersion = currentVersion;
        }
        if (null == result) {
            return null;
        }
        return result.replace(File.separatorChar, '/') + "/";
    }

    private static boolean isSimpleJar(String target, String candidateName) {
        boolean simpleJar = false;
        if (candidateName.length() > target.length() && candidateName.endsWith(".jar")) {
            simpleJar = true;
        }
        return simpleJar;
    }

    private static File makeRelative(File base, File location) {
        if (!location.isAbsolute()) {
            return location;
        }
        File relative = new File(new FilePath(base).makeRelative(new FilePath(location)));
        return relative;
    }

    private static Object[] getVersionElements(String version) {
        Object[] result = new Object[]{-1, -1, -1, ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        for (int i = 0; t.hasMoreTokens() && i < 4; ++i) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i] = Integer.valueOf(token);
                    continue;
                }
                catch (Exception e) {
                    if (0 != i) break;
                    return null;
                }
            }
            result[i] = token;
        }
        return result;
    }

    private static int compareVersion(Object[] left, Object[] right) {
        if (null == left) {
            return -1;
        }
        int indexQualifier = 3;
        int count = 3;
        int result = 0;
        for (int i = 0; i < count; ++i) {
            result = ((Integer)left[i]).compareTo((Integer)right[i]);
            if (0 == result) continue;
            return result;
        }
        return ((String)left[indexQualifier]).compareTo((String)right[indexQualifier]);
    }

    @Override
    public Bundle[] installBundle(AppEntity app, String[] installEntries) {
        Bundle[] loadedBundles = null;
        try {
            loadedBundles = this.loadBundles(app, installEntries);
        }
        catch (Exception ex) {
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "installBundle failed", 0, (Throwable)ex, null);
            Activator.getFrameworkLog().log(entry);
        }
        return loadedBundles;
    }

    @Override
    public boolean uninstallBundle(AppEntity app, Bundle[] bundles) {
        String[] bundleLocations = app.getBundleLocations();
        Bundle[] allBundles = app.getBundles();
        if (null == bundles || 0 == bundles.length || null == allBundles) {
            return false;
        }
        ArrayList<Bundle> allBundleLst = new ArrayList<Bundle>(Arrays.asList(allBundles));
        ArrayList<String> bundleLocationLst = new ArrayList<String>(Arrays.asList(bundleLocations));
        int index = 0;
        for (Bundle bundle : bundles) {
            index = allBundleLst.indexOf(bundle);
            if (index < 0) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "The Application not contains the bundle,uninstall bundle failed,the bundle is :" + bundle.getLocation(), 0, null, null);
                Activator.getFrameworkLog().log(entry);
                return false;
            }
            try {
                if (32 == bundle.getState() || 4 == bundle.getState() || 8 == bundle.getState()) {
                    bundle.stop();
                }
                if (1 != bundle.getState()) {
                    bundle.uninstall();
                }
                allBundleLst.remove(index);
                bundleLocationLst.remove(bundle.getLocation());
            }
            catch (BundleException ex) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "uninstall bundle failed", 0, (Throwable)ex, null);
                Activator.getFrameworkLog().log(entry);
            }
        }
        app.setBundles(allBundleLst.toArray(new Bundle[allBundleLst.size()]));
        app.setBundleLocations(bundleLocationLst.toArray(new String[bundleLocationLst.size()]));
        return true;
    }

    private static class BundleDescription {
        public final String locationString;
        public final URL location;
        public final int level;
        public final boolean start;

        BundleDescription(String locationString, URL location, int level, boolean start) {
            this.locationString = locationString;
            this.location = location;
            this.level = level;
            this.start = start;
        }
    }
}

