/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.appmanager.impl.runtime;

import com.huawei.uflight.appmanager.Activator;
import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.appmanager.api.IntegratedAppEntity;
import com.huawei.uflight.appmanager.impl.runtime.AppOperator;
import com.huawei.uflight.appmanager.internal.IAppOperator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

final class AppEntityFactory {
    static final String APP_PROP = "AppProperties";
    static final String DB_NAME = "dbName";
    static final String APP_NAME = "AppName";
    static final String APP_PATH = "AppPath";
    static final String START_LEVEL = "StartLevel";
    static final String IS_AUTO_START = "IsAutoStart";
    static final String PROC_ID = "ProcID";
    static final String PROC_HANDLE = "ProcHandle";
    static final String CAN_STOP = "CanStop";

    private AppEntityFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AppEntity createAppEntity(File appConfig, DeploymentMode deployMode, String workingDir) {
        FrameworkLogEntry entry;
        Properties cfgProp = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(appConfig);
            cfgProp.load(in);
        }
        catch (IOException ex) {
            entry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, "load properties from cfg file failed, cfgFile is:" + appConfig.getAbsolutePath(), 0, (Throwable)ex, null);
            Activator.getFrameworkLog().log(entry);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    entry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, "close input stream failed, cfgFile is:" + appConfig.getAbsolutePath(), 0, (Throwable)ex, null);
                    Activator.getFrameworkLog().log(entry);
                }
            }
        }
        return AppEntityFactory.createAppEntity(cfgProp, deployMode, workingDir);
    }

    private static void setSystemProp(String appName, Properties prop) {
        if (appName.equals("CORE_APP") || appName.equals("FRAME_APP") || appName.equals("WEB_APP")) {
            return;
        }
        System.getProperties().put(APP_PROP, prop);
        if (prop.get(DB_NAME) != null) {
            System.getProperties().put(DB_NAME, prop.get(DB_NAME));
        }
    }

    private static String getAbsoluteAppPath(String relativePath, DeploymentMode deployMode, String workingDir, String appName) {
        File dir = new File(relativePath);
        String absolutePath = null;
        absolutePath = dir.isAbsolute() ? relativePath : (DeploymentMode.independent == deployMode ? ("".equalsIgnoreCase(relativePath) ? workingDir : workingDir + File.separator + relativePath) : ("CORE_APP".equalsIgnoreCase(appName) || "WEB_APP".equalsIgnoreCase(appName) || "FRAME_APP".equalsIgnoreCase(appName) ? ("".equalsIgnoreCase(relativePath) ? workingDir : workingDir + File.separator + relativePath) : System.getenv("IMAP_ROOT") + File.separator + relativePath));
        FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 1, 0, "create app, name is " + appName + " path is " + absolutePath, 0, null, null);
        Activator.getFrameworkLog().log(entry);
        File appDir = new File(absolutePath);
        if (!appDir.exists() || !appDir.isDirectory()) {
            throw new IllegalArgumentException("relativePath is not exist or is not a directory:" + absolutePath);
        }
        return absolutePath;
    }

    static AppEntity createAppEntity(Properties appConfig, DeploymentMode deployMode, String workingDir) {
        String appName = appConfig.getProperty(APP_NAME);
        String appPath = appConfig.getProperty(APP_PATH);
        if (null == appName || null == appPath) {
            throw new IllegalArgumentException("appName is null or appPath is null");
        }
        AppEntityFactory.setSystemProp(appName, appConfig);
        appPath = AppEntityFactory.getAbsoluteAppPath(appPath, deployMode, workingDir, appName);
        String startLevelStr = appConfig.getProperty(START_LEVEL);
        String isAutoStartStr = appConfig.getProperty(IS_AUTO_START);
        boolean isAutoStart = null == isAutoStartStr ? true : Boolean.valueOf(isAutoStartStr);
        int startLevel = null == startLevelStr ? 4 : Integer.parseInt(startLevelStr);
        String canStopStr = appConfig.getProperty(CAN_STOP);
        boolean canStop = null == canStopStr ? true : Boolean.valueOf(canStopStr);
        AppEntity app = null;
        if (DeploymentMode.independent == deployMode) {
            app = new AppEntity(appName, appPath, isAutoStart, startLevel, AppEntityFactory.createOperator());
        } else {
            IntegratedAppEntity iapp = new IntegratedAppEntity(appName, appPath, isAutoStart, startLevel, AppEntityFactory.createOperator());
            try {
                int procID = Integer.parseInt(appConfig.getProperty(PROC_ID));
                int procHandle = Integer.parseInt(appConfig.getProperty(PROC_HANDLE));
                iapp.setProcID(procID);
                iapp.setProcHandle(procHandle);
            }
            catch (Exception e) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, "The app config processInfo error, appName= " + appName, 0, null, null);
                Activator.getFrameworkLog().log(entry);
            }
            app = iapp;
        }
        app.setCanStop(canStop);
        app.setAppPropertis(appConfig);
        return app;
    }

    static AppEntity createUndeployedAppEntity(String appName, DeploymentMode deployMode) {
        AppEntity app = DeploymentMode.integrated == deployMode ? new IntegratedAppEntity(appName, null, false, 4, AppEntityFactory.createOperator()) : new AppEntity(appName, null, false, 4, AppEntityFactory.createOperator());
        app.undeploy();
        app.setCanStop(false);
        return app;
    }

    private static IAppOperator createOperator() {
        return new AppOperator();
    }
}

