/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.appmanager.impl.debug;

import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.appmanager.api.IntegratedAppEntity;
import com.huawei.uflight.appmanager.impl.AbstractAppManager;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;

public class DebugAppManager
extends AbstractAppManager {
    private static final String APP_NAME = "AppName";
    private static final String PROC_ID = "ProcID";
    private static final String PROC_HANDLE = "ProcHandle";
    private static final int FRAME_PROC_ID = 4005;
    private static final int FRAME_PROC_HANDLE = 1;
    private AppEntity coreApp = this.createApp("CORE_APP");
    private AppEntity webApp = this.createApp("WEB_APP");
    private AppEntity frameApp = this.createApp("FRAME_APP");
    private AppEntity serviceApp = this.createApp(System.getProperty("AppName"));

    @Override
    public void init() {
        FrameworkUtil.getBundle(DebugAppManager.class).getBundleContext().addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkevent) {
                if (frameworkevent.getType() == 1) {
                    DebugAppManager.this.startApp("CORE_APP");
                    DebugAppManager.this.startApp("WEB_APP");
                    DebugAppManager.this.startApp("FRAME_APP");
                    DebugAppManager.this.startApp(System.getProperty(DebugAppManager.APP_NAME));
                }
            }
        });
    }

    private AppEntity createApp(String appName) {
        AppEntity app;
        if (DeploymentMode.independent == this.getDeploymentMode()) {
            app = new AppEntity(appName, this.getWorkingDir(), true, 4, null);
        } else {
            IntegratedAppEntity iapp = new IntegratedAppEntity(appName, this.getWorkingDir(), true, 4, null);
            this.setProcInfo(iapp);
            app = iapp;
        }
        app.setAppPropertis(System.getProperties());
        return app;
    }

    private void setProcInfo(IntegratedAppEntity app) {
        if ("FRAME_APP".equalsIgnoreCase(app.getAppName())) {
            app.setProcID(4005);
            app.setProcHandle(1);
        } else {
            String procHandle;
            String procID = System.getProperty(PROC_ID);
            if (null != procID) {
                app.setProcID(Integer.parseInt(procID));
            }
            if (null != (procHandle = System.getProperty(PROC_HANDLE))) {
                app.setProcHandle(Integer.parseInt(procHandle));
            }
        }
    }

    @Override
    public AppEntity getAppByBundle(Bundle bundle) {
        return this.serviceApp;
    }

    @Override
    public AppEntity getAppByName(String appName) {
        if ("CORE_APP".equalsIgnoreCase(appName)) {
            return this.coreApp;
        }
        if ("WEB_APP".equalsIgnoreCase(appName)) {
            return this.webApp;
        }
        if ("FRAME_APP".equalsIgnoreCase(appName)) {
            return this.frameApp;
        }
        return this.serviceApp;
    }

    @Override
    public boolean startApp(String appName) {
        AppEntity app = this.getAppByName(appName);
        this.notifyPreStateChgListeners(app, app.getState(), AppEntity.AppState.started);
        app.start();
        this.notifyPostStateChgListeners(app, app.getState(), AppEntity.AppState.started);
        return true;
    }

    @Override
    public boolean stopApp(String appName) {
        AppEntity app = this.getAppByName(appName);
        this.notifyPreStateChgListeners(app, app.getState(), AppEntity.AppState.stoped);
        app.start();
        this.notifyPostStateChgListeners(app, app.getState(), AppEntity.AppState.stoped);
        return true;
    }

    @Override
    public List<AppEntity> getAllApps() {
        ArrayList<AppEntity> apps = new ArrayList<AppEntity>();
        apps.add(this.coreApp);
        apps.add(this.frameApp);
        apps.add(this.webApp);
        apps.add(this.serviceApp);
        return apps;
    }
}

