/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.appmanager.impl;

import com.huawei.uflight.appmanager.Activator;
import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.appmanager.api.IAppManager;
import com.huawei.uflight.appmanager.api.IAppStateChanageListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public abstract class AbstractAppManager
implements IAppManager {
    private static final String DEPLOYMENT_MODE = "deploymentMode";
    private List<IAppStateChanageListener> appStateListeners = new ArrayList<IAppStateChanageListener>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void init() {
    }

    protected String getWorkingDir() {
        return System.getProperty("user.dir");
    }

    @Override
    public AppEntity.AppState getAppState(String appName) {
        return this.getAppByName(appName).getState();
    }

    @Override
    public DeploymentMode getDeploymentMode() {
        String deployModeProp = System.getProperty(DEPLOYMENT_MODE);
        boolean isIntegratedDeployment = null == deployModeProp ? false : DeploymentMode.integrated.toString().equalsIgnoreCase(deployModeProp.trim());
        return isIntegratedDeployment ? DeploymentMode.integrated : DeploymentMode.independent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppStateChangeListener(IAppStateChanageListener listener, String ... appName) {
        this.lock.writeLock().lock();
        try {
            this.appStateListeners.add(new AppStateChangeListenerProxy(listener, appName));
        }
        catch (Exception e) {
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, "exception occured when addAppStateChangeListener", 0, (Throwable)e, null);
            Activator.getFrameworkLog().log(entry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAppStateChangeListener(IAppStateChanageListener listener, String ... appName) {
        this.lock.writeLock().lock();
        try {
            Iterator<IAppStateChanageListener> iter = this.appStateListeners.iterator();
            while (iter.hasNext()) {
                AppStateChangeListenerProxy proxy = (AppStateChangeListenerProxy)iter.next();
                if (!proxy.isSame(listener, appName)) continue;
                iter.remove();
            }
        }
        catch (Exception e) {
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, "exception occured when removeAppStateChangeListener", 0, (Throwable)e, null);
            Activator.getFrameworkLog().log(entry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void notifyPreStateChgListeners(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
        this.lock.readLock().lock();
        for (IAppStateChanageListener listener : this.appStateListeners) {
            try {
                listener.preStateChanged(app, oldState, newState);
            }
            catch (Exception ex) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, "exception occured when notify app state change", 0, (Throwable)ex, null);
                Activator.getFrameworkLog().log(entry);
            }
        }
        this.lock.readLock().unlock();
    }

    protected void notifyPostStateChgListeners(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
        this.lock.readLock().lock();
        for (IAppStateChanageListener listener : this.appStateListeners) {
            try {
                listener.postStateChanged(app, oldState, newState);
            }
            catch (Exception ex) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, "exception occured when notify app state change", 0, (Throwable)ex, null);
                Activator.getFrameworkLog().log(entry);
            }
        }
        this.lock.readLock().unlock();
    }

    @Override
    public boolean isDebugMode() {
        return Boolean.valueOf(System.getProperty("debug"));
    }

    private class AppStateChangeListenerProxy
    implements IAppStateChanageListener {
        private IAppStateChanageListener listener;
        private String appName;

        public AppStateChangeListenerProxy(IAppStateChanageListener listener, String ... appName) {
            if (null == listener) {
                throw new IllegalArgumentException("listener is null");
            }
            this.listener = listener;
            if (0 != appName.length) {
                this.appName = appName[0];
            }
        }

        @Override
        public void preStateChanged(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
            if (null == this.appName || this.appName.equalsIgnoreCase(app.getAppName())) {
                this.listener.preStateChanged(app, oldState, newState);
            }
        }

        @Override
        public void postStateChanged(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
            if (null == this.appName || this.appName.equalsIgnoreCase(app.getAppName())) {
                this.listener.postStateChanged(app, oldState, newState);
            }
        }

        public boolean isSame(IAppStateChanageListener listener, String ... appName) {
            boolean isSame;
            boolean bl = isSame = this.listener == listener;
            if (0 == appName.length) {
                return isSame;
            }
            return isSame && appName[0].equalsIgnoreCase(this.appName);
        }
    }
}

