/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.appmanager.console;

import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.api.IAppManager;
import java.util.List;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class ConsoleExtend
implements CommandProvider {
    private static String helpInfo;
    private static final String START_COMMAND = "-start";
    private static final String STOP_COMMAND = "-stop";
    private static final String STAT_COMMAND = "-state";
    private static final String LIST_COMMAND = "-list";
    private IAppManager appManager;

    public ConsoleExtend(IAppManager appManager) {
        this.appManager = appManager;
    }

    public String getHelp() {
        return helpInfo;
    }

    public void _appmgr(CommandInterpreter interpreter) {
        String command = interpreter.nextArgument();
        String appName = interpreter.nextArgument();
        if (null == command) {
            this.printError(interpreter);
            return;
        }
        if (LIST_COMMAND.equalsIgnoreCase(command = command.trim())) {
            this.listApps(interpreter);
            return;
        }
        if (null == appName) {
            this.printError(interpreter);
            return;
        }
        appName = appName.trim();
        if (START_COMMAND.equalsIgnoreCase(command)) {
            boolean result = this.appManager.startApp(appName);
            this.printOperationResult("Start", appName, result, interpreter);
        } else if (STOP_COMMAND.equalsIgnoreCase(command)) {
            boolean result = this.appManager.stopApp(appName);
            this.printOperationResult("Stop", appName, result, interpreter);
        } else if (STAT_COMMAND.equalsIgnoreCase(command)) {
            String state = this.appManager.getAppState(appName).toString();
            interpreter.println((Object)("The specified app's state is: " + state));
        } else {
            this.printError(interpreter);
        }
    }

    private void listApps(CommandInterpreter interpreter) {
        List<AppEntity> apps = this.appManager.getAllApps();
        interpreter.println((Object)"AppName            AppPath                  StartLevel   ProcID  ProcHandle");
        for (AppEntity app : apps) {
            interpreter.println((Object)app);
        }
    }

    private void printOperationResult(String operationName, String appName, boolean result, CommandInterpreter interpreter) {
        String resultStr = result ? " succeed." : " failed.";
        interpreter.println((Object)(operationName + " " + appName + resultStr));
    }

    private void printError(CommandInterpreter interpreter) {
        interpreter.println((Object)"Command param error.");
        interpreter.println((Object)this.getHelp());
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("---------------------------------App mananger Runtime---------------------------------");
        sb.append("\t\n");
        sb.append("\tUsed to manage app, command' format:");
        sb.append("\t\n");
        sb.append("\t\t appmgr -list \t\n");
        sb.append("\t\t appmgr -start|-stop|-state appname");
        sb.append("\t\n");
        sb.append("\tOptions:");
        sb.append("\t\n");
        sb.append("\t\t -list                  List all app in this process");
        sb.append("\t\n");
        sb.append("\t\t -start                 Start the specified app");
        sb.append("\t\n");
        sb.append("\t\t -stop                  Stop the specified app");
        sb.append("\t\n");
        sb.append("\t\t -state                  Show the specified app's state. App has the following status: started,stoped,uninstalled");
        sb.append("\t\n");
        sb.append("\t\t appname                App's name");
        sb.append("\t\n");
        sb.append("--------------------------------App mananger Runtime end-------------------------------");
        sb.append("\t\n");
        helpInfo = sb.toString();
    }
}

