/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.appmanager.api;

import com.huawei.uflight.appmanager.internal.IAppOperator;
import java.util.Properties;
import org.osgi.framework.Bundle;

public class AppEntity {
    public static final int INVALIDATE_VALUE = -1;
    public static final String UFLIGHT_CORE_APP_NAME = "CORE_APP";
    public static final String UFLIGHT_WEB_APP_NAME = "WEB_APP";
    public static final String UFLIGHT_FRAME_APP_NAME = "FRAME_APP";
    public static final int DEFAULT_START_LEVEL = 4;
    private String appName;
    private String appPath;
    private boolean bAutoStart = true;
    private int startLevel = 4;
    private AppState state = AppState.stoped;
    private IAppOperator operator;
    private boolean bCanStop = true;
    private Bundle[] bundles;
    private String[] bundleLocations;
    private Properties appConfig;
    private int procID = -1;
    private int procHandle = -1;

    public AppEntity(String appName, String appPath, boolean isAutoStart, int startLevel, IAppOperator operator) {
        this.appName = appName;
        this.appPath = appPath;
        this.bAutoStart = isAutoStart;
        this.startLevel = startLevel;
        this.operator = operator;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public AppState getState() {
        return this.state;
    }

    public boolean isAutoStart() {
        return this.bAutoStart;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public boolean canStop() {
        return this.bCanStop;
    }

    public void setCanStop(boolean canStop) {
        this.bCanStop = canStop;
    }

    public Bundle[] getBundles() {
        return this.bundles;
    }

    public void setBundles(Bundle[] bundles) {
        this.bundles = bundles;
    }

    public boolean start() {
        boolean result = true;
        if (null != this.operator) {
            result = this.operator.startApp(this);
        }
        if (result) {
            this.state = AppState.started;
        }
        return result;
    }

    public boolean stop() {
        boolean result = true;
        if (null != this.operator) {
            result = this.operator.stopApp(this);
        }
        if (result) {
            this.state = AppState.stoped;
        }
        return result;
    }

    public boolean undeploy() {
        boolean result = true;
        if (null != this.operator) {
            result = this.operator.undeployApp(this);
        }
        if (result) {
            this.state = AppState.undeployed;
        }
        return result;
    }

    public int getProcID() {
        return this.procID;
    }

    public void setProcID(int procID) {
        this.procID = procID;
    }

    public int getProcHandle() {
        return this.procHandle;
    }

    public void setProcHandle(int procHandle) {
        this.procHandle = procHandle;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appName == null ? 0 : this.appName.hashCode());
        result = 31 * result + this.procHandle;
        result = 31 * result + this.procID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppEntity other = (AppEntity)obj;
        if (this.appName == null ? other.appName != null : !this.appName.equals(other.appName)) {
            return false;
        }
        return this.procHandle == other.procHandle && this.procID == other.procID;
    }

    public String toString() {
        return this.getAppName() + "\t" + this.getAppPath() + "\t" + this.getStartLevel() + "\t" + this.getProcID() + "\t" + this.getProcHandle();
    }

    public String[] getBundleLocations() {
        return this.bundleLocations;
    }

    public void setBundleLocations(String[] bundleLocations) {
        this.bundleLocations = bundleLocations;
    }

    public void setAppPropertis(Properties appConfig) {
        this.appConfig = appConfig;
    }

    public String getAppParam(String key, String ... defaultValue) {
        String value = null;
        if (defaultValue.length > 0) {
            value = defaultValue[0];
        }
        if (null == this.appConfig) {
            return value;
        }
        return this.appConfig.getProperty(key, value);
    }

    public Bundle[] installBundle(String[] installEntries) {
        if (null == this.operator) {
            return new Bundle[0];
        }
        return this.operator.installBundle(this, installEntries);
    }

    public boolean uninstallBundle(Bundle[] bundles) {
        if (null == this.operator) {
            return false;
        }
        return this.operator.uninstallBundle(this, bundles);
    }

    public static enum AppState {
        started,
        stoped,
        undeployed;

    }
}

