/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.appmanager;

import com.huawei.uflight.appmanager.api.IAppManager;
import com.huawei.uflight.appmanager.console.ConsoleExtend;
import com.huawei.uflight.appmanager.impl.AbstractAppManager;
import com.huawei.uflight.appmanager.impl.debug.DebugAppManager;
import com.huawei.uflight.appmanager.impl.runtime.RuntimeAppManager;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public static final String DEBUG_MODE = "debug";
    private static BundleContext context;
    private AbstractAppManager appManager;
    private ConsoleExtend consoleExtend;
    private static FrameworkLog log;
    private static final String DEFAULT_ADAPTOR_CLASS = "org.eclipse.osgi.baseadaptor.BaseAdaptor";

    public void start(BundleContext context) {
        Activator.context = context;
        Activator.initFrameworkLog();
        this.registerAppManagerService();
        this.registerConsoleExtendService();
        this.init();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "exception, thread=" + t, 0, e, null);
                Activator.getFrameworkLog().log(entry);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 1, 0, "JVM Will Exit.", 0, null, null);
                Activator.getFrameworkLog().log(entry);
                try {
                    EclipseStarter.shutdown();
                }
                catch (Exception e) {
                    entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, "Eclipse shutdown error.", 0, (Throwable)e, null);
                    Activator.getFrameworkLog().log(entry);
                }
            }
        });
    }

    private void init() {
        this.appManager.init();
    }

    private void registerAppManagerService() {
        boolean isDebugMode = Boolean.valueOf(System.getProperty(DEBUG_MODE));
        this.appManager = isDebugMode ? new DebugAppManager() : new RuntimeAppManager();
        Hashtable properties = new Hashtable();
        context.registerService(IAppManager.class.getName(), (Object)this.appManager, properties);
    }

    private void registerConsoleExtendService() {
        this.consoleExtend = new ConsoleExtend(this.appManager);
        Hashtable properties = new Hashtable();
        context.registerService(CommandProvider.class.getName(), (Object)this.consoleExtend, properties);
    }

    private static void initFrameworkLog() {
        String adaptorClassName = FrameworkProperties.getProperty((String)"osgi.adaptor", (String)DEFAULT_ADAPTOR_CLASS);
        try {
            Class<?> adaptorClass = Class.forName(adaptorClassName);
            Class[] constructorArgs = new Class[]{String[].class};
            Constructor<?> constructor = adaptorClass.getConstructor(constructorArgs);
            FrameworkAdaptor adaptor = (FrameworkAdaptor)constructor.newInstance(new Object[]{new String[0]});
            log = adaptor.getFrameworkLog();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static FrameworkLog getFrameworkLog() {
        return log;
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public void stop(BundleContext context) {
    }
}

