/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.gif;

import com.sun.imageio.plugins.common.ReaderUtil;
import com.sun.imageio.plugins.gif.GIFImageMetadata;
import com.sun.imageio.plugins.gif.GIFStreamMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class GIFImageReader
extends ImageReader {
    ImageInputStream stream = null;
    boolean gotHeader = false;
    GIFStreamMetadata streamMetadata = null;
    int currIndex = -1;
    GIFImageMetadata imageMetadata = null;
    List imageStartPosition = new ArrayList();
    int imageMetadataLength;
    int numImages = -1;
    byte[] block = new byte[255];
    int blockLength = 0;
    int bitPos = 0;
    int nextByte = 0;
    int initCodeSize;
    int clearCode;
    int eofCode;
    int next32Bits = 0;
    boolean lastBlockFound = false;
    BufferedImage theImage = null;
    WritableRaster theTile = null;
    int width = -1;
    int height = -1;
    int streamX = -1;
    int streamY = -1;
    int rowsDone = 0;
    int interlacePass = 0;
    static final int[] interlaceIncrement = new int[]{8, 8, 4, 2, -1};
    static final int[] interlaceOffset = new int[]{0, 4, 2, 1, -1};
    Rectangle sourceRegion;
    int sourceXSubsampling;
    int sourceYSubsampling;
    int sourceMinProgressivePass;
    int sourceMaxProgressivePass;
    Point destinationOffset;
    Rectangle destinationRegion;
    int updateMinY;
    int updateYStep;
    boolean decodeThisRow = true;
    int destY = 0;
    byte[] rowBuf;

    public GIFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object != null) {
            if (!(object instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)object;
        } else {
            this.stream = null;
        }
        this.resetStreamSettings();
    }

    public int getNumImages(boolean bl) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.seekForwardOnly && bl) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        if (this.numImages > 0) {
            return this.numImages;
        }
        if (bl) {
            this.numImages = this.locateImage(Integer.MAX_VALUE) + 1;
        }
        return this.numImages;
    }

    private void checkIndex(int n) {
        if (n < this.minIndex) {
            throw new IndexOutOfBoundsException("imageIndex < minIndex!");
        }
        if (this.seekForwardOnly) {
            this.minIndex = n;
        }
    }

    public int getWidth(int n) throws IIOException {
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageWidth;
    }

    public int getHeight(int n) throws IIOException {
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageHeight;
    }

    public Iterator getImageTypes(int n) throws IIOException {
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        byte[] byArray = this.imageMetadata.localColorTable != null ? this.imageMetadata.localColorTable : this.streamMetadata.globalColorTable;
        int n3 = byArray.length / 3;
        int n4 = n3 == 2 ? 1 : (n3 == 4 ? 2 : (n3 == 8 || n3 == 16 ? 4 : 8));
        int n5 = 1 << n4;
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        byte[] byArray4 = new byte[n5];
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[n6++];
            byArray3[i] = byArray[n6++];
            byArray4[i] = byArray[n6++];
        }
        byte[] byArray5 = null;
        if (this.imageMetadata.transparentColorFlag) {
            byArray5 = new byte[n5];
            Arrays.fill(byArray5, (byte)-1);
            int n7 = Math.min(this.imageMetadata.transparentColorIndex, n5 - 1);
            byArray5[n7] = 0;
        }
        int[] nArray = new int[]{n4};
        arrayList.add(ImageTypeSpecifier.createIndexed(byArray2, byArray3, byArray4, byArray5, n4, 0));
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public IIOMetadata getStreamMetadata() throws IIOException {
        this.readHeader();
        return this.streamMetadata;
    }

    public IIOMetadata getImageMetadata(int n) throws IIOException {
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException("Bad image index!");
        }
        this.readMetadata();
        return this.imageMetadata;
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private int getCode(int n, int n2) throws IOException {
        if (this.bitPos + n > 32) {
            return this.eofCode;
        }
        int n3 = this.next32Bits >> this.bitPos & n2;
        this.bitPos += n;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                int n4;
                this.blockLength = this.stream.readUnsignedByte();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    return n3;
                }
                int n5 = 0;
                for (int i = this.blockLength; i > 0; i -= n4) {
                    n4 = this.stream.read(this.block, n5, i);
                    n5 += n4;
                }
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return n3;
    }

    public void initializeStringTable(int[] nArray, byte[] byArray, byte[] byArray2, int[] nArray2) {
        int n;
        int n2 = 1 << this.initCodeSize;
        for (n = 0; n < n2; ++n) {
            nArray[n] = -1;
            byArray[n] = (byte)n;
            byArray2[n] = (byte)n;
            nArray2[n] = 1;
        }
        for (n = n2; n < 4096; ++n) {
            nArray[n] = -1;
            nArray2[n] = 1;
        }
    }

    private void outputRow() {
        int n = Math.min(this.sourceRegion.width, this.destinationRegion.width * this.sourceXSubsampling);
        int n2 = this.destinationRegion.x;
        if (this.sourceXSubsampling == 1) {
            this.theTile.setDataElements(n2, this.destY, n, 1, this.rowBuf);
        } else {
            int n3 = 0;
            while (n3 < n) {
                this.theTile.setSample(n2, this.destY, 0, this.rowBuf[n3] & 0xFF);
                n3 += this.sourceXSubsampling;
                ++n2;
            }
        }
        if (this.updateListeners != null) {
            int[] nArray = new int[]{0};
            this.processImageUpdate(this.theImage, n2, this.destY, n, 1, 1, this.updateYStep, nArray);
        }
    }

    private void computeDecodeThisRow() {
        this.decodeThisRow = this.destY < this.destinationRegion.y + this.destinationRegion.height && this.streamY >= this.sourceRegion.y && this.streamY < this.sourceRegion.y + this.sourceRegion.height && (this.streamY - this.sourceRegion.y) % this.sourceYSubsampling == 0;
    }

    private void outputPixels(byte[] byArray, int n) {
        if (this.interlacePass < this.sourceMinProgressivePass || this.interlacePass > this.sourceMaxProgressivePass) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (this.streamX >= this.sourceRegion.x) {
                this.rowBuf[this.streamX - this.sourceRegion.x] = byArray[i];
            }
            ++this.streamX;
            if (this.streamX != this.width) continue;
            ++this.rowsDone;
            this.processImageProgress(100.0f * (float)this.rowsDone / (float)this.height);
            if (this.decodeThisRow) {
                this.outputRow();
            }
            this.streamX = 0;
            if (this.imageMetadata.interlaceFlag) {
                this.streamY += interlaceIncrement[this.interlacePass];
                if (this.streamY >= this.height) {
                    if (this.updateListeners != null) {
                        this.processPassComplete(this.theImage);
                    }
                    ++this.interlacePass;
                    if (this.interlacePass > this.sourceMaxProgressivePass) {
                        return;
                    }
                    this.streamY = interlaceOffset[this.interlacePass];
                    this.startPass(this.interlacePass);
                }
            } else {
                ++this.streamY;
            }
            this.destY = this.destinationRegion.y + (this.streamY - this.sourceRegion.y) / this.sourceYSubsampling;
            this.computeDecodeThisRow();
        }
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.streamMetadata = new GIFStreamMetadata();
        try {
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byte[] byArray = new byte[6];
            this.stream.readFully(byArray);
            StringBuffer stringBuffer = new StringBuffer(3);
            stringBuffer.append((char)byArray[3]);
            stringBuffer.append((char)byArray[4]);
            stringBuffer.append((char)byArray[5]);
            this.streamMetadata.version = stringBuffer.toString();
            this.streamMetadata.logicalScreenWidth = this.stream.readUnsignedShort();
            this.streamMetadata.logicalScreenHeight = this.stream.readUnsignedShort();
            int n = this.stream.readUnsignedByte();
            boolean bl = (n & 0x80) != 0;
            this.streamMetadata.colorResolution = (n >> 4 & 7) + 1;
            this.streamMetadata.sortFlag = (n & 8) != 0;
            int n2 = 1 << (n & 7) + 1;
            this.streamMetadata.backgroundColorIndex = this.stream.readUnsignedByte();
            this.streamMetadata.pixelAspectRatio = this.stream.readUnsignedByte();
            if (bl) {
                this.streamMetadata.globalColorTable = new byte[3 * n2];
                this.stream.readFully(this.streamMetadata.globalColorTable);
            } else {
                this.streamMetadata.globalColorTable = null;
            }
            this.imageStartPosition.add(new Long(this.stream.getStreamPosition()));
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading header!", iOException);
        }
        this.gotHeader = true;
    }

    private boolean skipImage() throws IIOException {
        try {
            while (true) {
                int n;
                int n2;
                int n3;
                if ((n3 = this.stream.readUnsignedByte()) == 44) {
                    this.stream.skipBytes(8);
                    n2 = this.stream.readUnsignedByte();
                    if ((n2 & 0x80) != 0) {
                        n = (n2 & 7) + 1;
                        this.stream.skipBytes(3 * (1 << n));
                    }
                    this.stream.skipBytes(1);
                    n = 0;
                    do {
                        n = this.stream.readUnsignedByte();
                        this.stream.skipBytes(n);
                    } while (n > 0);
                    return true;
                }
                if (n3 == 59) {
                    return false;
                }
                if (n3 == 33) {
                    n2 = this.stream.readUnsignedByte();
                    n = 0;
                    do {
                        n = this.stream.readUnsignedByte();
                        this.stream.skipBytes(n);
                    } while (n > 0);
                    continue;
                }
                if (n3 == 0) {
                    return false;
                }
                n2 = 0;
                do {
                    n2 = this.stream.readUnsignedByte();
                    this.stream.skipBytes(n2);
                } while (n2 > 0);
            }
        }
        catch (EOFException eOFException) {
            return false;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error locating image!", iOException);
        }
    }

    private int locateImage(int n) throws IIOException {
        this.readHeader();
        try {
            int n2;
            Long l = (Long)this.imageStartPosition.get(n2);
            this.stream.seek(l);
            for (n2 = Math.min(n, this.imageStartPosition.size() - 1); n2 < n; ++n2) {
                if (!this.skipImage()) {
                    return --n2;
                }
                Long l2 = new Long(this.stream.getStreamPosition());
                this.imageStartPosition.add(l2);
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Couldn't seek!", iOException);
        }
        if (this.currIndex != n) {
            this.imageMetadata = null;
        }
        this.currIndex = n;
        return n;
    }

    private byte[] concatenateBlocks() throws IOException {
        int n;
        byte[] byArray = new byte[]{};
        while ((n = this.stream.readUnsignedByte()) != 0) {
            byte[] byArray2 = new byte[byArray.length + n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.stream.readFully(byArray2, byArray.length, n);
            byArray = byArray2;
        }
        return byArray;
    }

    private void readMetadata() throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        try {
            int n;
            this.imageMetadata = new GIFImageMetadata();
            long l = this.stream.getStreamPosition();
            while (true) {
                int n2;
                if ((n = this.stream.readUnsignedByte()) == 44) {
                    this.imageMetadata.imageLeftPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageTopPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.imageHeight = this.stream.readUnsignedShort();
                    n2 = this.stream.readUnsignedByte();
                    boolean bl = (n2 & 0x80) != 0;
                    this.imageMetadata.interlaceFlag = (n2 & 0x40) != 0;
                    this.imageMetadata.sortFlag = (n2 & 0x20) != 0;
                    int n3 = 1 << (n2 & 7) + 1;
                    if (bl) {
                        this.imageMetadata.localColorTable = new byte[3 * n3];
                        this.stream.readFully(this.imageMetadata.localColorTable);
                    } else {
                        this.imageMetadata.localColorTable = null;
                    }
                    this.imageMetadataLength = (int)(this.stream.getStreamPosition() - l);
                    return;
                }
                if (n != 33) break;
                n2 = this.stream.readUnsignedByte();
                if (n2 == 249) {
                    int n4 = this.stream.readUnsignedByte();
                    int n5 = this.stream.readUnsignedByte();
                    this.imageMetadata.disposalMethod = n5 >> 2 & 3;
                    this.imageMetadata.userInputFlag = (n5 & 2) != 0;
                    this.imageMetadata.transparentColorFlag = (n5 & 1) != 0;
                    this.imageMetadata.delayTime = this.stream.readUnsignedShort();
                    this.imageMetadata.transparentColorIndex = this.stream.readUnsignedByte();
                    int n6 = this.stream.readUnsignedByte();
                    continue;
                }
                if (n2 == 1) {
                    int n7 = this.stream.readUnsignedByte();
                    this.imageMetadata.hasPlainTextExtension = true;
                    this.imageMetadata.textGridLeft = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridTop = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridHeight = this.stream.readUnsignedShort();
                    this.imageMetadata.characterCellWidth = this.stream.readUnsignedByte();
                    this.imageMetadata.characterCellHeight = this.stream.readUnsignedByte();
                    this.imageMetadata.textForegroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.textBackgroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.text = this.concatenateBlocks();
                    continue;
                }
                if (n2 == 254) {
                    byte[] byArray = this.concatenateBlocks();
                    if (this.imageMetadata.comments == null) {
                        this.imageMetadata.comments = new ArrayList();
                    }
                    this.imageMetadata.comments.add(byArray);
                    continue;
                }
                if (n2 == 255) {
                    int n8 = this.stream.readUnsignedByte();
                    byte[] byArray = new byte[8];
                    byte[] byArray2 = new byte[3];
                    byte[] byArray3 = new byte[n8];
                    this.stream.readFully(byArray3);
                    int n9 = this.copyData(byArray3, 0, byArray);
                    n9 = this.copyData(byArray3, n9, byArray2);
                    byte[] byArray4 = this.concatenateBlocks();
                    if (n9 < n8) {
                        int n10 = n8 - n9;
                        byte[] byArray5 = new byte[n10 + byArray4.length];
                        System.arraycopy(byArray3, n9, byArray5, 0, n10);
                        System.arraycopy(byArray4, 0, byArray5, n10, byArray4.length);
                        byArray4 = byArray5;
                    }
                    if (this.imageMetadata.applicationIDs == null) {
                        this.imageMetadata.applicationIDs = new ArrayList();
                        this.imageMetadata.authenticationCodes = new ArrayList();
                        this.imageMetadata.applicationData = new ArrayList();
                    }
                    this.imageMetadata.applicationIDs.add(byArray);
                    this.imageMetadata.authenticationCodes.add(byArray2);
                    this.imageMetadata.applicationData.add(byArray4);
                    continue;
                }
                int n11 = 0;
                do {
                    n11 = this.stream.readUnsignedByte();
                    this.stream.skipBytes(n11);
                } while (n11 > 0);
            }
            if (n == 59) {
                throw new IndexOutOfBoundsException("Attempt to read past end of image sequence!");
            }
            throw new IIOException("Unexpected block type " + n + "!");
        }
        catch (IIOException iIOException) {
            throw iIOException;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading image metadata!", iOException);
        }
    }

    private int copyData(byte[] byArray, int n, byte[] byArray2) {
        int n2 = byArray2.length;
        int n3 = byArray.length - n;
        if (n2 > n3) {
            n2 = n3;
        }
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return n + n2;
    }

    private void startPass(int n) {
        if (this.updateListeners == null) {
            return;
        }
        int n2 = 0;
        int n3 = 1;
        if (this.imageMetadata.interlaceFlag) {
            n2 = interlaceOffset[this.interlacePass];
            n3 = interlaceIncrement[this.interlacePass];
        }
        int[] nArray = ReaderUtil.computeUpdatedPixels(this.sourceRegion, this.destinationOffset, this.destinationRegion.x, this.destinationRegion.y, this.destinationRegion.x + this.destinationRegion.width - 1, this.destinationRegion.y + this.destinationRegion.height - 1, this.sourceXSubsampling, this.sourceYSubsampling, 0, n2, this.destinationRegion.width, (this.destinationRegion.height + n3 - 1) / n3, 1, n3);
        this.updateMinY = nArray[1];
        this.updateYStep = nArray[5];
        int[] nArray2 = new int[]{0};
        this.processPassStarted(this.theImage, this.interlacePass, this.sourceMinProgressivePass, this.sourceMaxProgressivePass, 0, this.updateMinY, 1, this.updateYStep, nArray2);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
        this.clearAbortRequest();
        this.readMetadata();
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        Iterator iterator = this.getImageTypes(n);
        this.theImage = GIFImageReader.getDestination(imageReadParam, iterator, this.imageMetadata.imageWidth, this.imageMetadata.imageHeight);
        this.theTile = this.theImage.getWritableTile(0, 0);
        this.width = this.imageMetadata.imageWidth;
        this.height = this.imageMetadata.imageHeight;
        this.streamX = 0;
        this.streamY = 0;
        this.rowsDone = 0;
        this.interlacePass = 0;
        this.sourceRegion = new Rectangle(0, 0, 0, 0);
        this.destinationRegion = new Rectangle(0, 0, 0, 0);
        GIFImageReader.computeRegions(imageReadParam, this.width, this.height, this.theImage, this.sourceRegion, this.destinationRegion);
        this.destinationOffset = new Point(this.destinationRegion.x, this.destinationRegion.y);
        this.sourceXSubsampling = imageReadParam.getSourceXSubsampling();
        this.sourceYSubsampling = imageReadParam.getSourceYSubsampling();
        this.sourceMinProgressivePass = Math.max(imageReadParam.getSourceMinProgressivePass(), 0);
        this.sourceMaxProgressivePass = Math.min(imageReadParam.getSourceMaxProgressivePass(), 3);
        this.destY = this.destinationRegion.y + (this.streamY - this.sourceRegion.y) / this.sourceYSubsampling;
        this.computeDecodeThisRow();
        this.processImageStarted(n);
        this.startPass(0);
        this.rowBuf = new byte[this.width];
        try {
            int n3;
            this.initCodeSize = this.stream.readUnsignedByte();
            int n4 = this.blockLength = this.stream.readUnsignedByte();
            int n5 = 0;
            while (n4 > 0) {
                n3 = this.stream.read(this.block, n5, n4);
                n4 -= n3;
                n5 += n3;
            }
            this.bitPos = 0;
            this.nextByte = 0;
            this.lastBlockFound = false;
            this.interlacePass = 0;
            this.initNext32Bits();
            this.clearCode = 1 << this.initCodeSize;
            this.eofCode = this.clearCode + 1;
            int n6 = 0;
            int[] nArray = new int[4096];
            byte[] byArray = new byte[4096];
            byte[] byArray2 = new byte[4096];
            int[] nArray2 = new int[4096];
            byte[] byArray3 = new byte[4096];
            this.initializeStringTable(nArray, byArray, byArray2, nArray2);
            int n7 = (1 << this.initCodeSize) + 2;
            int n8 = this.initCodeSize + 1;
            int n9 = (1 << n8) - 1;
            while (!this.abortRequested()) {
                int n10;
                int n11;
                int n12;
                n3 = this.getCode(n8, n9);
                if (n3 == this.clearCode) {
                    this.initializeStringTable(nArray, byArray, byArray2, nArray2);
                    n7 = (1 << this.initCodeSize) + 2;
                    n8 = this.initCodeSize + 1;
                    n9 = (1 << n8) - 1;
                    n3 = this.getCode(n8, n9);
                    if (n3 == this.eofCode) {
                        this.processImageComplete();
                        return this.theImage;
                    }
                } else {
                    if (n3 == this.eofCode) {
                        this.processImageComplete();
                        return this.theImage;
                    }
                    if (n3 < n7) {
                        n12 = n3;
                    } else {
                        n12 = n6;
                        if (n3 != n7) {
                            this.processWarningOccurred("Out-of-sequence code!");
                        }
                    }
                    n11 = n7++;
                    nArray[n11] = n10 = n6;
                    byArray[n11] = byArray2[n12];
                    byArray2[n11] = byArray2[n10];
                    nArray2[n11] = nArray2[n10] + 1;
                    if (n7 == 1 << n8 && n7 < 4096) {
                        n9 = (1 << ++n8) - 1;
                    }
                }
                n12 = n3;
                n11 = nArray2[n12];
                for (n10 = n11 - 1; n10 >= 0; --n10) {
                    byArray3[n10] = byArray[n12];
                    n12 = nArray[n12];
                }
                this.outputPixels(byArray3, n11);
                n6 = n3;
            }
            this.processReadAborted();
            return this.theImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IIOException("I/O error reading image!", iOException);
        }
    }

    public void reset() {
        super.reset();
        this.resetStreamSettings();
    }

    private void resetStreamSettings() {
        this.gotHeader = false;
        this.streamMetadata = null;
        this.currIndex = -1;
        this.imageMetadata = null;
        this.imageStartPosition = new ArrayList();
        this.numImages = -1;
        this.blockLength = 0;
        this.bitPos = 0;
        this.nextByte = 0;
        this.next32Bits = 0;
        this.lastBlockFound = false;
        this.theImage = null;
        this.theTile = null;
        this.width = -1;
        this.height = -1;
        this.streamX = -1;
        this.streamY = -1;
        this.rowsDone = 0;
        this.interlacePass = 0;
    }
}

