/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeCache;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cache
implements TreeCache {
    private final Map<String, Tree> primary;
    private final Map<String, Tree> secondary;

    public Cache(int n) {
        this(n, new WeakHashMap<String, Tree>());
    }

    public Cache(final int n, Map<String, Tree> map) {
        this.primary = Collections.synchronizedMap(new LinkedHashMap<String, Tree>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Tree> entry) {
                if (this.size() > n) {
                    if (Cache.this.secondary != null) {
                        Cache.this.secondary.put(entry.getKey(), entry.getValue());
                    }
                    return true;
                }
                return false;
            }
        });
        this.secondary = map == null ? null : Collections.synchronizedMap(map);
    }

    @Override
    public Tree get(String string) {
        if (this.secondary == null) {
            return this.primary.get(string);
        }
        Tree tree = this.primary.get(string);
        if (tree == null) {
            tree = this.secondary.get(string);
        }
        return tree;
    }

    @Override
    public void put(String string, Tree tree) {
        this.primary.put(string, tree);
    }
}

