/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl.parse;

import com.huawei.uflight.telnet.wrapper.impl.parse.CKeyValue;
import com.huawei.uflight.telnet.wrapper.impl.parse.CParseCmdID;
import com.huawei.uflight.telnet.wrapper.impl.parse.CParseParams;
import com.huawei.uflight.telnet.wrapper.impl.parse.CParseSearchIndex;
import com.huawei.uflight.telnet.wrapper.impl.parse.StructCliCmdID;
import com.huawei.uflight.telnet.wrapper.impl.parse.StructSearchPos;
import com.huawei.uflight.telnet.wrapper.impl.parse.StructVarResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ParseProcess {
    static final int CHAR_LINE_CR = 13;
    static final int CHAR_LINE_END = 10;
    static final int CHAR_LEFT_BRACKET_S = 40;
    static final int CHAR_RIGHT_BRACKET_S = 41;
    static final int CHAR_LEFT_BRACKET_M = 91;
    static final int CHAR_RIGHT_BRACKET_M = 93;
    static final int CHAR_LEFT_BRACKET_B = 123;
    static final int CHAR_RIGHT_BRACKET_B = 125;
    static final int CHAR_VARIABLE_FLAG = 36;
    static final int CHAR_SELECTOR = 124;
    static final int CHAR_REPEATOR = 42;
    static final int CHAR_TRANSFERRED_MEANING = 92;
    static final int CMDPARSE_BUF_SIZE_DFT = 256;
    static final int CMDPARSE_BUF_SIZE_MIN = 32;
    static final int PARSE_NODE_END_FLAG = 1;
    static final int PARSE_NODE_TYPE_CONST = 1;
    static final int PARSE_NODE_TYPE_VAR = 2;
    static final int PARSE_NODE_TYPE_SEQ = 3;
    static final int PARSE_NODE_PROP_OPTIONAL = 1;
    static final int PARSE_NODE_PROP_SELFINDEX = 2;
    static final int PARSE_NODE_PROP_ALLINDEX = 4;
    static final int PARSE_NODE_PROP_REPEAT = 8;
    static final int PARSE_NODE_PROP_DESC = 1;
    static final int PARSE_NODE_PROP_IP = 2;
    static final int PARSE_INDEXNODE_PROP_SELF = 1;
    static final int CMDPARSE_EXP_STEP_NORMAL = 0;
    static final int CMDPARSE_EXP_STEP_PARAM = 1;
    static final int CMDPARSE_EXP_STEP_TRANS = 2;
    static final int PARSE_SEARCHPOS_STAT_END = 1;
    static final int FAILURE = -1;
    static final int DMS_SUCCESS = 0;
    static final String STRING_DESC = "DESC";
    static final String STRING_IP = "IP";
    static final int CHAR_DEFAULT_LENGHT = 32;
    private List<CParseCmdID> lstCmdInfo = new ArrayList<CParseCmdID>();
    private CParseSearchIndex m_oSearchIndex = new CParseSearchIndex();

    public ParseProcess(List<StructCliCmdID> stCliTempl) {
        this.init(stCliTempl);
    }

    private void init(List<StructCliCmdID> stCliTempl) {
        for (int i = 0; i < stCliTempl.size(); ++i) {
            CParseCmdID pCmdID = new CParseCmdID(stCliTempl.get(i), i);
            pCmdID.getIndex(this.m_oSearchIndex);
            this.lstCmdInfo.add(pCmdID);
        }
    }

    List<CParseParams> doParse(List<String> buffers) {
        LinkedList<CParseParams> lstParseParams = new LinkedList<CParseParams>();
        for (String line : buffers) {
            CParseSearchResult oSearchResult = new CParseSearchResult();
            int length = line.length();
            for (int i = 0; i < length; ++i) {
                oSearchResult.pushChar(line.charAt(i));
            }
            oSearchResult.getParseParam(lstParseParams);
        }
        return lstParseParams;
    }

    static boolean isEqual(char ch, int iPos, CharSequence m_pszBuf) {
        return null != m_pszBuf && iPos >= 0 && iPos < m_pszBuf.length() && ch == m_pszBuf.charAt(iPos);
    }

    private class CParseSearchResult {
        private StringBuilder m_oVarBuf;
        private List<StructVarResult> m_vecVarRet = new ArrayList<StructVarResult>();
        private List<StructSearchPos> m_lstSearchPos = new ArrayList<StructSearchPos>();

        CParseSearchResult() {
            this.m_oVarBuf = new StringBuilder(32);
            StructSearchPos pPos = new StructSearchPos();
            this.m_lstSearchPos.add(pPos);
        }

        int pushChar(char ch) {
            int iRet = -1;
            LinkedList<StructSearchPos> lstNewSPos = new LinkedList<StructSearchPos>();
            Iterator<StructSearchPos> posIterator = this.m_lstSearchPos.iterator();
            while (posIterator.hasNext()) {
                StructSearchPos itSPos = posIterator.next();
                if (0 != (itSPos.getUcStat() & 1)) {
                    itSPos.setConstVarStartPos(this.m_oVarBuf.length());
                    itSPos.setConstVarLen(0);
                    itSPos.setKeyLen(0);
                }
                if (null != itSPos.getConstKey()) {
                    if (0 != itSPos.getConstKey().goNext(ch, itSPos, lstNewSPos, this.m_vecVarRet)) {
                        posIterator.remove();
                        continue;
                    }
                    iRet = 0;
                } else if (null != itSPos.getConstVarNode()) {
                    if (0 != itSPos.getConstVarNode().goNext(ch, itSPos, lstNewSPos, this.m_vecVarRet)) {
                        posIterator.remove();
                        continue;
                    }
                    iRet = 0;
                } else if (null != ParseProcess.this.m_oSearchIndex) {
                    itSPos.setConstVarStartPos(this.m_oVarBuf.length());
                    itSPos.setConstVarLen(0);
                    if (0 == ParseProcess.this.m_oSearchIndex.goNext(ch, itSPos, lstNewSPos, this.m_vecVarRet)) {
                        iRet = 0;
                    }
                }
                itSPos.setConstVarLen(itSPos.getConstVarLen() + 1);
            }
            if (lstNewSPos.size() > 0 && 0 == iRet) {
                for (StructSearchPos itNewPos : lstNewSPos) {
                    itNewPos.setConstVarLen(itNewPos.getConstVarLen() + 1);
                }
                this.m_lstSearchPos.addAll(lstNewSPos);
            }
            this.m_oVarBuf.append(ch);
            return iRet;
        }

        private void getParseParam(List<CParseParams> lstParseParams) {
            CParseParams oParamsRet = null;
            boolean bRetValid = false;
            int iRet = -1;
            for (StructSearchPos itSPos : this.m_lstSearchPos) {
                iRet = this.setLineEnd(itSPos);
                if (0 != iRet || null == itSPos.getConstVarNode() || !itSPos.getConstVarNode().isCmdEnd()) continue;
                bRetValid = true;
                oParamsRet = this.getParseParam(itSPos.getConstVarNode().getCmdID(), itSPos.getVarRet());
                break;
            }
            if (bRetValid && null != oParamsRet) {
                lstParseParams.add(oParamsRet);
            }
        }

        CParseParams getParseParam(String strCmdID, StructVarResult pVarRet) {
            CParseParams oParams = new CParseParams(strCmdID);
            LinkedList<CKeyValue> valueList = new LinkedList<CKeyValue>();
            for (StructVarResult pVarRetVar = pVarRet; null != pVarRetVar; pVarRetVar = pVarRetVar.getPrevVarRet()) {
                String oVarValue = this.m_oVarBuf.substring(pVarRetVar.getVarStartPos(), pVarRetVar.getVarStartPos() + pVarRetVar.getVarLen());
                valueList.addFirst(new CKeyValue(pVarRetVar.getStrVarName(), oVarValue));
            }
            oParams.setValueList(valueList);
            return oParams;
        }

        int setLineEnd(StructSearchPos stSearchPos) {
            if (null != stSearchPos.getConstKey()) {
                return stSearchPos.getConstKey().setLineEnd(stSearchPos, this.m_vecVarRet);
            }
            if (null != stSearchPos.getConstVarNode()) {
                if (0 == (stSearchPos.getUcStat() & 1)) {
                    return stSearchPos.getConstVarNode().setNodeEnd(stSearchPos, this.m_vecVarRet);
                }
                return 0;
            }
            return -1;
        }
    }
}

