/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl.parse;

import com.huawei.uflight.telnet.wrapper.ResponseResult;
import com.huawei.uflight.telnet.wrapper.impl.parse.CKeyValue;
import com.huawei.uflight.telnet.wrapper.impl.parse.OperParse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class GetPropertyOperParse
implements OperParse {
    private List<Pattern> patternList = new ArrayList<Pattern>();
    private List<String> keyStrList = new ArrayList<String>();

    public GetPropertyOperParse(Element mapElement) {
        Iterator iterElements = mapElement.elementIterator("data");
        while (iterElements.hasNext()) {
            Element element = (Element)iterElements.next();
            String dataKey = element.attributeValue("key");
            String dataPattern = element.attributeValue("pattern");
            Pattern pattern = null;
            pattern = null != dataPattern ? Pattern.compile(dataPattern) : Pattern.compile(dataKey);
            this.patternList.add(pattern);
            this.keyStrList.add(dataKey);
        }
    }

    @Override
    public List<CKeyValue> parseStr(List<String> buffers) {
        ArrayList<CKeyValue> valueList = new ArrayList<CKeyValue>();
        block0: for (String line : buffers) {
            if ("".equals(line.trim())) continue;
            for (int i = 0; i < this.patternList.size(); ++i) {
                Pattern matchPatern = this.patternList.get(i);
                Matcher match = matchPatern.matcher(line);
                if (!match.find()) continue;
                int groupCount = match.groupCount();
                if (groupCount < 1) {
                    CKeyValue value = new CKeyValue(this.keyStrList.get(i), null);
                    valueList.add(value);
                    continue block0;
                }
                if (groupCount == 1) {
                    CKeyValue value = new CKeyValue(this.keyStrList.get(i), match.group(1));
                    valueList.add(value);
                    continue block0;
                }
                if (groupCount % 2 != 0) continue block0;
                for (int g = 0; g < groupCount; g += 2) {
                    CKeyValue value = new CKeyValue(match.group(g + 1), match.group(g + 2));
                    valueList.add(value);
                }
                continue block0;
            }
        }
        return valueList;
    }

    @Override
    public ResponseResult.OperType getOperType() {
        return ResponseResult.OperType.GETPROPERTY;
    }
}

