/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl.parse;

import com.huawei.uflight.telnet.wrapper.impl.TelnetException;
import com.huawei.uflight.telnet.wrapper.impl.parse.CParseNodeBase;
import com.huawei.uflight.telnet.wrapper.impl.parse.CParseNodeConst;
import com.huawei.uflight.telnet.wrapper.impl.parse.CParseNodeSequence;
import com.huawei.uflight.telnet.wrapper.impl.parse.CParseNodeVar;
import com.huawei.uflight.telnet.wrapper.impl.parse.CParseSearchIndex;
import com.huawei.uflight.telnet.wrapper.impl.parse.StructCliCmdID;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CParseCmdID {
    private StructCliCmdID cliCmdID;
    private int iCmdIDIndex;
    private CParseNodeBase firstNode;
    private List<CParseNodeBase> vecNode;

    public CParseCmdID(StructCliCmdID cliCmdID, int iCmdIDIndex) {
        this.cliCmdID = cliCmdID;
        this.iCmdIDIndex = iCmdIDIndex;
        this.vecNode = new ArrayList<CParseNodeBase>();
        this.parseExp();
        this.buildIndex();
    }

    private void parseExp() {
        ParseExpression expression = new ParseExpression();
        expression.convertExp2NodeInfo();
    }

    private void buildIndex() {
        for (CParseNodeBase nodeBase : this.vecNode) {
            nodeBase.buildIndex(false);
        }
    }

    void getIndex(CParseSearchIndex oSearchIndex) {
        byte ucIndexProp = 1;
        this.getFirstNode().getIndex(oSearchIndex, false, ucIndexProp);
    }

    String getCmdID() {
        return this.cliCmdID.getStrCmdID();
    }

    int getCmdIDIndex() {
        return this.iCmdIDIndex;
    }

    String getExpression() {
        return this.cliCmdID.getStrExpression();
    }

    void setFirstNode(CParseNodeBase firstNode) {
        this.firstNode = firstNode;
    }

    private CParseNodeBase getFirstNode() {
        return this.firstNode;
    }

    public void addNode(CParseNodeBase pNewNode) {
        this.vecNode.add(pNewNode);
    }

    class StructExpBracketNode {
        char chBracket;
        CParseNodeBase m_pNode;

        StructExpBracketNode() {
        }
    }

    private class ParseExpression {
        private int iProcStep = 0;
        private StringBuilder oParseBuf = new StringBuilder(32);
        private LinkedList<StructExpBracketNode> vecBracketNode = new LinkedList();
        private CParseNodeBase m_pNodeCurr = null;

        ParseExpression() {
        }

        int convertExp2NodeInfo() {
            String strExp = CParseCmdID.this.getExpression();
            block5: for (int i = 0; i < strExp.length(); ++i) {
                char chProc = strExp.charAt(i);
                switch (this.iProcStep) {
                    case 0: {
                        this.procNormalState(chProc);
                        continue block5;
                    }
                    case 1: {
                        this.procParamState(chProc);
                        continue block5;
                    }
                    case 2: {
                        this.procTransState(chProc);
                        continue block5;
                    }
                }
            }
            this.procExpEnd();
            return 0;
        }

        private void procNormalState(char ch) {
            switch (ch) {
                case '(': {
                    this.setConstVarNodeEnd();
                    this.oParseBuf.setLength(0);
                    this.iProcStep = 1;
                    break;
                }
                case '[': 
                case '{': {
                    this.setConstVarNodeEnd();
                    CParseNodeSequence pNode = new CParseNodeSequence(CParseCmdID.this);
                    this.saveNode(pNode);
                    this.pushBracketNode(ch, pNode);
                    break;
                }
                case ']': 
                case '}': {
                    this.setConstVarNodeEnd();
                    CParseNodeBase pBracketNode = this.popBracketNode(ch);
                    pBracketNode.setChildEndNode(this.m_pNodeCurr);
                    this.m_pNodeCurr = pBracketNode;
                    pBracketNode.setExpDataEnd();
                    if (']' != ch) break;
                    pBracketNode.setOptional();
                    break;
                }
                case '$': {
                    this.setConstVarNodeEnd();
                    CParseNodeVar pNode = new CParseNodeVar(CParseCmdID.this);
                    this.saveNode(pNode);
                    this.oParseBuf.setLength(0);
                    break;
                }
                case '|': {
                    if (null == this.m_pNodeCurr) break;
                    this.setConstVarNodeEnd();
                    CParseNodeBase pSeqNode = this.vecBracketNode.getLast().m_pNode;
                    pSeqNode.setChildEndNode(this.m_pNodeCurr);
                    this.m_pNodeCurr = pSeqNode;
                    break;
                }
                case '*': {
                    this.setConstVarNodeEnd();
                    if (null == this.m_pNodeCurr) break;
                    this.m_pNodeCurr.setRepEnable();
                    break;
                }
                case '\\': {
                    this.iProcStep = 2;
                    break;
                }
                default: {
                    this.procNormalChar(ch);
                }
            }
        }

        private void procParamState(char ch) {
            if (')' == ch) {
                if (null != this.m_pNodeCurr) {
                    this.m_pNodeCurr.setParam(this.oParseBuf.toString());
                    this.oParseBuf.setLength(0);
                    this.iProcStep = 0;
                }
            } else {
                this.oParseBuf.append(ch);
            }
        }

        void procTransState(char ch) {
            this.procNormalChar(ch);
            this.iProcStep = 0;
        }

        void procNormalChar(char ch) {
            if (Character.isWhitespace(ch)) {
                this.setConstVarNodeEnd();
                return;
            }
            if (null != this.m_pNodeCurr && 3 != this.m_pNodeCurr.getNodeType() && !this.m_pNodeCurr.isExpDataEnd()) {
                this.oParseBuf.append(ch);
                return;
            }
            CParseNodeConst pNode = new CParseNodeConst(CParseCmdID.this);
            this.saveNode(pNode);
            this.oParseBuf.setLength(0);
            this.oParseBuf.append(ch);
        }

        private void setConstVarNodeEnd() {
            if (!(null == this.m_pNodeCurr || 1 != this.m_pNodeCurr.getNodeType() && 2 != this.m_pNodeCurr.getNodeType() || this.m_pNodeCurr.isExpDataEnd())) {
                this.m_pNodeCurr.setExpData(this.oParseBuf.toString());
                this.m_pNodeCurr.setExpDataEnd();
            }
        }

        void saveNode(CParseNodeBase pNewNode) {
            if (null == CParseCmdID.this.getFirstNode()) {
                CParseCmdID.this.setFirstNode(pNewNode);
            }
            CParseCmdID.this.addNode(pNewNode);
            if (null == this.m_pNodeCurr) {
                this.m_pNodeCurr = pNewNode;
            } else {
                this.m_pNodeCurr.setNextNode(pNewNode);
                this.m_pNodeCurr = pNewNode;
            }
        }

        void pushBracketNode(char chBracket, CParseNodeBase pNode) {
            StructExpBracketNode stBracketNode = new StructExpBracketNode();
            switch (chBracket) {
                case '[': {
                    stBracketNode.chBracket = (char)93;
                    break;
                }
                case '{': {
                    stBracketNode.chBracket = (char)125;
                    break;
                }
                default: {
                    stBracketNode.chBracket = chBracket;
                }
            }
            stBracketNode.m_pNode = pNode;
            this.vecBracketNode.add(stBracketNode);
        }

        private CParseNodeBase popBracketNode(char chBracket) {
            StructExpBracketNode lastNode = this.vecBracketNode.getLast();
            if (lastNode.chBracket != chBracket) {
                throw new TelnetException(-300, "show run config fault :" + CParseCmdID.this.getExpression());
            }
            CParseNodeBase pNode = lastNode.m_pNode;
            this.vecBracketNode.removeLast();
            return pNode;
        }

        void procExpEnd() {
            this.setConstVarNodeEnd();
            if (null != this.m_pNodeCurr) {
                this.m_pNodeCurr.setExpDataEnd();
            }
        }
    }
}

