/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl.expression;

import com.huawei.uflight.telnet.wrapper.impl.TelnetException;
import com.huawei.uflight.telnet.wrapper.impl.expression.Expression;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateProcessor {
    private static Logger logger = LoggerFactory.getLogger(TemplateProcessor.class);

    private TemplateProcessor() {
    }

    public static String process(String cmdTemplate, Map<String, String> cmdParams) {
        if (logger.isDebugEnabled()) {
            logger.debug("process template command is:" + cmdTemplate + " ,cmdParams:" + cmdParams);
        }
        if (null == cmdTemplate || null == cmdParams) {
            logger.error("TemplateProcessor proccess Null Pointer template.");
            return cmdTemplate;
        }
        StringTokenizer tokens = new StringTokenizer(cmdTemplate, "[]", true);
        StringBuilder cmdBuilder = new StringBuilder(cmdTemplate.length());
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("[".equals(token)) {
                if (!tokens.hasMoreTokens()) {
                    throw new TelnetException(-101, "command fragment terminates in [");
                }
                String expressionToken = tokens.nextToken();
                if (!tokens.hasMoreTokens()) {
                    throw new TelnetException(-101, "missing ] after expression in command fragment");
                }
                TemplateProcessor.processSubException(expressionToken, cmdBuilder, cmdParams, true);
                tokens.nextElement();
                continue;
            }
            TemplateProcessor.processSubException(token, cmdBuilder, cmdParams, false);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Return command process result is: " + cmdBuilder.toString());
        }
        return cmdBuilder.toString();
    }

    private static void processSubException(String command, StringBuilder cmdBuilder, Map<String, String> cmdParams, boolean options) {
        StringBuilder subCmdBuilder = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(command, "#}", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("#".equals(token)) {
                if (!tokens.hasMoreTokens()) {
                    throw new TelnetException(-101, "command fragment terminates in command fragment ,command =" + command);
                }
                String expressionToken = tokens.nextToken();
                if (!expressionToken.startsWith("{")) {
                    throw new TelnetException(-101, "missing { after # in command fragment ,command =" + command);
                }
                if (!tokens.hasMoreTokens()) {
                    throw new TelnetException(-101, "missing } after expression in command fragment ,command =" + command);
                }
                String valueExpression = token + expressionToken + tokens.nextToken();
                Object result = Expression.execute(valueExpression, cmdParams);
                String value = "";
                if (result != null) {
                    value = result.toString();
                }
                if (options && StringUtils.isEmpty((String)value)) {
                    return;
                }
                if (!options && StringUtils.isEmpty((String)value)) {
                    throw new TelnetException(-101, "missing value in command fragment " + valueExpression);
                }
                subCmdBuilder.append(value);
                continue;
            }
            subCmdBuilder.append(token);
        }
        cmdBuilder.append((CharSequence)subCmdBuilder);
    }
}

