/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl.config;

import com.huawei.uflight.telnet.ResourceProtocol;
import com.huawei.uflight.telnet.wrapper.DescFileGroup;
import com.huawei.uflight.telnet.wrapper.impl.TelnetException;
import com.huawei.uflight.telnet.wrapper.impl.TelnetUtil;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandMode;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandParam;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandRequest;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandRequestGroup;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandResponse;
import com.huawei.uflight.telnet.wrapper.impl.beans.ContinuePattern;
import com.huawei.uflight.telnet.wrapper.impl.beans.Request;
import com.huawei.uflight.telnet.wrapper.impl.config.Config;
import com.huawei.uflight.telnet.wrapper.impl.config.ConfigItem;
import com.huawei.uflight.telnet.wrapper.impl.config.VersionScope;
import com.huawei.uflight.telnet.wrapper.impl.parse.CustomOperParse;
import com.huawei.uflight.telnet.wrapper.impl.parse.GetPropertyOperParse;
import com.huawei.uflight.telnet.wrapper.impl.parse.GetTableOperParse;
import com.huawei.uflight.telnet.wrapper.impl.parse.OperParse;
import com.huawei.uflight.telnet.wrapper.impl.parse.SetOperParse;
import com.huawei.uflight.telnet.wrapper.impl.parse.ShowRunParse;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDesMgr {
    private static final String VERSIN_SCOPE = "scope";
    private static final String VERSION_ELEMENT = "deviceVersion";
    private static final String INCLUDE_ELEMENT = "include";
    private static final String ATTRIBUTE_NAME_URL = "url";
    private ConcurrentHashMap<String, Config<Request>> requestCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Config<CommandResponse>> responseCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Config<CommandParam>> paramCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Config<CommandMode>> modeCache = new ConcurrentHashMap();
    public static final Logger LOG = LoggerFactory.getLogger(ConfigDesMgr.class);
    private DescParse<Request> requestParse = new RequestParse();
    private DescParse<CommandResponse> responseParse = new ResponseParse();
    private DescParse<CommandParam> paramParse = new CommandParamParse();
    private DescParse<CommandMode> modeParse = new ModeParse();

    public void init() {
        this.requestParse.setCache(this.requestCache);
        this.responseParse.setCache(this.responseCache);
        this.paramParse.setCache(this.paramCache);
        this.modeParse.setCache(this.modeCache);
    }

    public void destroy() {
        this.requestCache.clear();
        this.responseCache.clear();
        this.paramCache.clear();
        this.modeCache.clear();
    }

    public CommandParam getCommandParam(DescFileGroup descGroup, String nameKey, String version) {
        URL url = descGroup.getParamUrl();
        Config<CommandParam> data = this.paramParse.getData(url);
        return this.getConfigObj(data, nameKey, version);
    }

    public Request getCommandRequest(DescFileGroup descGroup, String nameKey, String version) {
        URL url = descGroup.getRequstUrl();
        Config<Request> data = this.requestParse.getData(url);
        return this.getConfigObj(data, nameKey, version);
    }

    public CommandResponse getCommandResponse(DescFileGroup descGroup, String nameKey, String version) {
        URL url = descGroup.getResponseUrl();
        if (null == url) {
            return CommandResponse.DEFAULT_RESPONSE;
        }
        Config<CommandResponse> data = this.responseParse.getData(url);
        CommandResponse resPonse = this.getConfigObj(data, nameKey, version);
        if (null == resPonse) {
            return CommandResponse.DEFAULT_RESPONSE;
        }
        return resPonse;
    }

    public CommandMode getCommandMode(DescFileGroup descGroup, String nameKey, String version) {
        URL url = descGroup.getModelUrl();
        if (null == url || "init_mode".equals(nameKey)) {
            return null;
        }
        Config<CommandMode> data = this.modeParse.getData(url);
        return this.getConfigObj(data, nameKey, version);
    }

    private <T> T getConfigObj(Config<T> config, Object nameKey, String version) {
        return config.getConfigObject(nameKey, version);
    }

    private String getUrlHashStr(URL url) {
        return url.getPath();
    }

    private class ResponseParse
    extends DescParse<CommandResponse> {
        private static final String SET_OPER = "set";
        private static final String GETTABLE_OPER = "getTable";
        private static final String GETPROPERTY_OPER = "getProperty";
        private static final String SHOWRUN_OPER = "showrun";
        private static final String DEFAULT_MATCH = "(\\w+)\\s*:\\s*(\\w+)";
        private PatternCompiler compiler;

        private ResponseParse() {
            this.compiler = new Perl5Compiler();
        }

        @Override
        protected void buildConfigItem(ConfigItem<CommandResponse> configItemObj, Element vesionElement) {
            Element element;
            HashMap<String, String> patternMap = new HashMap<String, String>();
            Element comonElement = vesionElement.element("commonpattern");
            if (null != comonElement) {
                Iterator patternIter = comonElement.elementIterator("pattern");
                while (patternIter.hasNext()) {
                    element = (Element)patternIter.next();
                    String patternID = element.attributeValue("id");
                    String patternStr = element.getTextTrim();
                    patternMap.put(patternID, patternStr);
                }
            }
            Iterator iter = vesionElement.elementIterator("cmd");
            while (iter.hasNext()) {
                element = (Element)iter.next();
                String cmdName = element.attributeValue("name");
                Element responseEle = element.element("response");
                CommandResponse requestObj = this.parseResponseItme(cmdName, responseEle, patternMap);
                configItemObj.addConfigObject(cmdName, requestObj);
            }
        }

        private CommandResponse parseResponseItme(String cmdName, Element responseEle, HashMap<String, String> patternMap) {
            CommandResponse response = new CommandResponse(cmdName);
            String pattern = this.getPattern(responseEle, "success", patternMap);
            response.setSuccessPatterns(pattern);
            pattern = this.getPattern(responseEle, "fail", patternMap);
            response.setFailPatterns(pattern);
            ArrayList<ContinuePattern> continuePatList = new ArrayList<ContinuePattern>();
            Iterator iter = responseEle.elementIterator("continue");
            while (iter.hasNext()) {
                Element continueEle = (Element)iter.next();
                Attribute attribute = continueEle.attribute("pattern");
                if (null == attribute) continue;
                String patternStr = attribute.getValue();
                String replyStr = continueEle.attributeValue("reply", " ");
                continuePatList.add(new ContinuePattern(patternStr, TelnetUtil.replaceSpecialStr(replyStr)));
            }
            response.setContinuePatterns(continuePatList);
            response.setParse(this.getParse(responseEle));
            return response;
        }

        private OperParse getParse(Element responseEle) {
            String responsType = responseEle.attributeValue("type");
            OperParse parse = null;
            parse = SET_OPER.equals(responsType) ? this.getSetParse(responseEle) : (GETTABLE_OPER.equals(responsType) ? this.getTableParse(responseEle) : (GETPROPERTY_OPER.equals(responsType) ? this.getPropertyParse(responseEle) : (SHOWRUN_OPER.equals(responsType) ? this.getShowRunParse(responseEle) : this.getCustomParse(responseEle))));
            return parse;
        }

        private SetOperParse getSetParse(Element responseEle) {
            return new SetOperParse();
        }

        private GetTableOperParse getTableParse(Element responseEle) {
            GetTableOperParse tableOperParse = new GetTableOperParse();
            Element mapElement = responseEle.element("mapping");
            Element titleElement = mapElement.element("title");
            String titleStr = titleElement.attributeValue("value");
            tableOperParse.setTitle(titleStr.split(","));
            Element dataElement = mapElement.element("data");
            String dataStr = dataElement.attributeValue("value");
            try {
                Pattern pattern = this.compiler.compile(dataStr, 1);
                tableOperParse.setPattern(pattern);
            }
            catch (MalformedPatternException e) {
                LOG.error("getTableParse fail" + (Object)((Object)e));
            }
            return tableOperParse;
        }

        private CustomOperParse getCustomParse(Element responseEle) {
            return new CustomOperParse();
        }

        private ShowRunParse getShowRunParse(Element responseEle) {
            Element mapElement = responseEle.element("mapping");
            if (null == mapElement) {
                throw new TelnetException(-101, "fail to getShowRunParse ");
            }
            ShowRunParse runParse = new ShowRunParse(mapElement);
            return runParse;
        }

        private GetPropertyOperParse getPropertyParse(Element responseEle) {
            Element mapElement = responseEle.element("mapping");
            if (null == mapElement) {
                throw new TelnetException(-101, "fail to getPropertyParse");
            }
            GetPropertyOperParse operParse = new GetPropertyOperParse(mapElement);
            return operParse;
        }

        private String getPattern(Element responseEle, String eleName, HashMap<String, String> patternMap) {
            String patternStr;
            Element ele = responseEle.element(eleName);
            if (null == ele) {
                return null;
            }
            Attribute attribute = ele.attribute("pattern");
            if (null != attribute) {
                patternStr = attribute.getValue();
            } else {
                String patternID = ele.attributeValue("refPattern");
                patternStr = patternMap.get(patternID);
            }
            return patternStr;
        }
    }

    private class RequestParse
    extends DescParse<Request> {
        private RequestParse() {
        }

        @Override
        protected void buildConfigItem(ConfigItem<Request> configItemObj, Element vesionElement) {
            Iterator iter = vesionElement.elementIterator("cmd");
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                String cmdName = element.attributeValue("name");
                String modeName = element.attributeValue("mode", "init_mode");
                String request = this.getRequestStr(element);
                CommandRequest requestObj = new CommandRequest(cmdName, request, modeName);
                configItemObj.addConfigObject(cmdName, requestObj);
            }
            this.parseCmdSetItme(configItemObj, vesionElement);
        }

        private void parseCmdSetItme(ConfigItem<Request> configItemObj, Element vesionElement) {
            Iterator iter = vesionElement.elementIterator("cmdset");
            while (iter.hasNext()) {
                Element setElement = (Element)iter.next();
                CommandRequestGroup requestGroup = new CommandRequestGroup(setElement.attributeValue("name"));
                String isQuit = setElement.attributeValue("antoquit", "false");
                requestGroup.setAutoQuit(Boolean.parseBoolean(isQuit));
                ArrayList<String> requestList = new ArrayList<String>();
                Iterator cmditer = setElement.elementIterator("cmdref");
                while (cmditer.hasNext()) {
                    Element cmdElement = (Element)cmditer.next();
                    requestList.add(cmdElement.attributeValue("name"));
                }
                requestGroup.setRequestList(requestList);
                configItemObj.addConfigObject(requestGroup.getName(), requestGroup);
            }
        }
    }

    private class ModeParse
    extends DescParse<CommandMode> {
        private ModeParse() {
        }

        @Override
        protected void buildConfigItem(ConfigItem<CommandMode> configItemObj, Element vesionElement) {
            Element quitModeElement = vesionElement.element("quitmode");
            String quitRequset = this.getRequestStr(quitModeElement);
            Iterator iter = vesionElement.elementIterator("mode");
            HashMap<String, CommandMode> modeMap = new HashMap<String, CommandMode>();
            HashMap<String, String> modeParentsMap = new HashMap<String, String>();
            while (iter.hasNext()) {
                Element modeElement = (Element)iter.next();
                CommandMode obj = this.parseModeItem(modeElement);
                obj.setQuitModeRequst(quitRequset);
                modeMap.put(obj.getName(), obj);
                String modeParent = modeElement.attributeValue("parent", "userRootMode");
                modeParentsMap.put(obj.getName(), modeParent);
            }
            for (CommandMode mode : modeMap.values()) {
                ArrayList<CommandMode> modeParentList = new ArrayList<CommandMode>();
                String parentsName = (String)modeParentsMap.get(mode.getName());
                while (!"userRootMode".equals(parentsName)) {
                    modeParentList.add((CommandMode)modeMap.get(parentsName));
                    parentsName = (String)modeParentsMap.get(parentsName);
                }
                modeParentList.add(CommandMode.INIT_MODE);
                mode.setModeParents(modeParentList);
                configItemObj.addConfigObject(mode.getName(), mode);
            }
        }

        private CommandMode parseModeItem(Element element) {
            String name = element.attributeValue("name");
            String modeRequset = this.getRequestStr(element);
            String matchPattern = this.getSucMatchStr(element);
            CommandMode mode = new CommandMode(name);
            mode.setRequest(modeRequset);
            mode.setMatchPattern(matchPattern);
            return mode;
        }
    }

    private class CommandParamParse
    extends DescParse<CommandParam> {
        private CommandParamParse() {
        }

        @Override
        protected void buildConfigItem(ConfigItem<CommandParam> configItemObj, Element vesionElement) {
            Iterator paramIter = vesionElement.elementIterator("param");
            while (paramIter.hasNext()) {
                Element paramElement = (Element)paramIter.next();
                CommandParam obj = this.parseParamItme(paramElement);
                configItemObj.addConfigObject(obj.getName(), obj);
            }
        }

        private CommandParam parseParamItme(Element paramElement) {
            String name = paramElement.attributeValue("name");
            String type = paramElement.attributeValue("type");
            String range = paramElement.attributeValue("range", "default");
            String isnotNull = paramElement.attributeValue("not-null", "true");
            return CommandParam.getCommandParam(name, type, range, isnotNull);
        }
    }

    private abstract class DescParse<T> {
        private ConcurrentHashMap<String, Config<T>> cache;

        private DescParse() {
        }

        public void setCache(ConcurrentHashMap<String, Config<T>> cache) {
            this.cache = cache;
        }

        public Config<T> getData(URL url) {
            Config<T> paramConfig = this.cache.get(ConfigDesMgr.this.getUrlHashStr(url));
            if (null == paramConfig) {
                paramConfig = this.parse(url);
                this.cache.putIfAbsent(ConfigDesMgr.this.getUrlHashStr(url), paramConfig);
            }
            return paramConfig;
        }

        private Config<T> parse(URL url) {
            Config configMibTableObj = new Config();
            Element rootElement = this.getRootElement(url);
            Iterator vesionIter = rootElement.elementIterator(ConfigDesMgr.VERSION_ELEMENT);
            while (vesionIter.hasNext()) {
                Element vesionElement = (Element)vesionIter.next();
                ConfigItem<T> configItemObj = new ConfigItem<T>();
                this.parseVersionItme(vesionElement, configItemObj);
                this.buildConfigItem(configItemObj, vesionElement);
                Iterator includeIter = vesionElement.elementIterator(ConfigDesMgr.INCLUDE_ELEMENT);
                while (includeIter.hasNext()) {
                    Element includeElement = (Element)includeIter.next();
                    String resourceStr = includeElement.attributeValue(ConfigDesMgr.ATTRIBUTE_NAME_URL);
                    URL inclueUrl = ResourceProtocol.getURL(resourceStr);
                    Config<T> includeMibConfig = this.parse(inclueUrl);
                    configItemObj.addIncludeConfig(includeMibConfig);
                }
                configMibTableObj.addConfigItem(configItemObj);
            }
            return configMibTableObj;
        }

        private void parseVersionItme(Element vesionElement, ConfigItem<T> configItemObj) {
            String versionDesc = vesionElement.attributeValue(ConfigDesMgr.VERSIN_SCOPE);
            configItemObj.setVersionScope(new VersionScope(versionDesc));
        }

        protected String getRequestStr(Element element) {
            return element.element("request").getTextTrim();
        }

        protected String getSucMatchStr(Element element) {
            return element.element("success").attributeValue("pattern");
        }

        private Element getRootElement(URL url) {
            SAXReader saxReader = new SAXReader();
            Element rootElement = null;
            try {
                Document document = saxReader.read(url);
                rootElement = document.getRootElement();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("not find file by urlName =" + url);
            }
            return rootElement;
        }

        protected abstract void buildConfigItem(ConfigItem<T> var1, Element var2);
    }
}

