/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl.beans;

import com.huawei.uflight.telnet.wrapper.impl.verify.IPVerify;
import com.huawei.uflight.telnet.wrapper.impl.verify.NumRangeVerify;
import com.huawei.uflight.telnet.wrapper.impl.verify.StrLenVerify;
import com.huawei.uflight.telnet.wrapper.impl.verify.Verify;
import java.util.ArrayList;
import java.util.List;

public class CommandParam {
    public static final String DEFAULT_RANGE = "default";
    private static final String PARAM_STRING = "string";
    private static final String PARAM_INT = "int";
    private static final String PARAM_IP = "ip";
    private String name;
    private boolean notNull = true;
    private List<Verify> paramVerify = new ArrayList<Verify>(1);

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addVerify(Verify verify) {
        this.paramVerify.add(verify);
    }

    public boolean verify(String value) {
        if (this.notNull && null == value) {
            return false;
        }
        if (!this.notNull && null == value) {
            return true;
        }
        boolean result = true;
        for (Verify verify : this.paramVerify) {
            if (verify.verify(value)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static CommandParam getCommandParam(String paramName, String paramType, String range, String isNull) {
        boolean isNotNull = Boolean.getBoolean(isNull);
        CommandParam param = new CommandParam();
        param.setName(paramName);
        param.setNotNull(isNotNull);
        if (DEFAULT_RANGE.equals(range)) {
            return param;
        }
        if (PARAM_STRING.equals(paramType)) {
            param.addVerify(new StrLenVerify(range));
        } else if (PARAM_INT.equals(paramType)) {
            param.addVerify(new NumRangeVerify(range));
        } else if (PARAM_IP.equals(paramType)) {
            param.addVerify(new IPVerify());
        }
        return param;
    }
}

