/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl;

import com.huawei.uflight.telnet.wrapper.DescFileGroup;
import com.huawei.uflight.telnet.wrapper.ICancel;
import com.huawei.uflight.telnet.wrapper.ITelnetCallBack;
import com.huawei.uflight.telnet.wrapper.ITelnetDataSource;
import com.huawei.uflight.telnet.wrapper.ITelnetWrapper;
import com.huawei.uflight.telnet.wrapper.ResponseResult;
import com.huawei.uflight.telnet.wrapper.impl.AbstractCommand;
import com.huawei.uflight.telnet.wrapper.impl.ConnectionPoolMgr;
import com.huawei.uflight.telnet.wrapper.impl.DeviceCommand;
import com.huawei.uflight.telnet.wrapper.impl.DeviceCommandGroup;
import com.huawei.uflight.telnet.wrapper.impl.TelnetConnect;
import com.huawei.uflight.telnet.wrapper.impl.TelnetException;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandMode;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandParam;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandRequest;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandRequestGroup;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandResponse;
import com.huawei.uflight.telnet.wrapper.impl.beans.Request;
import com.huawei.uflight.telnet.wrapper.impl.config.ConfigDesMgr;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetWrapperImpl
implements ITelnetWrapper {
    private ITelnetDataSource dataSource;
    private ConfigDesMgr configMgr;
    private ConnectionPoolMgr connection = null;
    private int maxCurrentNum = 16;
    private static final int THREAD_KEEPLIVE_MINUTE = 1;
    private ThreadPoolExecutor scheduler = null;
    private static final int QUEUE_INIT_SIZE = 100;
    public static final int DEFAULT_TIMEOUT = 60000;
    private static final Logger log = LoggerFactory.getLogger(TelnetWrapperImpl.class);
    private Comparator<IPriorityTask> actionTaskComparator = new Comparator<IPriorityTask>(){

        @Override
        public int compare(IPriorityTask o1, IPriorityTask o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };

    public TelnetWrapperImpl() {
        PriorityBlockingQueue<IPriorityTask> blockingQueue = new PriorityBlockingQueue<IPriorityTask>(100, this.actionTaskComparator);
        this.scheduler = new ThreadPoolExecutor(this.maxCurrentNum, this.maxCurrentNum, 1L, TimeUnit.MINUTES, blockingQueue);
        this.scheduler.setThreadFactory(new TelnetThreadFactory());
        this.scheduler.allowCoreThreadTimeOut(true);
        this.configMgr = new ConfigDesMgr();
        this.connection = new ConnectionPoolMgr();
        this.configMgr.init();
    }

    public void setTelnetSource(ITelnetDataSource dataSource) {
        this.dataSource = dataSource;
        this.connection.setTelnetSource(dataSource);
    }

    private ResponseResult send(DescFileGroup descGroup, String operName, String devFDN, Map<String, String> params, ICancel cancel) {
        String version;
        if (log.isDebugEnabled()) {
            log.debug("begin telnet command, descFileGroup =" + descGroup + "\r\n" + " operName = " + operName + " devFDN = " + devFDN + "\r\n" + "params =" + params);
        }
        if (!this.verifyParam(descGroup, version = this.dataSource.getDevVersion(devFDN), params)) {
            return new ResponseResult(-100);
        }
        AbstractCommand command = this.buildCommand(descGroup, operName, version);
        command.setCancelImp(cancel);
        return this.send(command, devFDN, params);
    }

    @Override
    public ResponseResult send(DescFileGroup descGroup, String operName, String devFDN, Map<String, String> params, ICancel ... cancel) {
        ICancel cancleImp = null;
        cancleImp = cancel.length != 0 ? cancel[0] : new ICancel();
        return this.send(descGroup, operName, devFDN, params, cancleImp);
    }

    private AbstractCommand buildCommand(DescFileGroup descGroup, String operName, String version) {
        Request request = this.configMgr.getCommandRequest(descGroup, operName, version);
        AbstractCommand command = null;
        if (request.isSingle()) {
            CommandRequest comRequest = (CommandRequest)request;
            command = this.getCommand(comRequest, descGroup, version);
        } else {
            CommandRequestGroup requestGroup = (CommandRequestGroup)request;
            command = this.getCommandGroup(requestGroup, descGroup, version);
        }
        return command;
    }

    private ResponseResult send(AbstractCommand command, String devFDN, Map<String, String> params) {
        TelnetTaskCallAble commandCall = new TelnetTaskCallAble(command, devFDN, params);
        return commandCall.doTask();
    }

    @Override
    public void asyncSend(DescFileGroup descGroup, String operName, String devFDN, Map<String, String> params, ITelnetCallBack callBack) {
        String version = this.dataSource.getDevVersion(devFDN);
        if (!this.verifyParam(descGroup, version, params)) {
            callBack.handleResponse(new ResponseResult(-100));
        }
        AbstractCommand command = this.buildCommand(descGroup, operName, version);
        command.setCancelImp(callBack);
        this.asyncSend(command, devFDN, params, callBack);
    }

    private void asyncSend(AbstractCommand command, String devFDN, Map<String, String> params, ITelnetCallBack callBack) {
        TelnetTaskRunnAble commandRunnalbe = new TelnetTaskRunnAble(command, devFDN, params, callBack);
        this.scheduler.execute(commandRunnalbe);
    }

    private boolean verifyParam(DescFileGroup descGroup, String version, Map<String, String> params) {
        if (null == params || null == descGroup.getParamUrl()) {
            return true;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            CommandParam param = this.configMgr.getCommandParam(descGroup, key, version);
            if (null == param || param.verify(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private DeviceCommand getCommand(CommandRequest comRequest, DescFileGroup descGroup, String version) {
        String operName = comRequest.getName();
        CommandMode mode = this.configMgr.getCommandMode(descGroup, comRequest.getMode(), version);
        CommandResponse resPonse = this.configMgr.getCommandResponse(descGroup, operName, version);
        DeviceCommand command = new DeviceCommand(mode, comRequest, resPonse);
        return command;
    }

    private DeviceCommandGroup getCommandGroup(CommandRequestGroup requestGroup, DescFileGroup descGroup, String version) {
        ArrayList<String> requestList = requestGroup.getRequestList();
        ArrayList<DeviceCommand> commands = new ArrayList<DeviceCommand>(requestList.size());
        for (String requestName : requestList) {
            CommandRequest subRequest = (CommandRequest)this.configMgr.getCommandRequest(descGroup, requestName, version);
            CommandMode mode = this.configMgr.getCommandMode(descGroup, subRequest.getMode(), version);
            CommandResponse resPonse = this.configMgr.getCommandResponse(descGroup, requestName, version);
            DeviceCommand subCommand = new DeviceCommand(mode, subRequest, resPonse);
            commands.add(subCommand);
        }
        DeviceCommandGroup command = new DeviceCommandGroup(commands);
        command.setAutoQuit(requestGroup.isAutoQuit());
        return command;
    }

    static class TelnetThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "telnetpool-" + poolNumber.getAndIncrement() + "-thread-";

        TelnetThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static interface IPriorityTask {
        public static final int LOW_PRIORITY = 1;
        public static final int HIGH_PRIORITY = 100;

        public int getPriority();
    }

    private class TelnetTaskCallAble
    extends TelnetTask
    implements Callable<ResponseResult>,
    IPriorityTask {
        TelnetTaskCallAble(AbstractCommand command, String devFDN, Map<String, String> params) {
            super(command, devFDN, params);
        }

        @Override
        public ResponseResult call() {
            return this.doTask();
        }

        @Override
        public int getPriority() {
            return 100;
        }
    }

    private class TelnetTaskRunnAble
    extends TelnetTask
    implements Runnable,
    IPriorityTask {
        private ITelnetCallBack callBack;

        TelnetTaskRunnAble(AbstractCommand command, String devFDN, Map<String, String> params, ITelnetCallBack callBack) {
            super(command, devFDN, params);
            this.callBack = callBack;
        }

        @Override
        public void run() {
            if (!this.callBack.isCancel()) {
                this.callBack.handleResponse(this.doTask());
            } else {
                this.callBack.handleResponse(new ResponseResult(-301));
            }
        }

        @Override
        public int getPriority() {
            return 1;
        }
    }

    private class TelnetTask {
        private final AbstractCommand command;
        private final String devFDN;
        private final Map<String, String> params;

        TelnetTask(AbstractCommand command, String devFDN, Map<String, String> params) {
            this.command = command;
            this.devFDN = devFDN;
            this.params = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResponseResult doTask() {
            this.command.init(this.params);
            TelnetConnect connect = TelnetWrapperImpl.this.connection.get(this.devFDN);
            ResponseResult result = null;
            try {
                connect.checkConnect(TelnetWrapperImpl.this.dataSource.getTelnetParams(this.devFDN));
                result = this.command.execute(connect, this.params);
            }
            catch (TelnetException e) {
                log.error("command execute fail", (Throwable)e);
                result = new ResponseResult(e.getErrCode());
            }
            finally {
                TelnetWrapperImpl.this.connection.put(this.devFDN, connect);
            }
            return result;
        }
    }
}

