/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl;

import com.huawei.uflight.extension.IExtension;
import com.huawei.uflight.msf.IMOServiceLocator;
import com.huawei.uflight.telnet.ResourceProtocol;
import com.huawei.uflight.telnet.wrapper.DescFileGroup;
import com.huawei.uflight.telnet.wrapper.ICancel;
import com.huawei.uflight.telnet.wrapper.ITelnetCallBack;
import com.huawei.uflight.telnet.wrapper.ITelnetDataSource;
import com.huawei.uflight.telnet.wrapper.ITelnetWrapper;
import com.huawei.uflight.telnet.wrapper.ITelnetWrapperEx;
import com.huawei.uflight.telnet.wrapper.ResponseResult;
import com.huawei.uflight.telnet.wrapper.impl.TelnetConfigXB;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetWrapperExImpl
implements ITelnetWrapperEx {
    private ITelnetWrapper wrapperImpl = null;
    private IMOServiceLocator moLocator = null;
    private ITelnetDataSource dataSource = null;
    private static final String WRAPPER_EXTPOINT = "com.huawei.uflight.telnetWrapper";
    private static final Logger log = LoggerFactory.getLogger(TelnetWrapperExImpl.class);

    public TelnetWrapperExImpl(ITelnetWrapper wrapperImpl) {
        this.wrapperImpl = wrapperImpl;
    }

    public void setMoServiceLocator(IMOServiceLocator locator) {
        this.moLocator = locator;
    }

    public void setTelnetSource(ITelnetDataSource dataSource) {
        this.dataSource = dataSource;
    }

    private DescFileGroup getDescFileGroup(String devFDN, String functionID) {
        String devType = this.dataSource.getDevType(devFDN);
        String devVersion = this.dataSource.getDevVersion(devFDN);
        List extList = this.moLocator.getExtensions(devType, devVersion, functionID, WRAPPER_EXTPOINT);
        IExtension deseExt = (IExtension)extList.get(0);
        TelnetConfigXB pathBean = (TelnetConfigXB)deseExt.getExtensionObject(TelnetConfigXB.class);
        DescFileGroup fileGroup = new DescFileGroup();
        fileGroup.setRequstUrl(ResourceProtocol.getURL(pathBean.getRequestPath()));
        fileGroup.setParamUrl(ResourceProtocol.getURL(pathBean.getParamPath()));
        fileGroup.setResponseUrl(ResourceProtocol.getURL(pathBean.getResponsePath()));
        fileGroup.setModelUrl(ResourceProtocol.getURL(pathBean.getModePath()));
        return fileGroup;
    }

    @Override
    public ResponseResult send(String functionID, String operName, String devFDN, Map<String, String> params, ICancel ... cancel) {
        DescFileGroup descGroup = this.getDescFileGroup(devFDN, functionID);
        return this.wrapperImpl.send(descGroup, operName, devFDN, params, cancel);
    }

    @Override
    public void asyncSend(String functionID, String operName, String devFDN, Map<String, String> params, ITelnetCallBack callBack) {
        DescFileGroup descGroup = this.getDescFileGroup(devFDN, functionID);
        this.wrapperImpl.asyncSend(descGroup, operName, devFDN, params, callBack);
    }
}

